/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import com.tmtravlr.lootoverhaul.utilities.BlockStateMatcher;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionNearBlock
implements LootCondition {
    private String[] blocks;
    private LootHelper.RangeFloat metaRange;
    private int[] metaList;
    private int radius;
    private BlockStateMatcher[] states;

    public ConditionNearBlock(String[] blocksToSet, LootHelper.RangeFloat metaRangeToSet, int[] metaListToSet, int radiusToSet, BlockStateMatcher[] statesToSet) {
        this.blocks = blocksToSet;
        this.metaRange = metaRangeToSet;
        this.metaList = metaListToSet;
        this.radius = radiusToSet;
        this.states = statesToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        BlockPos origin = LootHelper.getPosFromContext(context);
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (origin != null) {
            for (int x = origin.func_177958_n() - this.radius; x <= origin.func_177958_n() + this.radius; ++x) {
                for (int y = origin.func_177956_o() - this.radius; y <= origin.func_177956_o() + this.radius; ++y) {
                    for (int z = origin.func_177952_p() - this.radius; z <= origin.func_177952_p() + this.radius; ++z) {
                        pos.func_181079_c(x, y, z);
                        IBlockState state = context.getWorld().func_180495_p((BlockPos)pos);
                        Block block = state.func_177230_c();
                        int meta = block.func_176201_c(state);
                        if (this.metaRange != null && !this.metaRange.isInRange(Float.valueOf(meta)) || this.metaList != null && !Arrays.asList(new int[][]{this.metaList}).contains(meta)) continue;
                        if (this.states != null) {
                            boolean stateMatches = true;
                            for (BlockStateMatcher stateMatcher : this.states) {
                                if (stateMatcher.matches(state)) continue;
                                stateMatches = false;
                            }
                            if (!stateMatches) continue;
                        }
                        if (this.blocks != null) {
                            boolean blockMatches = false;
                            for (String blockName : this.blocks) {
                                Block blockToCheck = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockName));
                                if (blockToCheck != block) continue;
                                blockMatches = true;
                            }
                            if (!blockMatches) continue;
                        }
                        pos.func_185344_t();
                        return true;
                    }
                }
            }
        }
        pos.func_185344_t();
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionNearBlock> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "near_block"), ConditionNearBlock.class);
        }

        public void serialize(JsonObject json, ConditionNearBlock value, JsonSerializationContext context) {
            if (value.blocks != null) {
                LootHelper.serializeStringArray(value.blocks, json, "block");
            }
            if (value.metaList != null) {
                LootHelper.serializeIntArray(value.metaList, json, "meta");
            } else if (value.metaRange != null) {
                value.metaRange.serialize(json, "meta");
            }
            if (value.states != null) {
                BlockStateMatcher.serialize(value.states, json, "state");
            }
            json.addProperty("radius", (Number)value.radius);
        }

        public ConditionNearBlock deserialize(JsonObject json, JsonDeserializationContext context) {
            String[] blocks = null;
            LootHelper.RangeFloat metaRange = null;
            int[] metaList = null;
            BlockStateMatcher[] states = null;
            if (json.has("block")) {
                blocks = LootHelper.deserializeStringArray(json, "block");
            }
            if (json.has("meta")) {
                if (json.get("meta").isJsonObject()) {
                    metaRange = LootHelper.deserializeRangeFloat(json, "meta");
                } else {
                    metaList = LootHelper.deserializeIntArray(json, "meta");
                }
            }
            if (json.has("state")) {
                states = BlockStateMatcher.deserialize(json, "state");
            }
            int radius = JsonUtils.func_151203_m((JsonObject)json, (String)"radius");
            return new ConditionNearBlock(blocks, metaRange, metaList, radius, states);
        }
    }
}

