/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionMoon
implements LootCondition {
    private MoonPhase[] moonPhases;

    public ConditionMoon(MoonPhase[] moonPhases) {
        this.moonPhases = moonPhases;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        int moonPhaseIndex = context.getWorld().field_73011_w.func_76559_b(context.getWorld().func_72820_D());
        MoonPhase currentMoonPhase = MoonPhase.getMoonPhaseFromIndex(moonPhaseIndex);
        for (MoonPhase moonPhase : this.moonPhases) {
            if (currentMoonPhase != moonPhase) continue;
            return true;
        }
        return false;
    }

    static enum MoonPhase {
        FULL(0),
        WANING_GIBBOUS(1),
        LAST_QUARTER(2),
        WANING_CRECENT(3),
        NEW(4),
        WAXING_CRECENT(5),
        FIRST_QUARTER(6),
        WAXING_GIBBOUS(7);

        private int phaseIndex;

        private MoonPhase(int phaseIndex) {
            this.phaseIndex = phaseIndex;
        }

        public static MoonPhase getMoonPhaseFromIndex(int index) {
            for (MoonPhase phase : MoonPhase.values()) {
                if (index != phase.phaseIndex) continue;
                return phase;
            }
            return null;
        }
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionMoon> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "moon_phase"), ConditionMoon.class);
        }

        public void serialize(JsonObject json, ConditionMoon value, JsonSerializationContext context) {
            String[] phaseStrings = new String[value.moonPhases.length];
            for (int i = 0; i < value.moonPhases.length; ++i) {
                phaseStrings[i] = value.moonPhases[i].name().toLowerCase();
            }
            LootHelper.serializeStringArray(phaseStrings, json, "phase");
        }

        public ConditionMoon deserialize(JsonObject json, JsonDeserializationContext context) {
            String[] phaseStrings = LootHelper.deserializeStringArray(json, "phase");
            MoonPhase[] phases = new MoonPhase[phaseStrings.length];
            for (int i = 0; i < phaseStrings.length; ++i) {
                MoonPhase phase = MoonPhase.valueOf(phaseStrings[i].toUpperCase());
                if (phase == null) {
                    throw new JsonSyntaxException("Moon phase '" + phaseStrings[i] + "' not recognized; it must be NEW, WAXING_CRECENT, FIRST_QUARTER, WAXING_GIBBOUS, FULL, WANING_GIBBOUS, LAST_QUARTER, or WANING_CRECENT.");
                }
                phases[i] = phase;
            }
            return new ConditionMoon(phases);
        }
    }
}

