/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import com.tmtravlr.lootoverhaul.utilities.SavedData;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionGlobalVar
implements LootCondition {
    private String name;
    private String type;
    private NBTBase[] valueList;
    private LootHelper.RangeFloat valueRange;

    public ConditionGlobalVar(String nameToSet, String typeToSet, NBTBase[] valuesToSet, LootHelper.RangeFloat rangeToSet) {
        this.name = nameToSet;
        this.type = typeToSet;
        this.valueList = valuesToSet;
        this.valueRange = rangeToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        SavedData globalSavedData = SavedData.getSavedData(context.getWorld().func_73046_m().func_130014_f_());
        if (this.type.isEmpty()) {
            SavedData.StoredVar var = globalSavedData.getGlobalVar(this.name);
            return var != null;
        }
        if (this.valueRange == null && this.valueList == null) {
            SavedData.StoredVar var = globalSavedData.getGlobalVar(this.name);
            return var != null && var.getType() == this.type;
        }
        SavedData.StoredVar var = globalSavedData.getGlobalVarByType(this.name, this.type);
        if (this.valueRange != null) {
            if (var instanceof SavedData.StoredVarFloat) {
                return this.valueRange.isInRange(Float.valueOf(((SavedData.StoredVarFloat)var).value));
            }
            if (var instanceof SavedData.StoredVarInt) {
                return this.valueRange.isInRange(Float.valueOf(((SavedData.StoredVarInt)var).value));
            }
        }
        if (this.valueList != null) {
            for (NBTBase value : this.valueList) {
                if (!value.equals((Object)var.toNBT())) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionGlobalVar> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "global_variable"), ConditionGlobalVar.class);
        }

        public void serialize(JsonObject json, ConditionGlobalVar value, JsonSerializationContext context) {
            json.add("name", (JsonElement)new JsonPrimitive(value.name));
            json.add("type", (JsonElement)new JsonPrimitive(value.type));
            if (value.valueList.length == 1) {
                LootHelper.serializeNBT(json, "value", value.valueList[0]);
            }
            JsonArray array = new JsonArray();
            for (NBTBase base : value.valueList) {
                JsonObject innerJson = new JsonObject();
                LootHelper.serializeNBT(innerJson, "value", base);
                array.add((JsonElement)innerJson);
            }
            json.add("value", (JsonElement)array);
        }

        public ConditionGlobalVar deserialize(JsonObject json, JsonDeserializationContext context) {
            NBTBase[] array = null;
            LootHelper.RangeFloat range = null;
            String type = JsonUtils.func_151219_a((JsonObject)json, (String)"type", (String)"");
            if (!type.isEmpty() && json.has("value")) {
                if ((type.equalsIgnoreCase("float") || type.equalsIgnoreCase("integer")) && json.has("value") && json.get("value").isJsonObject()) {
                    range = LootHelper.deserializeRangeFloat(json, "value");
                } else {
                    array = LootHelper.deserializeNBTArray(json, "value");
                }
            }
            return new ConditionGlobalVar(JsonUtils.func_151200_h((JsonObject)json, (String)"name"), type, array, range);
        }
    }
}

