/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.INpc;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionEntityType
implements LootCondition {
    private String[] entityTypes;
    private List<EntityCategory> entityCategories = new ArrayList<EntityCategory>();

    public ConditionEntityType(String[] entityTypesToSet, List<EntityCategory> entityCategoriesToSet) {
        this.entityTypes = entityTypesToSet;
        this.entityCategories = entityCategoriesToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        Entity entity = null;
        boolean matches = false;
        if (context.func_186493_a() != null) {
            entity = context.func_186493_a();
        }
        if (entity != null) {
            if (this.entityTypes != null) {
                for (String entityTypeName : this.entityTypes) {
                    ResourceLocation entityType = new ResourceLocation(entityTypeName);
                    if (!entityType.equals((Object)EntityList.func_191301_a((Entity)entity))) continue;
                    matches = true;
                }
            }
            for (EntityCategory category : this.entityCategories) {
                if (category.getCreatureAttribute() != null && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == category.getCreatureAttribute()) {
                    matches = true;
                }
                if (category == EntityCategory.MONSTER) {
                    if (!(entity instanceof IMob)) continue;
                    matches = true;
                    continue;
                }
                if (category == EntityCategory.ANIMAL) {
                    if (!(entity instanceof EntityAnimal)) continue;
                    matches = true;
                    continue;
                }
                if (category == EntityCategory.AMBIENT) {
                    if (!(entity instanceof EntityAmbientCreature) && !(entity instanceof EntitySquid)) continue;
                    matches = true;
                    continue;
                }
                if (category == EntityCategory.NPC) {
                    if (!(entity instanceof INpc)) continue;
                    matches = true;
                    continue;
                }
                if (category != EntityCategory.GOLEM || !(entity instanceof EntityGolem)) continue;
                matches = true;
            }
        }
        return matches;
    }

    private static enum EntityCategory {
        MONSTER,
        ANIMAL,
        AMBIENT,
        NPC,
        GOLEM,
        UNDEAD(EnumCreatureAttribute.UNDEAD),
        ARTHROPOD(EnumCreatureAttribute.ARTHROPOD),
        ILLAGER(EnumCreatureAttribute.ILLAGER);

        private EnumCreatureAttribute creatureAttribute;

        private EntityCategory() {
            this(null);
        }

        private EntityCategory(EnumCreatureAttribute creatureAttribute) {
            this.creatureAttribute = creatureAttribute;
        }

        public EnumCreatureAttribute getCreatureAttribute() {
            return this.creatureAttribute;
        }
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionEntityType> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "entity_type"), ConditionEntityType.class);
        }

        public void serialize(JsonObject json, ConditionEntityType value, JsonSerializationContext context) {
            if (value.entityTypes != null) {
                LootHelper.serializeStringArray(value.entityTypes, json, "type");
            }
            if (!value.entityCategories.isEmpty()) {
                LootHelper.serializeStringArray(value.entityCategories.stream().map(Enum::name).collect(Collectors.toList()).toArray(new String[0]), json, "category");
            }
        }

        public ConditionEntityType deserialize(JsonObject json, JsonDeserializationContext context) {
            if (!json.has("type") && !json.has("category")) {
                throw new JsonSyntaxException("Expected one or both fields 'type' and 'category'");
            }
            String[] entityTypes = null;
            String[] entityCategoryNames = null;
            ArrayList<EntityCategory> entityCategories = new ArrayList<EntityCategory>();
            if (json.has("type")) {
                entityTypes = LootHelper.deserializeStringArray(json, "type");
            }
            if (json.has("category")) {
                entityCategoryNames = LootHelper.deserializeStringArray(json, "category");
            }
            if (entityCategoryNames != null) {
                Arrays.stream(entityCategoryNames).forEach(categoryName -> {
                    try {
                        entityCategories.add(EntityCategory.valueOf(categoryName.toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException("Invalid entity category name '" + categoryName + "'. Possible values are MONSTER, ANIMAL, AMBIENT, NPC, GOLEM, UNDEAD, ARTHROPOD, ILLAGER", (Throwable)e);
                    }
                });
            }
            return new ConditionEntityType(entityTypes, entityCategories);
        }
    }
}

