/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionDifficulty
implements LootCondition {
    private String[] difficulties;
    private LootHelper.RangeFloat additional;

    public ConditionDifficulty(String[] difficultiesToSet, LootHelper.RangeFloat additionalRange) {
        this.difficulties = difficultiesToSet;
        this.additional = additionalRange;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        BlockPos pos = LootHelper.getPosFromContext(context);
        String globalDifficulty = context.getWorld().func_175659_aa().name().toLowerCase();
        float currentAdditional = 0.0f;
        if (pos != null) {
            currentAdditional = context.getWorld().func_175649_E(pos).func_180168_b();
        }
        for (String difficulty : this.difficulties) {
            if (context.getWorld().func_72912_H().func_76093_s() && difficulty.equalsIgnoreCase("hardcore")) {
                return true;
            }
            if (!globalDifficulty.equalsIgnoreCase(difficulty)) continue;
            return true;
        }
        if (this.additional.min != null || this.additional.max != null) {
            return this.additional.isInRange(Float.valueOf(currentAdditional));
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionDifficulty> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "difficulty"), ConditionDifficulty.class);
        }

        public void serialize(JsonObject json, ConditionDifficulty value, JsonSerializationContext context) {
            if (value.difficulties.length > 0) {
                LootHelper.serializeStringArray(value.difficulties, json, "difficulty");
            }
            if (((ConditionDifficulty)value).additional.min != null && ((ConditionDifficulty)value).additional.max != null) {
                value.additional.serialize(json, "regional");
            }
        }

        public ConditionDifficulty deserialize(JsonObject json, JsonDeserializationContext context) {
            if (!JsonUtils.func_151204_g((JsonObject)json, (String)"difficulty") && !JsonUtils.func_151204_g((JsonObject)json, (String)"regional")) {
                throw new JsonSyntaxException("Expected one or both fields 'difficulty' and 'regional'");
            }
            String[] difficulties = new String[]{};
            LootHelper.RangeFloat regional = new LootHelper.RangeFloat(null, null);
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"difficulty")) {
                difficulties = LootHelper.deserializeStringArray(json, "difficulty");
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"regional")) {
                regional = LootHelper.deserializeRangeFloat(json, "regional");
            }
            return new ConditionDifficulty(difficulties, regional);
        }
    }
}

