/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.Random;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class ConditionBiome
implements LootCondition {
    private final Biome[] biomes;

    public ConditionBiome(Biome[] biomesToSet) {
        this.biomes = biomesToSet;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        BlockPos pos = LootHelper.getPosFromContext(context);
        if (pos != null) {
            for (Biome biome : this.biomes) {
                if (context.getWorld().func_180494_b(pos) != biome) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ConditionBiome> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "biome"), ConditionBiome.class);
        }

        public void serialize(JsonObject json, ConditionBiome value, JsonSerializationContext context) {
            if (value.biomes.length == 1) {
                json.add("biome", (JsonElement)new JsonPrimitive(((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)value.biomes[0])).toString()));
            } else {
                JsonArray biomeList = new JsonArray();
                for (Biome biome : value.biomes) {
                    biomeList.add((JsonElement)new JsonPrimitive(((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome)).toString()));
                }
                json.add("biome", (JsonElement)biomeList);
            }
        }

        public ConditionBiome deserialize(JsonObject json, JsonDeserializationContext context) {
            if (JsonUtils.func_151205_a((JsonObject)json, (String)"biome")) {
                return new ConditionBiome(new Biome[]{this.getBiomeFromString(JsonUtils.func_151200_h((JsonObject)json, (String)"biome"))});
            }
            JsonArray biomeArray = JsonUtils.func_151214_t((JsonObject)json, (String)"biome");
            Biome[] biomesToSet = new Biome[biomeArray.size()];
            for (int i = 0; i < biomeArray.size(); ++i) {
                if (!biomeArray.get(i).isJsonPrimitive() || !biomeArray.get(i).getAsJsonPrimitive().isString()) {
                    throw new JsonSyntaxException("Expected biome array element to be a String");
                }
                biomesToSet[i] = this.getBiomeFromString(biomeArray.get(i).getAsString());
            }
            return new ConditionBiome(biomesToSet);
        }

        private Biome getBiomeFromString(String biomeName) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeName));
            if (biome == null) {
                throw new JsonSyntaxException("Can't find a biome with name: " + biomeName);
            }
            return biome;
        }
    }
}

