/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tmtravlr.lootoverhaul.LootOverhaul;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ExtraLootManager {
    private static final Gson LOOT_TABLE_GSON = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();

    public static List<LootTable> loadLootTableExtras(ResourceLocation resource, LootTableManager lootTableManager) {
        LoadLootTableExtrasEvent event = new LoadLootTableExtrasEvent(resource, lootTableManager);
        ArrayList<LootTable> lootTables = new ArrayList<LootTable>();
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            lootTables.addAll(event.extraLootTables);
        }
        return lootTables;
    }

    public static void loadDefaultLootTableExtras(LoadLootTableExtrasEvent event) {
        File lootTableFile;
        File folder = (File)ObfuscationReflectionHelper.getPrivateValue(LootTableManager.class, (Object)event.getLootTableManager(), (String[])new String[]{"field_186528_d", "baseFolder"});
        if (folder.isDirectory() && (lootTableFile = new File(new File(folder, event.getLootTableLocation().func_110624_b()), event.getLootTableLocation().func_110623_a() + "_extra.json")).exists()) {
            try {
                String data = Files.toString((File)lootTableFile, (Charset)StandardCharsets.UTF_8);
                LootTable table = ForgeHooks.loadLootTable((Gson)LOOT_TABLE_GSON, (ResourceLocation)new ResourceLocation(event.getLootTableLocation().func_110624_b(), event.getLootTableLocation().func_110623_a() + "_extra.json"), (String)data, (boolean)true, (LootTableManager)event.getLootTableManager());
                event.addExtraLootTable(table);
            }
            catch (IOException ioexception) {
                LootOverhaul.logger.warn("Couldn't load loot table {} from {}", (Object)event.getLootTableLocation(), (Object)lootTableFile, (Object)ioexception);
            }
        }
    }

    public static class LoadLootTableExtrasEvent
    extends Event {
        private ResourceLocation lootTableLocation;
        private LootTableManager lootTableManager;
        private List<LootTable> extraLootTables = new ArrayList<LootTable>();

        public LoadLootTableExtrasEvent(ResourceLocation lootTableLocation, LootTableManager lootTableManager) {
            this.lootTableLocation = lootTableLocation;
            this.lootTableManager = lootTableManager;
        }

        public ResourceLocation getLootTableLocation() {
            return this.lootTableLocation;
        }

        public LootTableManager getLootTableManager() {
            return this.lootTableManager;
        }

        public void addExtraLootTable(LootTable lootTable) {
            this.extraLootTables.add(lootTable);
        }
    }
}

