/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.items;

import com.tmtravlr.lootoverhaul.LootOverhaul;
import com.tmtravlr.lootoverhaul.loot.LootContextExtendedBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootTable;

public class ItemTriggerLoot
extends Item {
    private static final Random RAND = new Random();
    public static final Item INSTANCE = (Item)new ItemTriggerLoot().func_77655_b("trigger_loot").setRegistryName("trigger_loot");

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        NBTTagCompound tag;
        if (entity != null && entity instanceof EntityPlayer && (tag = stack.func_77978_p()) != null && !tag.func_74767_n("Unwrap")) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!world.field_72995_K) {
                ItemStack newStack = this.generateLootItem(stack, player);
                if (stack != newStack) {
                    player.field_71071_by.func_70299_a(slot, newStack);
                }
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ItemStack newStack = this.generateLootItem(stack, player);
            player.field_71069_bz.func_75142_b();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)newStack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public ItemStack generateLootItem(ItemStack stack, EntityPlayer player) {
        try {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && player.field_70170_p instanceof WorldServer) {
                ResourceLocation lootTableLocation = new ResourceLocation(tag.func_74779_i("LootTable"));
                LootTable lootTable = player.field_70170_p.func_184146_ak().func_186521_a(lootTableLocation);
                if (!tag.func_74767_n("Unwrap") || !player.func_184812_l_()) {
                    stack.func_77979_a(1);
                }
                if (lootTable != null) {
                    LootContextExtendedBuilder builder = new LootContextExtendedBuilder((WorldServer)player.field_70170_p).withLooter((Entity)player);
                    List lootList = lootTable.func_186462_a(tag.func_74764_b("Seed") ? new Random(tag.func_74763_f("Seed")) : RAND, builder.func_186471_a());
                    if (!lootList.isEmpty()) {
                        if (stack.func_190926_b()) {
                            stack = (ItemStack)lootList.get(0);
                            lootList.remove(0);
                            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((RAND.nextFloat() - RAND.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        }
                        for (ItemStack lootStack : lootList) {
                            if (player.func_191521_c(lootStack)) {
                                player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((RAND.nextFloat() - RAND.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                                continue;
                            }
                            EntityItem entityItem = player.func_71019_a(lootStack, false);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LootOverhaul.logger.warn("Problem while generating loot from item!", (Throwable)e);
        }
        return stack;
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack) + (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Unwrap") ? " " + I18n.func_74838_a((String)"item.triggers.unwrap") : "");
    }
}

