/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul;

import com.tmtravlr.lootoverhaul.ConfigLoader;
import com.tmtravlr.lootoverhaul.items.ItemLoot;
import com.tmtravlr.lootoverhaul.items.ItemLootBlock;
import com.tmtravlr.lootoverhaul.items.ItemLootCommand;
import com.tmtravlr.lootoverhaul.items.ItemLootEffect;
import com.tmtravlr.lootoverhaul.items.ItemLootEntity;
import com.tmtravlr.lootoverhaul.items.ItemLootFill;
import com.tmtravlr.lootoverhaul.items.ItemLootItem;
import com.tmtravlr.lootoverhaul.items.ItemLootStructure;
import com.tmtravlr.lootoverhaul.items.ItemTriggerCommand;
import com.tmtravlr.lootoverhaul.items.ItemTriggerLoot;
import com.tmtravlr.lootoverhaul.loot.BlockLootManager;
import com.tmtravlr.lootoverhaul.loot.ExtraLootManager;
import com.tmtravlr.lootoverhaul.loot.LootContextExtendedBuilder;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import com.tmtravlr.lootoverhaul.utilities.SavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lootoverhaul")
public class LootEventHandler {
    private static boolean loadingExtras = false;
    private static final Map<EntityPlayer, TileEntity> TILE_ENTITY_INTERACTIONS = new ConcurrentHashMap<EntityPlayer, TileEntity>();
    private static final Map<EntityPlayer, Entity> ENTITY_INTERACTIONS = new ConcurrentHashMap<EntityPlayer, Entity>();

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ItemLootItem.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemLootBlock.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemLootFill.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemLootEntity.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemLootStructure.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemLootCommand.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemLootEffect.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemTriggerCommand.INSTANCE);
        registry.register((IForgeRegistryEntry)ItemTriggerLoot.INSTANCE);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == Side.SERVER) {
            SavedData savedData = SavedData.getSavedData(event.world);
            List<ItemStack> expiredLoot = savedData.decrementLootDelays();
            for (ItemStack stack : expiredLoot) {
                if (!(stack.func_77973_b() instanceof ItemLoot)) continue;
                NBTTagCompound positionTag = stack.func_77978_p().func_74775_l("Position");
                Vec3d position = new Vec3d(positionTag.func_74769_h("X"), positionTag.func_74769_h("Y"), positionTag.func_74769_h("Z"));
                ((ItemLoot)stack.func_77973_b()).generateLoot(stack, event.world, position);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        ItemStack stack;
        if (event.getEntity() instanceof EntityItem && !(stack = ((EntityItem)event.getEntity()).func_92059_d()).func_190926_b() && stack.func_77942_o() && stack.func_77973_b() instanceof ItemLoot) {
            ((ItemLoot)stack.func_77973_b()).generateLoot(stack, event.getWorld(), event.getEntity().func_174791_d());
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("lootoverhaul") && ConfigLoader.config != null && (ConfigLoader.config.hasChanged() || !ConfigLoader.config.getConfigFile().exists())) {
            ConfigLoader.syncConfig();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockDrop(BlockEvent.HarvestDropsEvent event) {
        LootTable lootTable;
        LootTable lootTable2;
        ResourceLocation blockLootResource;
        if (!ConfigLoader.enableBlockDrops || !(event.getWorld() instanceof WorldServer)) {
            return;
        }
        Random rand = BlockLootManager.getRandom(event.getWorld(), event.getPos(), event.getState());
        if ((!ConfigLoader.useBlockDropWhitelist || ConfigLoader.blockDropsToReplace.contains(event.getState().func_177230_c().getRegistryName())) && (blockLootResource = BlockLootManager.getBlockDropLootTable(event.getWorld(), event.getPos(), event.getState())) != null && (lootTable2 = event.getWorld().func_184146_ak().func_186521_a(blockLootResource)) != null) {
            List lootList;
            LootContextExtendedBuilder builder = new LootContextExtendedBuilder((WorldServer)event.getWorld()).withBrokenState(event.getState()).withFortune(event.getFortuneLevel()).withSilkTouch(event.isSilkTouching());
            if (event.getWorld().func_175625_s(event.getPos()) != null) {
                builder.withBrokenTileEntity(event.getWorld().func_175625_s(event.getPos()));
            }
            if (event.getHarvester() != null) {
                builder.withLooter((Entity)event.getHarvester()).func_186469_a(event.getHarvester().func_184817_da());
            }
            if (!(lootList = lootTable2.func_186462_a(rand, builder.func_186471_a())).isEmpty()) {
                event.getDrops().clear();
                for (ItemStack stack : lootList) {
                    if (stack.func_190926_b()) continue;
                    event.getDrops().add(stack);
                }
            }
        }
        if (ConfigLoader.enableBlockDropsAll && (lootTable = event.getWorld().func_184146_ak().func_186521_a(BlockLootManager.ALL_BLOCKS)) != null) {
            LootContextExtendedBuilder builder = new LootContextExtendedBuilder((WorldServer)event.getWorld()).withBrokenState(event.getState()).withFortune(event.getFortuneLevel()).withSilkTouch(event.isSilkTouching());
            if (event.getWorld().func_175625_s(event.getPos()) != null) {
                builder.withBrokenTileEntity(event.getWorld().func_175625_s(event.getPos()));
            }
            if (event.getHarvester() != null) {
                builder.withLooter((Entity)event.getHarvester()).func_186469_a(event.getHarvester().func_184817_da());
            }
            for (ItemStack stack : lootTable.func_186462_a(rand, builder.func_186471_a())) {
                if (stack.func_190926_b()) continue;
                event.getDrops().add(stack);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDrops(LivingDropsEvent event) {
        LootTable lootTable;
        if (ConfigLoader.enableEntityDropsAll && event.getEntity().field_70170_p instanceof WorldServer && (lootTable = event.getEntity().field_70170_p.func_184146_ak().func_186521_a(LootHelper.ALL_ENTTIIES)) != null) {
            LootContext.Builder builder = new LootContextExtendedBuilder((WorldServer)event.getEntity().field_70170_p).func_186472_a(event.getEntity()).func_186473_a(event.getSource());
            int recentlyHit = (Integer)ObfuscationReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)event.getEntityLiving(), (String[])new String[]{"field_70718_bc", "recentlyHit"});
            EntityPlayer attackingPlayer = (EntityPlayer)ObfuscationReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)event.getEntityLiving(), (String[])new String[]{"field_70717_bb", "attackingPlayer"});
            long deathLootTableSeed = 0L;
            if (event.getEntityLiving() instanceof EntityLiving) {
                deathLootTableSeed = (Long)ObfuscationReflectionHelper.getPrivateValue(EntityLiving.class, (Object)((EntityLiving)event.getEntityLiving()), (String[])new String[]{"field_184653_bB", "deathLootTableSeed"});
            }
            if (recentlyHit > 0 && attackingPlayer != null) {
                builder = builder.func_186470_a(attackingPlayer).func_186469_a(attackingPlayer.func_184817_da());
            }
            for (ItemStack stack : lootTable.func_186462_a(deathLootTableSeed == 0L ? event.getEntityLiving().func_70681_au() : new Random(deathLootTableSeed), builder.func_186471_a())) {
                if (stack.func_190926_b()) continue;
                EntityItem entityItem = new EntityItem(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, stack);
                entityItem.func_174869_p();
                event.getDrops().add(entityItem);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            Vec3d position = TILE_ENTITY_INTERACTIONS.containsKey(event.getEntityPlayer()) ? new Vec3d((Vec3i)TILE_ENTITY_INTERACTIONS.get(event.getEntityPlayer()).func_174877_v()).func_72441_c(0.5, 0.0, 0.5) : (ENTITY_INTERACTIONS.containsKey(event.getEntityPlayer()) ? ENTITY_INTERACTIONS.get(event.getEntityPlayer()).func_174791_d() : event.getEntityPlayer().func_174791_d());
            ArrayList<ItemStack> lootItemsToGenerate = new ArrayList<ItemStack>();
            for (int i = 0; i < event.getContainer().field_75153_a.size(); ++i) {
                ItemStack stack2 = (ItemStack)event.getContainer().field_75153_a.get(i);
                if (!(stack2.func_77973_b() instanceof ItemLoot)) continue;
                lootItemsToGenerate.add(stack2);
                event.getContainer().func_75141_a(i, ItemStack.field_190927_a);
            }
            if (!lootItemsToGenerate.isEmpty()) {
                event.getContainer().func_75142_b();
            }
            lootItemsToGenerate.forEach(stack -> ((ItemLoot)stack.func_77973_b()).generateLoot((ItemStack)stack, event.getEntityPlayer().field_70170_p, position));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void recordRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile;
        if (!event.getWorld().field_72995_K && (tile = event.getWorld().func_175625_s(event.getPos())) != null) {
            TILE_ENTITY_INTERACTIONS.put(event.getEntityPlayer(), tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void recordRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().field_72995_K) {
            ENTITY_INTERACTIONS.put(event.getEntityPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (!TILE_ENTITY_INTERACTIONS.isEmpty()) {
            TILE_ENTITY_INTERACTIONS.clear();
        }
        if (!ENTITY_INTERACTIONS.isEmpty()) {
            ENTITY_INTERACTIONS.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (ConfigLoader.enableExtraLootTables && !loadingExtras && !ConfigLoader.extraLootTableBlacklist.contains(event.getName())) {
            LootTable table;
            loadingExtras = true;
            List<LootTable> extraTables = ExtraLootManager.loadLootTableExtras(event.getName(), event.getLootTableManager());
            if (!extraTables.isEmpty() && (table = event.getTable()) != null) {
                for (LootTable extra : extraTables) {
                    List pools = (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)extra, (String[])new String[]{"field_186466_c", "pools"});
                    for (LootPool pool : pools) {
                        table.addPool(pool);
                    }
                }
            }
            loadingExtras = false;
        }
    }

    @SubscribeEvent
    public static void onLootTableExtrasLoad(ExtraLootManager.LoadLootTableExtrasEvent event) {
        ExtraLootManager.loadDefaultLootTableExtras(event);
    }
}

