/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.biolib.common;

import javax.annotation.Nullable;
import mrthomas20121.biolib.common.OredictHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class SmelteryUtils {
    public static int VALUE_Gear = 576;
    public static int VALUE_SHEET = 200;
    public static int VALUE_DOUBLE_INGOT = 200;

    public static void registerIngotCasting(String ore, Fluid fluid) {
        ItemStack result = OredictHelper.getOre("ingot" + ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)TinkerSmeltery.castIngot, (Fluid)fluid, (int)144);
        }
    }

    public static void registerCasting(String ore, ItemStack cast, Fluid fluid, int amount) {
        ItemStack result = OredictHelper.getOre(ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)cast, (Fluid)fluid, (int)amount);
        }
    }

    public static void registerCasting(ItemStack input, ItemStack cast, Fluid fluid, int amount) {
        TinkerRegistry.registerTableCasting((ItemStack)input, (ItemStack)cast, (Fluid)fluid, (int)amount);
    }

    public static void registerPlateCasting(String ore, Fluid fluid) {
        ItemStack result = OredictHelper.getOre("plate" + ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)TinkerSmeltery.castPlate, (Fluid)fluid, (int)144);
        }
    }

    public static void registerGearCasting(String ore, Fluid fluid) {
        ItemStack result = OredictHelper.getOre("gear" + ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)TinkerSmeltery.castGear, (Fluid)fluid, (int)VALUE_Gear);
        }
    }

    public static void registerGemCasting(String ore, Fluid fluid) {
        ItemStack result = OredictHelper.getOre("gem" + ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)TinkerSmeltery.castGem, (Fluid)fluid, (int)666);
        }
    }

    public static void registerNuggetCasting(String ore, Fluid fluid) {
        ItemStack result = OredictHelper.getOre("nugget" + ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerTableCasting((ItemStack)result, (ItemStack)TinkerSmeltery.castNugget, (Fluid)fluid, (int)16);
        }
    }

    public static void registerBlockCasting(String ore, Fluid fluid) {
        ItemStack result = OredictHelper.getOre("block" + ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerBasinCasting((ItemStack)result, (ItemStack)ItemStack.field_190927_a, (Fluid)fluid, (int)1296);
        }
    }

    public static void registerSmallBlockCasting(String ore, Fluid fluid) {
        ItemStack result = OredictHelper.getOre("block" + ore);
        if (!result.equals(ItemStack.field_190927_a)) {
            TinkerRegistry.registerBasinCasting((ItemStack)result, (ItemStack)ItemStack.field_190927_a, (Fluid)fluid, (int)576);
        }
    }

    public static void addMelting(String ore, FluidStack fluidstack) {
        TinkerRegistry.registerMelting((String)ore, (Fluid)fluidstack.getFluid(), (int)fluidstack.amount);
    }

    public static void addMelting(ItemStack item, FluidStack fluidstack) {
        TinkerRegistry.registerMelting((ItemStack)item, (Fluid)fluidstack.getFluid(), (int)fluidstack.amount);
    }

    public static void addBasinCasing(ItemStack output, FluidStack fluidstack, @Nullable ItemStack input) {
        TinkerRegistry.registerBasinCasting((ItemStack)output, (ItemStack)input, (Fluid)fluidstack.getFluid(), (int)fluidstack.amount);
    }

    public static void defaultMelting(String ore, Fluid fluid) {
        TinkerRegistry.registerMelting((String)("ingot" + ore), (Fluid)fluid, (int)144);
        TinkerRegistry.registerMelting((String)("dust" + ore), (Fluid)fluid, (int)144);
        TinkerRegistry.registerMelting((String)("block" + ore), (Fluid)fluid, (int)1296);
        TinkerRegistry.registerMelting((String)("ore" + ore), (Fluid)fluid, (int)Material.VALUE_Ore());
        SmelteryUtils.registerIngotCasting(ore, fluid);
    }

    public static void registerMelting(String ore, Fluid fluid, int mat) {
        TinkerRegistry.registerMelting((String)ore, (Fluid)fluid, (int)mat);
    }

    public static void registerDefaultCasting(String oredict, Fluid fluid, boolean isgem) {
        String[] oredicts = new String[]{"block", "ingot", "plate", "gear", "nugget"};
        if (isgem) {
            oredicts[1] = "gem";
        }
        for (String ore : oredicts) {
            if (ore == "ingot") {
                SmelteryUtils.registerIngotCasting(oredict, fluid);
                continue;
            }
            if (ore == "block") {
                SmelteryUtils.registerBlockCasting(oredict, fluid);
                continue;
            }
            if (ore == "plate") {
                SmelteryUtils.registerPlateCasting(oredict, fluid);
                continue;
            }
            if (ore == "nugget") {
                SmelteryUtils.registerNuggetCasting(oredict, fluid);
                continue;
            }
            if (ore == "gear") {
                SmelteryUtils.registerGearCasting(oredict, fluid);
                continue;
            }
            if (ore != "gem") continue;
            SmelteryUtils.registerGemCasting(oredict, fluid);
        }
    }

    public static void registerDefaultMelting(String ore, Fluid fluid, boolean cast) {
        TinkerRegistry.registerMelting((String)("ingot" + ore), (Fluid)fluid, (int)144);
        TinkerRegistry.registerMelting((String)("dust" + ore), (Fluid)fluid, (int)144);
        TinkerRegistry.registerMelting((String)("plate" + ore), (Fluid)fluid, (int)144);
        TinkerRegistry.registerMelting((String)("gear" + ore), (Fluid)fluid, (int)576);
        TinkerRegistry.registerMelting((String)("block" + ore), (Fluid)fluid, (int)1296);
        if (cast) {
            SmelteryUtils.registerDefaultCasting(ore, fluid, false);
        }
    }

    public static void registerAlloy(FluidStack output, FluidStack ... inputs) {
        AlloyRecipe recipe = new AlloyRecipe(output, inputs);
        TinkerRegistry.registerAlloy((AlloyRecipe)recipe);
    }

    public static boolean checkIfAlloyRecipeExist(FluidStack output, FluidStack ... inputs) {
        boolean exist = false;
        AlloyRecipe recipe = new AlloyRecipe(output, inputs);
        for (AlloyRecipe alloy : TinkerRegistry.getAlloys()) {
            if (!alloy.equals(recipe)) continue;
            exist = true;
        }
        return exist;
    }
}

