/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.gui.screen;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.space.ICelestialRegistry;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.utils.ACCompatibilityManager;
import asmodeuscore.core.utils.UtilsGC;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiTeleporting;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class Base_GuiCelestialSelection
extends GuiScreen {
    protected static final int MAX_SPACE_STATION_NAME_LENGTH = 32;
    protected float zoom = 0.0f;
    protected float planetZoom = 0.0f;
    protected boolean doneZooming = false;
    protected float preSelectZoom = 0.0f;
    protected Vector2f preSelectPosition = new Vector2f();
    protected static ResourceLocation guiMain0 = new ResourceLocation("galacticraftcore", "textures/gui/celestialselection.png");
    protected static ResourceLocation guiMain1 = new ResourceLocation("galacticraftcore", "textures/gui/celestialselection1.png");
    protected static ResourceLocation guiMain2 = new ResourceLocation("asmodeuscore", "textures/gui/celestialselection2.png");
    protected float ticksSinceSelectionF = 0.0f;
    protected float ticksSinceUnselectionF = -1.0f;
    protected float ticksSinceMenuOpenF = 0.0f;
    protected float ticksTotalF = 0.0f;
    @Deprecated
    protected int ticksSinceSelection = 0;
    @Deprecated
    protected int ticksSinceUnselection = -1;
    @Deprecated
    protected int ticksSinceMenuOpen = 0;
    @Deprecated
    protected int ticksTotal = 0;
    protected int animateGrandchildren = 0;
    protected Vector2f position = new Vector2f(0.0f, 0.0f);
    protected Map<CelestialBody, Vector3f> planetPosMap = Maps.newHashMap();
    @Deprecated
    protected Map<CelestialBody, Integer> celestialBodyTicks = Maps.newHashMap();
    protected CelestialBody selectedBody;
    protected CelestialBody lastSelectedBody;
    protected static int BORDER_SIZE = 0;
    protected static int BORDER_EDGE_SIZE = 0;
    protected int canCreateOffset = 24;
    protected EnumView viewState = EnumView.PREVIEW;
    protected EnumSelection selectionState = EnumSelection.UNSELECTED;
    protected int zoomTooltipPos = 0;
    protected Object selectedParent = GalacticraftCore.solarSystemSol;
    protected final boolean mapMode;
    public List<CelestialBody> possibleBodies;
    public Map<Integer, Map<String, StationDataGUI>> spaceStationMap = Maps.newHashMap();
    protected String selectedStationOwner = "";
    protected int spaceStationListOffset = 0;
    protected boolean renamingSpaceStation;
    protected String renamingString = "";
    protected Vector2f translation = new Vector2f(0.0f, 0.0f);
    protected boolean mouseDragging = false;
    protected int lastMovePosX = -1;
    protected int lastMovePosY = -1;
    protected boolean errorLogged = false;
    public boolean canCreateStations = false;
    protected List<CelestialBody> bodiesToRender = Lists.newArrayList();
    private int bodyScroll = 0;
    private int maxBodyScroll;
    protected static final int WHITE = ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255);
    protected static final int GREY5 = ColorUtil.to32BitColor((int)255, (int)150, (int)150, (int)150);
    protected static final int GREY4 = ColorUtil.to32BitColor((int)255, (int)140, (int)140, (int)140);
    protected static final int GREY3 = ColorUtil.to32BitColor((int)255, (int)120, (int)120, (int)120);
    protected static final int GREY2 = ColorUtil.to32BitColor((int)255, (int)100, (int)100, (int)100);
    protected static final int GREY1 = ColorUtil.to32BitColor((int)255, (int)80, (int)80, (int)80);
    protected static final int GREY0 = ColorUtil.to32BitColor((int)255, (int)40, (int)40, (int)40);
    protected static final int GREEN = ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)0);
    protected static final int RED = ColorUtil.to32BitColor((int)255, (int)255, (int)0, (int)0);
    protected static final int RED3 = ColorUtil.to32BitColor((int)255, (int)255, (int)100, (int)100);
    protected static final int CYAN = ColorUtil.to32BitColor((int)255, (int)150, (int)200, (int)255);
    protected static final int LIGHTBLUE = ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255);
    protected static final int YELLOW = ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0);

    public Base_GuiCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations) {
        this.maxBodyScroll = Minecraft.func_71410_x().field_71474_y.field_74335_Z == 0 ? 10 : 16;
        this.mapMode = mapMode;
        this.possibleBodies = possibleBodies;
        this.canCreateStations = canCreateStations;
    }

    public void func_73866_w_() {
        BORDER_SIZE = this.field_146294_l / 65;
        BORDER_EDGE_SIZE = BORDER_SIZE / 4;
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            this.bodiesToRender.add((CelestialBody)solarSystem.getMainStar());
        }
        this.bodiesToRender.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        this.bodiesToRender.addAll(GalaxyRegistry.getRegisteredMoons().values());
        this.bodiesToRender.addAll(GalaxyRegistry.getRegisteredSatellites().values());
    }

    protected String getGrandparentName() {
        if (this.selectedParent instanceof Planet) {
            SolarSystem parentSolarSystem = ((Planet)this.selectedParent).getParentSolarSystem();
            if (parentSolarSystem != null) {
                return parentSolarSystem.getLocalizedName();
            }
        } else if (this.selectedParent instanceof IChildBody) {
            SolarSystem parentSolarSystem;
            Planet parentPlanet = ((IChildBody)this.selectedParent).getParentPlanet();
            if (parentPlanet != null && (parentSolarSystem = parentPlanet.getParentSolarSystem()) != null) {
                return parentSolarSystem.getLocalizedName();
            }
        } else if (this.selectedParent instanceof Star) {
            SolarSystem parentSolarSystem = ((Star)this.selectedParent).getParentSolarSystem();
            if (parentSolarSystem != null) {
                return parentSolarSystem.getLocalizedParentGalaxyName();
            }
        } else if (this.selectedParent instanceof SolarSystem) {
            return ((SolarSystem)this.selectedParent).getLocalizedParentGalaxyName();
        }
        return "Null";
    }

    protected int getSatelliteParentID(Satellite satellite) {
        return satellite.getParentPlanet().getDimensionID();
    }

    protected String getParentName() {
        if (this.selectedBody instanceof Planet) {
            SolarSystem parentSolarSystem = ((Planet)this.selectedBody).getParentSolarSystem();
            if (parentSolarSystem != null) {
                return parentSolarSystem.getLocalizedName();
            }
        } else if (this.selectedBody instanceof IChildBody) {
            Planet parentPlanet = ((IChildBody)this.selectedBody).getParentPlanet();
            if (parentPlanet != null) {
                return parentPlanet.getLocalizedName();
            }
        } else if (this.selectedBody instanceof Star) {
            SolarSystem parentSolarSystem = ((Star)this.selectedBody).getParentSolarSystem();
            if (parentSolarSystem != null) {
                return parentSolarSystem.getLocalizedName();
            }
        } else if (this.selectedParent != null && this.selectedParent instanceof SolarSystem) {
            return ((SolarSystem)this.selectedParent).getLocalizedName();
        }
        return "Null";
    }

    protected float getScale(CelestialBody celestialBody) {
        float scale = 0.2f;
        if (celestialBody instanceof Planet) {
            scale = 25.0f;
        }
        if (celestialBody instanceof ICelestialRegistry && !((ICelestialRegistry)celestialBody instanceof IChildBody)) {
            scale = 25.0f;
        }
        return 3.0f * celestialBody.getRelativeDistanceFromCenter().unScaledDistance * scale;
    }

    protected List<CelestialBody> getSiblings(CelestialBody celestialBody) {
        ArrayList bodyList = Lists.newArrayList();
        if (celestialBody instanceof Planet) {
            SolarSystem solarSystem = ((Planet)celestialBody).getParentSolarSystem();
            for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                SolarSystem solarSystem1 = planet.getParentSolarSystem();
                if (solarSystem1 == null || !solarSystem1.equals(solarSystem)) continue;
                bodyList.add(planet);
            }
        } else if (celestialBody instanceof IChildBody) {
            Planet planet1;
            Planet planet = ((IChildBody)celestialBody).getParentPlanet();
            for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
                planet1 = moon.getParentPlanet();
                if (planet1 == null || !planet1.equals((Object)planet)) continue;
                bodyList.add(moon);
            }
            for (Satellite sat : GalaxyRegistry.getRegisteredSatellites().values()) {
                planet1 = sat.getParentPlanet();
                if (planet1 == null || !planet1.equals((Object)planet)) continue;
                bodyList.add(sat);
            }
        }
        Collections.sort(bodyList);
        return bodyList;
    }

    protected List<CelestialBody> getChildren(Object object, int start, int size) {
        return this.getChildren(object, start, size, true);
    }

    protected List<CelestialBody> getChildren(Object object, int start, int size, boolean check) {
        List<CelestialBody> bodies;
        ArrayList bodyList = Lists.newArrayList();
        SpaceData.refreshGalaxies();
        if (object instanceof Planet) {
            List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                for (Object moon : moons) {
                    if (!UtilsGC.isReasearched(this.field_146297_k.field_71439_g, (CelestialBody)moon)) continue;
                    bodyList.add(moon);
                }
            } else {
                bodyList.addAll(moons);
            }
            bodies = SpaceData.getMoonsForPlanet((Planet)object);
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || !(body instanceof IChildBody)) continue;
                bodyList.add(body);
            }
        } else if (object instanceof SolarSystem) {
            List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                for (Object planet : planets) {
                    if (!UtilsGC.isReasearched(this.field_146297_k.field_71439_g, (CelestialBody)planet)) continue;
                    bodyList.add(planet);
                }
            } else {
                bodyList.addAll(planets);
            }
            bodies = SpaceData.getBodiesForSolarSystem((SolarSystem)object);
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || body instanceof IChildBody) continue;
                bodyList.add(body);
            }
        }
        Collections.sort(bodyList);
        if (check) {
            ArrayList doneList = Lists.newArrayList();
            int startPos = start;
            int getSize = size;
            if (startPos >= bodyList.size()) {
                startPos = 0;
            }
            if (getSize >= bodyList.size()) {
                getSize = bodyList.size();
            }
            for (int i = 0; i < getSize; ++i) {
                doneList.add(i, bodyList.get(i + startPos));
            }
            return doneList;
        }
        return bodyList;
    }

    protected float lerp(float v0, float v1, float t) {
        return v0 + t * (v1 - v0);
    }

    protected Vector2f lerpVec2(Vector2f v0, Vector2f v1, float t) {
        return new Vector2f(v0.x + t * (v1.x - v0.x), v0.y + t * (v1.y - v0.y));
    }

    protected float getZoomAdvanced() {
        if (this.ticksTotalF < 30.0f) {
            float scale = Math.max(0.0f, Math.min(this.ticksTotalF / 30.0f, 1.0f));
            return this.lerp(-0.75f, 0.0f, (float)Math.pow(scale, 0.5));
        }
        if (this.selectedBody == null || this.selectionState != EnumSelection.ZOOMED) {
            if (!this.doneZooming) {
                float unselectScale = this.lerp(this.zoom, this.preSelectZoom, Math.max(0.0f, Math.min(this.ticksSinceUnselectionF / 100.0f, 1.0f)));
                if (unselectScale <= this.preSelectZoom + 0.05f) {
                    this.zoom = this.preSelectZoom;
                    this.ticksSinceUnselectionF = -1.0f;
                    this.ticksSinceUnselection = -1;
                    this.doneZooming = true;
                }
                return unselectScale;
            }
            return this.zoom;
        }
        if (!this.doneZooming) {
            float f = this.lerp(this.zoom, 12.0f, Math.max(0.0f, Math.min((this.ticksSinceSelectionF - 20.0f) / 40.0f, 1.0f)));
            if (f >= 11.95f) {
                this.doneZooming = true;
            }
            return f;
        }
        return 12.0f + this.planetZoom;
    }

    protected Vector2f getTranslationAdvanced(float partialTicks) {
        if (this.selectedBody == null) {
            if (this.ticksSinceUnselectionF > 0.0f) {
                float f0 = Math.max(0.0f, Math.min(this.ticksSinceUnselectionF / 100.0f, 1.0f));
                if (f0 >= 0.999999f) {
                    this.ticksSinceUnselectionF = 0.0f;
                    this.ticksSinceUnselection = 0;
                }
                return this.lerpVec2(this.position, this.preSelectPosition, f0);
            }
            return new Vector2f(this.position.x + this.translation.x, this.position.y + this.translation.y);
        }
        if (!this.isZoomed()) {
            if (this.selectedBody instanceof IChildBody) {
                Vector3f posVec = this.getCelestialBodyPosition((CelestialBody)((IChildBody)this.selectedBody).getParentPlanet());
                return new Vector2f(posVec.x, posVec.y);
            }
            return new Vector2f(this.position.x + this.translation.x, this.position.y + this.translation.y);
        }
        Vector2f pos = this.position;
        if (this.lastSelectedBody != null) {
            Vector3f pos3 = this.getCelestialBodyPosition(this.lastSelectedBody);
            pos.x = pos3.x;
            pos.y = pos3.y;
        }
        Vector3f posVec = this.getCelestialBodyPosition(this.selectedBody);
        return this.lerpVec2(pos, new Vector2f(posVec.x, posVec.y), Math.max(0.0f, Math.min((this.ticksSinceSelectionF - 18.0f) / 7.5f, 1.0f)));
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (this.mapMode) {
            super.func_73869_a(keyChar, keyID);
        }
        if (keyID == 1 && this.selectedBody != null) {
            this.unselectCelestialBody();
        }
        if (this.renamingSpaceStation) {
            if (keyID == 14) {
                if (this.renamingString != null && this.renamingString.length() > 0) {
                    String toBeParsed = this.renamingString.substring(0, this.renamingString.length() - 1);
                    this.renamingString = this.isValid(toBeParsed) ? toBeParsed : "";
                }
            } else if (keyChar == '\u0016') {
                String pastestring = GuiScreen.func_146277_j();
                if (pastestring == null) {
                    pastestring = "";
                }
                if (this.isValid(this.renamingString + pastestring)) {
                    this.renamingString = this.renamingString + pastestring;
                    this.renamingString = this.renamingString.substring(0, Math.min(String.valueOf(this.renamingString).length(), 32));
                }
            } else if (this.isValid(this.renamingString + keyChar)) {
                this.renamingString = this.renamingString + keyChar;
                this.renamingString = this.renamingString.substring(0, Math.min(this.renamingString.length(), 32));
            }
            return;
        }
        if (keyID == 28) {
            this.teleportToSelectedBody();
        }
    }

    public boolean isValid(String string) {
        return string.length() > 0 && ChatAllowedCharacters.func_71566_a((char)string.charAt(string.length() - 1));
    }

    protected boolean canCreateSpaceStation(CelestialBody atBody) {
        if (this.mapMode || ConfigManagerCore.disableSpaceStationCreation || !this.canCreateStations) {
            return false;
        }
        if (!atBody.getReachable() || this.possibleBodies != null && !this.possibleBodies.contains(atBody)) {
            return false;
        }
        boolean foundRecipe = false;
        for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
            if (type.getWorldToOrbitID() != atBody.getDimensionID()) continue;
            foundRecipe = true;
        }
        if (!foundRecipe) {
            return false;
        }
        if (!ClientProxyCore.clientSpaceStationID.containsKey(atBody.getDimensionID())) {
            return true;
        }
        int resultID = (Integer)ClientProxyCore.clientSpaceStationID.get(atBody.getDimensionID());
        return resultID == 0 || resultID == -1;
    }

    protected void unselectCelestialBody() {
        this.selectionState = EnumSelection.UNSELECTED;
        this.ticksSinceUnselectionF = 0.0f;
        this.ticksSinceUnselection = 0;
        this.lastSelectedBody = this.selectedBody;
        this.selectedBody = null;
        this.doneZooming = false;
        this.selectedStationOwner = "";
        this.animateGrandchildren = 0;
    }

    public void func_73876_c() {
        ++this.ticksSinceMenuOpen;
        ++this.ticksTotal;
        if (this.ticksSinceMenuOpen < 20) {
            Mouse.setGrabbed((boolean)false);
        }
        if (this.selectedBody != null) {
            ++this.ticksSinceSelection;
        }
        if (this.selectedBody == null && this.ticksSinceUnselection >= 0) {
            ++this.ticksSinceUnselection;
        }
        if (!(this.renamingSpaceStation || this.selectedBody != null && this.isZoomed())) {
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.leftKey)) {
                this.translation.x += -2.0f;
                this.translation.y += -2.0f;
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.rightKey)) {
                this.translation.x += 2.0f;
                this.translation.y += 2.0f;
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.upKey)) {
                this.translation.x += 2.0f;
                this.translation.y += -2.0f;
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.downKey)) {
                this.translation.x += -2.0f;
                this.translation.y += 2.0f;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void teleportToSelectedBody() {
        if (this.selectedBody == null) return;
        if (!this.selectedBody.getReachable()) return;
        if (this.possibleBodies == null) return;
        if (!this.possibleBodies.contains(this.selectedBody)) return;
        try {
            String dimension;
            int dimensionID;
            if (this.selectedBody instanceof Satellite) {
                if (this.spaceStationMap == null) {
                    GCLog.severe((String)"Please report as a BUG: spaceStationIDs was null.");
                    return;
                }
                Satellite selectedSatellite = (Satellite)this.selectedBody;
                Integer mapping = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).get(this.selectedStationOwner).getStationDimensionID();
                if (mapping == null) {
                    GCLog.severe((String)("Problem matching player name in space station check: " + this.selectedStationOwner));
                    return;
                }
                dimensionID = mapping;
                WorldProvider spacestation = WorldUtil.getProviderForDimensionClient((int)dimensionID);
                if (spacestation == null) {
                    GCLog.severe((String)("Failed to find a spacestation with dimension " + dimensionID));
                    return;
                }
                dimension = "Space Station " + mapping;
            } else {
                dimensionID = this.selectedBody.getDimensionID();
                dimension = WorldUtil.getDimensionName((WorldProvider)WorldUtil.getProviderForDimensionClient((int)dimensionID));
            }
            if (dimension.contains("$")) {
                this.field_146297_k.field_71474_y.field_74320_O = 0;
            }
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_TELEPORT_ENTITY, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{dimensionID}));
            this.field_146297_k.func_147108_a((GuiScreen)new GuiTeleporting(dimensionID));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_146269_k() throws IOException {
        this.translation.x = 0.0f;
        this.translation.y = 0.0f;
        super.func_146269_k();
    }

    protected void func_146273_a(int x, int y, int lastButtonClicked, long timeSinceMouseClick) {
        super.func_146273_a(x, y, lastButtonClicked, timeSinceMouseClick);
        if (this.mouseDragging && this.lastMovePosX != -1 && lastButtonClicked == 0) {
            int deltaX = x - this.lastMovePosX;
            int deltaY = y - this.lastMovePosY;
            float scollMultiplier = -Math.abs(this.zoom);
            if (this.zoom == -1.0f) {
                scollMultiplier = -1.5f;
            }
            if (this.zoom >= -0.25f && this.zoom <= 0.15f) {
                scollMultiplier = -0.2f;
            }
            if (this.zoom >= 0.15f) {
                scollMultiplier = -0.15f;
            }
            this.translation.x = this.translation.x + (float)(deltaX - deltaY) * scollMultiplier * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity * 0.2f;
            this.translation.y = this.translation.y + (float)(deltaY + deltaX) * scollMultiplier * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity * 0.2f;
        }
        this.lastMovePosX = x;
        this.lastMovePosY = y;
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.mouseDragging = false;
        this.lastMovePosX = -1;
        this.lastMovePosY = -1;
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        boolean planetZoomedMoon;
        SpaceStationRecipe recipe;
        super.func_73864_a(x, y, button);
        boolean clickHandled = false;
        int LHS = BORDER_SIZE + BORDER_EDGE_SIZE;
        int RHS = this.field_146294_l - LHS;
        int TOP = LHS;
        if (this.selectedBody != null && x > LHS && x < LHS + 88 && y > TOP && y < TOP + 13) {
            this.unselectCelestialBody();
            return;
        }
        if (!this.mapMode && x >= RHS - 95 && x < RHS && y > TOP + 181 + this.canCreateOffset && y < TOP + 182 + 12 + this.canCreateOffset && this.selectedBody != null && (recipe = WorldUtil.getSpaceStationRecipe((int)this.selectedBody.getDimensionID())) != null && this.canCreateSpaceStation(this.selectedBody)) {
            if (recipe.matches((EntityPlayer)this.field_146297_k.field_71439_g, false) || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_BIND_SPACE_STATION_ID, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.selectedBody.getDimensionID()}));
                if (!this.isZoomed()) {
                    this.selectionState = EnumSelection.ZOOMED;
                    this.preSelectZoom = this.zoom;
                    this.preSelectPosition = this.position;
                    this.ticksSinceSelectionF = 0.0f;
                    this.ticksSinceSelection = 0;
                    this.doneZooming = false;
                }
                return;
            }
            clickHandled = true;
        }
        if (this.mapMode && x > RHS - 88 && x < RHS && y > TOP && y < TOP + 13) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
            clickHandled = true;
        }
        if (this.selectedBody != null && !this.mapMode && x > RHS - 88 && x < RHS && y > TOP && y < TOP + 13) {
            if (!(this.selectedBody instanceof Satellite) || !this.selectedStationOwner.equals("")) {
                this.teleportToSelectedBody();
            }
            clickHandled = true;
        }
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY() * -1 + Minecraft.func_71410_x().field_71440_d - 1;
        if (this.selectedBody instanceof Satellite) {
            if (this.renamingSpaceStation) {
                if (x >= this.field_146294_l / 2 - 90 && x <= this.field_146294_l / 2 + 90 && y >= this.field_146295_m / 2 - 38 && y <= this.field_146295_m / 2 + 38) {
                    if (x >= this.field_146294_l / 2 - 90 + 17 && x <= this.field_146294_l / 2 - 90 + 17 + 72 && y >= this.field_146295_m / 2 - 38 + 59 && y <= this.field_146295_m / 2 - 38 + 59 + 12) {
                        String strName = PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g);
                        Satellite selectedSatellite = (Satellite)this.selectedBody;
                        Integer spacestationID = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).get(strName).getStationDimensionID();
                        if (spacestationID == null) {
                            spacestationID = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).get(strName.toLowerCase()).getStationDimensionID();
                        }
                        if (spacestationID != null) {
                            this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).get(strName).setStationName(this.renamingString);
                            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_RENAME_SPACE_STATION, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.renamingString, spacestationID}));
                        }
                        this.renamingSpaceStation = false;
                    }
                    if (x >= this.field_146294_l / 2 && x <= this.field_146294_l / 2 + 72 && y >= this.field_146295_m / 2 - 38 + 59 && y <= this.field_146295_m / 2 - 38 + 59 + 12) {
                        this.renamingSpaceStation = false;
                    }
                    clickHandled = true;
                }
            } else {
                this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                if (x >= this.field_146294_l / 2 - 47 && x <= this.field_146294_l / 2 - 47 + 94 && y >= TOP && y <= TOP + 11 && this.selectedStationOwner.length() != 0 && this.selectedStationOwner.equalsIgnoreCase(PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g))) {
                    this.renamingSpaceStation = true;
                    this.renamingString = null;
                    clickHandled = true;
                }
                Satellite selectedSatellite = (Satellite)this.selectedBody;
                int stationListSize = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).size();
                int max = Math.min(this.field_146295_m / 2 / 14, stationListSize);
                int xPos = RHS - 85;
                int yPos2 = TOP + 45;
                if (x >= xPos && x <= xPos + 61 && y >= yPos2 && y <= yPos2 + 4) {
                    if (this.spaceStationListOffset > 0) {
                        --this.spaceStationListOffset;
                    }
                    clickHandled = true;
                }
                xPos = RHS - 85;
                yPos2 = TOP + 49 + max * 14;
                if (x >= xPos && x <= xPos + 61 && y >= yPos2 && y <= yPos2 + 4) {
                    if (max + this.spaceStationListOffset < stationListSize) {
                        ++this.spaceStationListOffset;
                    }
                    clickHandled = true;
                }
                Iterator<Map.Entry<String, StationDataGUI>> it = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).entrySet().iterator();
                int i = 0;
                int j = 0;
                while (it.hasNext() && i < max) {
                    Map.Entry<String, StationDataGUI> e = it.next();
                    if (j >= this.spaceStationListOffset) {
                        int xOffset = 0;
                        if (e.getKey().equalsIgnoreCase(this.selectedStationOwner)) {
                            xOffset -= 5;
                        }
                        xPos = RHS - 95 + xOffset;
                        yPos2 = TOP + 50 + i * 14;
                        if (x >= xPos && x <= xPos + 93 && y >= yPos2 && y <= yPos2 + 12) {
                            this.selectedStationOwner = e.getKey();
                            clickHandled = true;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        int xPos = LHS + 2;
        int yPos = TOP + 10;
        boolean bl = planetZoomedMoon = this.isZoomed() && this.selectedParent instanceof Planet;
        if (x >= xPos && x <= xPos + 93 && y >= yPos && y <= yPos + 12 && this.selectedParent instanceof CelestialBody) {
            if (this.selectedBody == null) {
                this.preSelectZoom = this.zoom;
                this.preSelectPosition = this.position;
            }
            EnumSelection selectionCountOld = this.selectionState;
            if (this.isSelected()) {
                this.unselectCelestialBody();
            }
            if (selectionCountOld == EnumSelection.ZOOMED) {
                this.selectionState = EnumSelection.SELECTED;
            }
            this.selectedBody = (CelestialBody)this.selectedParent;
            this.ticksSinceSelectionF = 0.0f;
            this.ticksSinceSelection = 0;
            this.selectionState = EnumSelection.values()[this.selectionState.ordinal() + 1];
            if (this.isZoomed() && !planetZoomedMoon) {
                this.ticksSinceMenuOpenF = 0.0f;
                this.ticksSinceMenuOpen = 0;
            }
            clickHandled = true;
        }
        if (x >= xPos && x <= xPos + 93 && y >= (yPos += 22) && y <= yPos + 12) {
            if (planetZoomedMoon) {
                if (this.selectedBody == null) {
                    this.preSelectZoom = this.zoom;
                    this.preSelectPosition = this.position;
                }
                EnumSelection selectionCountOld = this.selectionState;
                if (this.isSelected()) {
                    this.unselectCelestialBody();
                }
                if (selectionCountOld == EnumSelection.ZOOMED) {
                    this.selectionState = EnumSelection.SELECTED;
                }
                this.selectedBody = (CelestialBody)this.selectedParent;
                this.ticksSinceSelectionF = 0.0f;
                this.ticksSinceSelection = 0;
                this.selectionState = EnumSelection.values()[this.selectionState.ordinal() + 1];
            }
            clickHandled = true;
        }
        if (!clickHandled) {
            List<CelestialBody> children = this.getChildren(this.isZoomed() && !(this.selectedParent instanceof Planet) ? this.selectedBody : this.selectedParent, this.bodyScroll, this.maxBodyScroll);
            yPos = TOP + 50;
            Iterator<CelestialBody> yPos2 = children.iterator();
            while (yPos2.hasNext()) {
                CelestialBody child;
                clickHandled = this.testClicked(child, (child = yPos2.next()).equals((Object)this.selectedBody) ? 5 : 0, yPos, x, y, false);
                yPos += 14;
                if (!clickHandled && !this.isZoomed() && child.equals((Object)this.selectedBody)) {
                    List<CelestialBody> grandchildren = this.getChildren(child, 0, this.maxBodyScroll);
                    int gOffset = 0;
                    for (CelestialBody grandchild : grandchildren) {
                        if (gOffset + 14 > this.animateGrandchildren) break;
                        clickHandled = this.testClicked(grandchild, 10, yPos, x, y, true);
                        yPos += 14;
                        gOffset += 14;
                        if (!clickHandled) continue;
                        break;
                    }
                    yPos += this.animateGrandchildren - gOffset;
                }
                if (!clickHandled) continue;
                break;
            }
        }
        if (!clickHandled) {
            for (Map.Entry<CelestialBody, Vector3f> e : this.planetPosMap.entrySet()) {
                float iconSize;
                CelestialBody bodyClicked = e.getKey();
                if (this.selectedBody == null && bodyClicked instanceof IChildBody || !((float)mouseX >= e.getValue().x - (iconSize = e.getValue().z)) || !((float)mouseX <= e.getValue().x + iconSize) || !((float)mouseY >= e.getValue().y - iconSize) || !((float)mouseY <= e.getValue().y + iconSize) || this.selectedBody == bodyClicked && this.isZoomed()) continue;
                if (this.isSelected() && this.selectedBody != bodyClicked) {
                    if (this.isZoomed()) {
                        this.selectionState = EnumSelection.SELECTED;
                    }
                    this.bodyScroll = 0;
                }
                if (bodyClicked != this.selectedBody) {
                    this.lastSelectedBody = this.selectedBody;
                    this.animateGrandchildren = 0;
                    if (!(this.selectedBody instanceof IChildBody) || ((IChildBody)this.selectedBody).getParentPlanet() != bodyClicked) {
                        this.selectionState = EnumSelection.UNSELECTED;
                    }
                } else {
                    this.doneZooming = false;
                    this.planetZoom = 0.0f;
                }
                this.selectedBody = bodyClicked;
                this.ticksSinceSelectionF = 0.0f;
                this.ticksSinceSelection = 0;
                this.selectionState = EnumSelection.values()[this.selectionState.ordinal() + 1];
                if (bodyClicked instanceof IChildBody) {
                    this.selectionState = EnumSelection.ZOOMED;
                }
                if (this.isZoomed()) {
                    this.ticksSinceMenuOpenF = 0.0f;
                    this.ticksSinceMenuOpen = 0;
                }
                if (this.selectedBody instanceof Satellite && this.spaceStationMap.get(this.getSatelliteParentID((Satellite)this.selectedBody)).size() == 1) {
                    Iterator<Map.Entry<String, StationDataGUI>> it = this.spaceStationMap.get(this.getSatelliteParentID((Satellite)this.selectedBody)).entrySet().iterator();
                    this.selectedStationOwner = it.next().getKey();
                }
                clickHandled = true;
                break;
            }
        }
        if (!clickHandled) {
            if (this.selectedBody != null) {
                this.unselectCelestialBody();
                this.planetZoom = 0.0f;
            }
            this.mouseDragging = true;
        }
        Object selectedParent = this.selectedParent;
        if (this.selectedBody instanceof IChildBody) {
            selectedParent = ((IChildBody)this.selectedBody).getParentPlanet();
        } else if (this.selectedBody instanceof Planet) {
            selectedParent = ((Planet)this.selectedBody).getParentSolarSystem();
        } else if (this.selectedBody == null) {
            selectedParent = GalacticraftCore.solarSystemSol;
        }
        if (this.selectedParent != selectedParent) {
            this.selectedParent = selectedParent;
        }
    }

    protected boolean testClicked(CelestialBody body, int xOffset, int yPos, int x, int y, boolean grandchild) {
        int xPos = BORDER_SIZE + BORDER_EDGE_SIZE + 2 + xOffset;
        if (!(x < xPos || x > xPos + 93 || y < yPos || y > yPos + 12 || this.selectedBody == body && this.isZoomed())) {
            EnumSelection selectionCountOld;
            if (this.selectedBody == null) {
                this.preSelectZoom = this.zoom;
                this.preSelectPosition = this.position;
            }
            if ((selectionCountOld = this.selectionState) == EnumSelection.ZOOMED) {
                this.selectionState = EnumSelection.SELECTED;
            }
            this.doneZooming = false;
            this.planetZoom = 0.0f;
            if (body != this.selectedBody) {
                this.lastSelectedBody = this.selectedBody;
                this.selectionState = EnumSelection.SELECTED;
                this.bodyScroll = 0;
            } else {
                this.selectionState = EnumSelection.values()[this.selectionState.ordinal() + 1];
            }
            this.selectedBody = body;
            this.ticksSinceSelectionF = 0.0f;
            this.ticksSinceSelection = 0;
            if (grandchild) {
                this.selectionState = EnumSelection.ZOOMED;
            }
            if (this.isZoomed()) {
                this.ticksSinceMenuOpenF = 0.0f;
                this.ticksSinceMenuOpen = 0;
            }
            this.animateGrandchildren = 0;
            return true;
        }
        return false;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mousePosX, int mousePosY, float partialTicks) {
        block13: {
            float wheel;
            this.ticksSinceMenuOpenF += partialTicks;
            this.ticksTotalF += partialTicks;
            if (this.selectedBody != null) {
                this.ticksSinceSelectionF += partialTicks;
            }
            if (this.selectedBody == null && this.ticksSinceUnselectionF >= 0.0f) {
                this.ticksSinceUnselectionF += partialTicks;
            }
            if (Mouse.hasWheel() && (wheel = (float)Mouse.getDWheel() / (this.selectedBody == null ? 500.0f : 250.0f)) != 0.0f) {
                if (mousePosX < 105) {
                    boolean planetZoomedNotMoon;
                    boolean bl = planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
                    if (wheel > 0.0f && this.bodyScroll > 0) {
                        --this.bodyScroll;
                    } else if (wheel < 0.0f && this.bodyScroll < this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent, 0, 0, false).size() - this.maxBodyScroll) {
                        ++this.bodyScroll;
                    }
                } else if (this.selectedBody == null || this.viewState == EnumView.PREVIEW && !this.isZoomed()) {
                    this.zoom = Math.min(Math.max(this.zoom + wheel * (this.zoom + 2.0f) / 10.0f, -1.0f), 3.0f);
                } else {
                    this.planetZoom = Math.min(Math.max(this.planetZoom + wheel, -4.9f), 5.0f);
                }
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            Matrix4f camMatrix = new Matrix4f();
            Matrix4f.translate((Vector3f)new Vector3f(0.0f, 0.0f, -9000.0f), (Matrix4f)camMatrix, (Matrix4f)camMatrix);
            Matrix4f viewMatrix = new Matrix4f();
            viewMatrix.m00 = 2.0f / (float)this.field_146294_l;
            viewMatrix.m11 = 2.0f / (float)(-this.field_146295_m);
            viewMatrix.m22 = -2.2222222E-4f;
            viewMatrix.m30 = -1.0f;
            viewMatrix.m31 = 1.0f;
            viewMatrix.m32 = -2.0f;
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
            fb.rewind();
            viewMatrix.store(fb);
            fb.flip();
            GL11.glMultMatrix((FloatBuffer)fb);
            fb.clear();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            fb.rewind();
            camMatrix.store(fb);
            fb.flip();
            fb.clear();
            GL11.glMultMatrix((FloatBuffer)fb);
            this.setBlackBackground();
            GL11.glPushMatrix();
            Matrix4f worldMatrix = this.setIsometric(partialTicks);
            float gridSize = 7000.0f;
            this.drawGrid(gridSize, (float)(this.field_146295_m / 3) / 3.5f);
            this.drawCircles();
            GL11.glPopMatrix();
            HashMap<CelestialBody, Matrix4f> matrixMap = this.drawCelestialBodies(worldMatrix);
            this.planetPosMap.clear();
            for (Map.Entry<CelestialBody, Matrix4f> e : matrixMap.entrySet()) {
                Matrix4f planetMatrix = e.getValue();
                Matrix4f matrix0 = Matrix4f.mul((Matrix4f)viewMatrix, (Matrix4f)planetMatrix, (Matrix4f)planetMatrix);
                int x = (int)Math.floor(((double)matrix0.m30 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71443_c);
                int y = (int)Math.floor((double)Minecraft.func_71410_x().field_71440_d - ((double)matrix0.m31 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71440_d);
                Vector2f vec = new Vector2f((float)x, (float)y);
                Matrix4f scaleVec = new Matrix4f();
                scaleVec.m00 = matrix0.m00;
                scaleVec.m11 = matrix0.m11;
                scaleVec.m22 = matrix0.m22;
                Vector4f newVec = Matrix4f.transform((Matrix4f)scaleVec, (Vector4f)new Vector4f(2.0f, -2.0f, 0.0f, 0.0f), null);
                float iconSize = newVec.y * ((float)Minecraft.func_71410_x().field_71440_d / 2.0f) * (float)(e.getKey() instanceof Star ? 2 : 1) * (e.getKey() == this.selectedBody ? 1.5f : 1.0f);
                this.planetPosMap.put(e.getKey(), new Vector3f(vec.x, vec.y, iconSize));
            }
            this.drawSelectionCursor(fb, worldMatrix);
            try {
                this.drawButtons(mousePosX, mousePosY);
            }
            catch (Exception e) {
                if (this.errorLogged) break block13;
                this.errorLogged = true;
                GCLog.severe((String)"Problem identifying planet or dimension in an add on for Galacticraft!");
                GCLog.severe((String)"(The problem is likely caused by a dimension ID conflict.  Check configs for dimension clashes.  You can also try disabling Mars space station in configs.)");
                e.printStackTrace();
            }
        }
        this.drawBorder();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    protected void drawSelectionCursor(FloatBuffer fb, Matrix4f worldMatrix) {
        GL11.glPushMatrix();
        switch (this.selectionState) {
            case SELECTED: {
                if (this.selectedBody == null) break;
                this.setupMatrix(this.selectedBody, worldMatrix, fb);
                fb.clear();
                GL11.glScalef((float)0.06666667f, (float)0.06666667f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                float colMod = this.getZoomAdvanced() < 4.9f ? (float)(Math.sin(this.ticksSinceSelectionF / 2.0f) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)(1.0f * colMod));
                int width = (int)Math.floor((double)this.getWidthForCelestialBody(this.selectedBody) / 2.0 * (this.selectedBody instanceof IChildBody ? 9.0 : 30.0));
                this.drawTexturedModalRect(-width, -width, width * 2, width * 2, 266, 29, 100, 100, false, false);
                break;
            }
            case ZOOMED: {
                if (this.selectedBody == null) break;
                this.setupMatrix(this.selectedBody, worldMatrix, fb);
                fb.clear();
                float div = this.zoom + 1.0f - this.planetZoom;
                float scale = Math.max(0.3f, 1.5f / (this.ticksSinceSelectionF / 5.0f)) * 2.0f / div;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                float colMod = this.getZoomAdvanced() < 4.9f ? (float)(Math.sin(this.ticksSinceSelectionF / 1.0f) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)0.4f, (float)0.8f, (float)1.0f, (float)(1.0f * colMod));
                int width = this.getWidthForCelestialBody(this.selectedBody) * 13;
                this.drawTexturedModalRect(-width, -width, width * 2, width * 2, 266, 29, 100, 100, false, false);
                break;
            }
        }
        GL11.glPopMatrix();
    }

    protected Vector3f getCelestialBodyPosition(CelestialBody cBody) {
        if (cBody == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (cBody instanceof Star) {
            if (cBody.getUnlocalizedName().equalsIgnoreCase("star.sol")) {
                return new Vector3f();
            }
            return ((Star)cBody).getParentSolarSystem().getMapPosition().toVector3f();
        }
        float timeScale = cBody instanceof Planet ? 200.0f : 2.0f;
        float orbit_ext_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitEccentricity() : 1.0f;
        float orbit_ext_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitEccentricity() : 1.0f;
        float orbit_offset_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitOffset() : 0.0f;
        float orbit_offset_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitOffset() : 0.0f;
        float distanceFromCenter = this.getScale(cBody);
        float x = (float)Math.sin(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        float y = (float)Math.cos(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        Vector3f cBodyPos = new Vector3f((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f), (y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f), 0.0f);
        if (cBody instanceof Planet) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((Planet)cBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        if (cBody instanceof IChildBody) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((IChildBody)cBody).getParentPlanet());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        if (cBody instanceof ICelestialRegistry) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((ICelestialRegistry)cBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        return cBodyPos;
    }

    public int getWidthForCelestialBody(CelestialBody celestialBody) {
        boolean zoomed;
        float size = celestialBody.getRelativeSize();
        if ((double)size < 0.9 && celestialBody instanceof IChildBody) {
            size = 1.0f;
        }
        if (size > 5.0f) {
            size = 5.0f;
        }
        boolean bl = zoomed = celestialBody == this.selectedBody && this.selectionState == EnumSelection.SELECTED;
        return (int)(celestialBody instanceof Star ? (zoomed ? 12.0f * size : 8.0f * size) : (celestialBody instanceof Planet ? (zoomed ? 6.0f * size : 4.0f * size) : (celestialBody instanceof IChildBody ? (zoomed ? 6.0f * size : 4.0f * size) : 2.0f)));
    }

    public HashMap<CelestialBody, Matrix4f> drawCelestialBodies(Matrix4f worldMatrix) {
        Matrix4f worldMatrixLocal;
        float alpha;
        boolean hasParent;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
        HashMap matrixMap = Maps.newHashMap();
        for (CelestialBody body : this.bodiesToRender) {
            hasParent = body instanceof IChildBody;
            alpha = this.getAlpha(body);
            if (!(alpha > 0.0f)) continue;
            GlStateManager.func_179094_E();
            worldMatrixLocal = this.setupMatrix(body, worldMatrix, fb, hasParent ? 0.25f : 1.0f);
            CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre(body, body.getBodyIcon(), 16);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (preEvent.celestialBodyTexture != null) {
                this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
            }
            if (!preEvent.isCanceled()) {
                int size = this.getWidthForCelestialBody(body);
                BodiesData data = BodiesRegistry.getData().get(body);
                if (body instanceof Star || data != null && data.getTypePlanet() == IAdvancedSpace.TypeBody.STAR) {
                    GL11.glPushMatrix();
                    GL11.glShadeModel((int)7425);
                    GL11.glPolygonMode((int)1032, (int)6914);
                    GL11.glDisable((int)3553);
                    float r = 1.0f;
                    float g = 1.0f;
                    float b = 0.8f;
                    float a = 0.5f;
                    float f10 = size * 4;
                    if (data != null && data.getTypePlanet() == IAdvancedSpace.TypeBody.STAR && data.getStarColor() != null) {
                        r = data.getStarColor().getColor().floatX() / 255.0f;
                        g = data.getStarColor().getColor().floatY() / 255.0f;
                        b = data.getStarColor().getColor().floatZ() / 255.0f;
                        a = 0.7f;
                    }
                    float xSize = size / 2 - 4;
                    float ySize = size / 2 - 4;
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
                    GL11.glDisable((int)2884);
                    GL11.glBegin((int)6);
                    GL11.glVertex2d((double)(xSize /= 4.0f), (double)(ySize /= 4.0f));
                    for (int angle = 0; angle <= 360; angle += 60) {
                        if (angle % 120 == 0) {
                            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                        }
                        double x = (double)f10 * Math.cos((double)angle * Math.PI / 180.0);
                        double y = (double)f10 * Math.sin((double)angle * Math.PI / 180.0);
                        GL11.glVertex2d((double)(x + (double)xSize), (double)(y + (double)ySize));
                    }
                    GL11.glEnd();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3008);
                    GL11.glDisable((int)3042);
                    GL11.glPolygonMode((int)1032, (int)6914);
                    GL11.glPopMatrix();
                }
                this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                matrixMap.put(body, worldMatrixLocal);
            }
            CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            GlStateManager.func_179121_F();
        }
        for (CelestialBody body : this.bodiesToRender) {
            hasParent = body instanceof IChildBody;
            alpha = this.getAlpha(body);
            if (!(body instanceof Satellite && alpha > 0.0f) && (body instanceof Satellite || !(alpha >= 0.0f))) continue;
            GlStateManager.func_179094_E();
            worldMatrixLocal = this.setupMatrix(body, worldMatrix, fb, hasParent ? 0.25f : 1.0f);
            if (this.selectionState == EnumSelection.UNSELECTED && !hasParent || this.selectionState == EnumSelection.ZOOMED && hasParent) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                String name = body.getLocalizedName();
                BodiesData data = BodiesRegistry.getData().get(body);
                this.field_146289_q.func_78276_b(name, 4 + this.getWidthForCelestialBody(body), -5, body instanceof Star || data != null && data.getTypePlanet() == IAdvancedSpace.TypeBody.STAR ? YELLOW : WHITE);
                if (ClientProxyCore.playerHead != null) {
                    if (this.selectionState == EnumSelection.UNSELECTED && this.field_146297_k.field_71441_e.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody() instanceof IChildBody) {
                        if (body == ((IChildBody)((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody()).getParentPlanet()) {
                            GlStateManager.func_179147_l();
                            GlStateManager.func_179112_b((int)770, (int)771);
                            GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                            this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                            this.func_73729_b(10 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                        }
                    } else if (this.field_146297_k.field_71441_e.field_73011_w instanceof IGalacticraftWorldProvider && body != GalacticraftCore.planetOverworld && ((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody() == body) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                        this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                        this.func_73729_b(10 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                    } else if (this.field_146297_k.field_71441_e.field_73011_w instanceof WorldProviderSurface && body == GalacticraftCore.planetOverworld) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                        this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                        this.func_73729_b(10 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                    }
                }
            }
            GlStateManager.func_179121_F();
        }
        return matrixMap;
    }

    public void drawBorder() {
        Gui.func_73734_a((int)0, (int)0, (int)BORDER_SIZE, (int)this.field_146295_m, (int)GREY2);
        Gui.func_73734_a((int)(this.field_146294_l - BORDER_SIZE), (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)GREY2);
        Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)BORDER_SIZE, (int)GREY2);
        Gui.func_73734_a((int)0, (int)(this.field_146295_m - BORDER_SIZE), (int)this.field_146294_l, (int)this.field_146295_m, (int)GREY2);
        Gui.func_73734_a((int)BORDER_SIZE, (int)BORDER_SIZE, (int)(BORDER_SIZE + BORDER_EDGE_SIZE), (int)(this.field_146295_m - BORDER_SIZE), (int)GREY0);
        Gui.func_73734_a((int)BORDER_SIZE, (int)BORDER_SIZE, (int)(this.field_146294_l - BORDER_SIZE), (int)(BORDER_SIZE + BORDER_EDGE_SIZE), (int)GREY0);
        Gui.func_73734_a((int)(this.field_146294_l - BORDER_SIZE - BORDER_EDGE_SIZE), (int)BORDER_SIZE, (int)(this.field_146294_l - BORDER_SIZE), (int)(this.field_146295_m - BORDER_SIZE), (int)GREY1);
        Gui.func_73734_a((int)(BORDER_SIZE + BORDER_EDGE_SIZE), (int)(this.field_146295_m - BORDER_SIZE - BORDER_EDGE_SIZE), (int)(this.field_146294_l - BORDER_SIZE), (int)(this.field_146295_m - BORDER_SIZE), (int)GREY1);
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        this.field_73735_i = 0.0f;
        boolean handledSliderPos = false;
        int LHS = BORDER_SIZE + BORDER_EDGE_SIZE;
        int RHS = this.field_146294_l - LHS;
        int TOP = LHS;
        int BOT = this.field_146295_m - LHS;
        if (this.viewState == EnumView.PROFILE) {
            this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.field_146294_l / 2 - 43, TOP, 86, 15, 266, 0, 172, 29, false, false);
            String str = GCCoreUtil.translate((String)"gui.message.catalog.name").toUpperCase();
            this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + this.field_146289_q.field_78288_b / 2, WHITE);
            if (this.selectedBody != null) {
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                if (mousePosX > LHS && mousePosX < LHS + 88 && mousePosY > TOP && mousePosY < TOP + 13) {
                    GL11.glColor3f((float)3.0f, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glColor3f((float)0.9f, (float)0.2f, (float)0.2f);
                }
                this.drawTexturedModalRect(LHS, TOP, 88, 13, 0, 392, 148, 22, false, false);
                str = GCCoreUtil.translate((String)"gui.message.back.name").toUpperCase();
                this.field_146289_q.func_78276_b(str, LHS + 45 - this.field_146289_q.func_78256_a(str) / 2, TOP + this.field_146289_q.field_78288_b / 2 - 2, WHITE);
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                if (mousePosX > RHS - 88 && mousePosX < RHS && mousePosY > TOP && mousePosY < TOP + 13) {
                    GL11.glColor3f((float)0.0f, (float)3.0f, (float)0.0f);
                } else {
                    GL11.glColor3f((float)0.2f, (float)0.9f, (float)0.2f);
                }
                this.drawTexturedModalRect(RHS - 88, TOP, 88, 13, 0, 392, 148, 22, true, false);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(LHS, BOT - 13, 88, 13, 0, 392, 148, 22, false, true);
                this.drawTexturedModalRect(RHS - 88, BOT - 13, 88, 13, 0, 392, 148, 22, true, true);
                int menuTopLeft = TOP - 115 + this.field_146295_m / 2 - 4;
                int posX = LHS + Math.min((int)this.ticksSinceSelectionF * 10, 133) - 134;
                int posX2 = (int)((float)LHS + Math.min(this.ticksSinceSelectionF * 1.25f, 15.0f) - 15.0f);
                int fontPosY = menuTopLeft + BORDER_EDGE_SIZE + this.field_146289_q.field_78288_b / 2 - 2;
                this.drawTexturedModalRect(posX, menuTopLeft + 12, 133, 196, 0, 0, 266, 392, false, false);
                str = GCCoreUtil.translate((String)"gui.message.daynightcycle.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 14, CYAN);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".daynightcycle.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 25, WHITE);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".daynightcycle.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 36, WHITE);
                }
                str = GCCoreUtil.translate((String)"gui.message.surfacegravity.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 50, CYAN);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacegravity.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 61, WHITE);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacegravity.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 72, WHITE);
                }
                str = GCCoreUtil.translate((String)"gui.message.surfacecomposition.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 88, CYAN);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacecomposition.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 99, WHITE);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacecomposition.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 110, WHITE);
                }
                str = GCCoreUtil.translate((String)"gui.message.atmosphere.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 126, CYAN);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".atmosphere.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 137, WHITE);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".atmosphere.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 148, WHITE);
                }
                str = GCCoreUtil.translate((String)"gui.message.meansurfacetemp.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 165, CYAN);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".meansurfacetemp.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 176, WHITE);
                str = GCCoreUtil.translate((String)("gui.message." + this.selectedBody.getName() + ".meansurfacetemp.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 187, WHITE);
                }
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(posX2, menuTopLeft + 12, 17, 199, 439, 0, 32, 399, false, false);
            }
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(LHS, TOP, 74, 11, 0, 392, 148, 22, false, false);
            String str = GCCoreUtil.translate((String)"gui.message.catalog.name").toUpperCase();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b(str, LHS + 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
            int scale = (int)Math.min(95.0f, this.ticksSinceMenuOpenF * 12.0f);
            boolean planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
            this.drawTexturedModalRect(LHS - 95 + scale, TOP + 12, 95, 41, 0, 436, 95, 41, false, false);
            str = planetZoomedNotMoon ? this.selectedBody.getLocalizedName() : this.getParentName();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b(str, LHS + 9 - 95 + scale, TOP + 34, WHITE);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
            this.drawTexturedModalRect(LHS + 2 - 95 + scale, TOP + 14, 93, 17, 95, 436, 93, 17, false, false);
            str = planetZoomedNotMoon ? this.getParentName() : this.getGrandparentName();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b(str, LHS + 7 - 95 + scale, TOP + 16, GREY3);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            List<CelestialBody> children = this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent, this.bodyScroll, this.maxBodyScroll);
            this.drawChildren(children, 0, 0, true);
            if (this.mapMode) {
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                this.drawTexturedModalRect(RHS - 74, TOP, 74, 11, 0, 392, 148, 22, true, false);
                str = GCCoreUtil.translate((String)"gui.message.exit.name").toUpperCase();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146289_q.func_78276_b(str, RHS - 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
            }
            if (this.selectedBody != null) {
                this.field_146297_k.field_71446_o.func_110577_a(guiMain1);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                if (this.selectedBody instanceof Satellite) {
                    Satellite selectedSatellite = (Satellite)this.selectedBody;
                    int stationListSize = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).size();
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain1);
                    int max = Math.min(this.field_146295_m / 2 / 14, stationListSize);
                    this.drawTexturedModalRect(RHS - 95, TOP, 95, 53, this.selectedStationOwner.length() == 0 ? 95 : 0, 186, 95, 53, false, false);
                    if (this.spaceStationListOffset <= 0) {
                        GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(RHS - 85, TOP + 45, 61, 4, 0, 239, 61, 4, false, false);
                    if (max + this.spaceStationListOffset >= stationListSize) {
                        GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(RHS - 85, TOP + 49 + max * 14, 61, 4, 0, 239, 61, 4, false, true);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    if (this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).get(this.selectedStationOwner) == null) {
                        str = GCCoreUtil.translate((String)"gui.message.select_ss.name");
                        this.drawSplitString(str, RHS - 47, TOP + 20, 91, WHITE, false, false);
                    } else {
                        str = GCCoreUtil.translate((String)"gui.message.ss_owner.name");
                        this.field_146289_q.func_78276_b(str, RHS - 85, TOP + 18, WHITE);
                        str = this.selectedStationOwner;
                        this.field_146289_q.func_78276_b(str, RHS - 47 - this.field_146289_q.func_78256_a(str) / 2, TOP + 30, WHITE);
                    }
                    Iterator<Map.Entry<String, StationDataGUI>> it = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).entrySet().iterator();
                    int i = 0;
                    int j = 0;
                    while (it.hasNext() && i < max) {
                        Map.Entry<String, StationDataGUI> e = it.next();
                        if (j >= this.spaceStationListOffset) {
                            this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                            int xOffset = 0;
                            if (e.getKey().equalsIgnoreCase(this.selectedStationOwner)) {
                                xOffset -= 5;
                            }
                            this.drawTexturedModalRect(RHS - 95 + xOffset, TOP + 50 + i * 14, 93, 12, 95, 464, 93, 12, true, false);
                            str = "";
                            String str0 = e.getValue().getStationName();
                            for (int point = 0; this.field_146289_q.func_78256_a(str) < 80 && point < str0.length(); ++point) {
                                str = str + str0.substring(point, point + 1);
                            }
                            if (this.field_146289_q.func_78256_a(str) >= 80) {
                                str = str.substring(0, str.length() - 3);
                                str = str + "...";
                            }
                            this.field_146289_q.func_78276_b(str, RHS - 88 + xOffset, TOP + 52 + i * 14, WHITE);
                            ++i;
                        }
                        ++j;
                    }
                }
                if (this.canCreateSpaceStation(this.selectedBody) && !(this.selectedBody instanceof Satellite)) {
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain1);
                    int canCreateLength = Math.max(0, this.drawSplitString(GCCoreUtil.translate((String)"gui.message.can_create_space_station.name"), 0, 0, 91, 0, true, true) - 2);
                    this.canCreateOffset = canCreateLength * this.field_146289_q.field_78288_b;
                    this.drawTexturedModalRect(RHS - 95, TOP + 134, 93, 4, 159, 102, 93, 4, false, false);
                    for (int barY = 0; barY < canCreateLength; ++barY) {
                        this.drawTexturedModalRect(RHS - 95, TOP + 138 + barY * this.field_146289_q.field_78288_b, 93, this.field_146289_q.field_78288_b, 159, 106, 93, this.field_146289_q.field_78288_b, false, false);
                    }
                    this.drawTexturedModalRect(RHS - 95, TOP + 138 + this.canCreateOffset, 93, 43, 159, 106, 93, 43, false, false);
                    this.drawTexturedModalRect(RHS - 79, TOP + 129, 61, 4, 0, 170, 61, 4, false, false);
                    SpaceStationRecipe recipe = WorldUtil.getSpaceStationRecipe((int)this.selectedBody.getDimensionID());
                    if (recipe != null) {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                        boolean validInputMaterials = true;
                        int i = 0;
                        for (Map.Entry e : recipe.getInput().entrySet()) {
                            Object next = e.getKey();
                            int xPos = (int)((double)(RHS - 95) + (double)(i * 93) / (double)recipe.getInput().size() + 5.0);
                            int yPos = TOP + 154 + this.canCreateOffset;
                            if (next instanceof ItemStack) {
                                boolean valid;
                                int amount = this.getAmountInInventory((ItemStack)next);
                                RenderHelper.func_74520_c();
                                ItemStack toRender = ((ItemStack)next).func_77946_l();
                                this.field_146296_j.func_180450_b(toRender, xPos, yPos);
                                this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, toRender, xPos, yPos, null);
                                RenderHelper.func_74518_a();
                                GL11.glEnable((int)3042);
                                if (mousePosX >= xPos && mousePosX <= xPos + 16 && mousePosY >= yPos && mousePosY <= yPos + 16) {
                                    GL11.glDepthMask((boolean)true);
                                    GL11.glEnable((int)2929);
                                    GL11.glPushMatrix();
                                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                    int k = this.field_146289_q.func_78256_a(((ItemStack)next).func_82833_r());
                                    int j2 = mousePosX - k / 2;
                                    int k2 = mousePosY - 12;
                                    int i1 = 8;
                                    if (j2 + k > this.field_146294_l) {
                                        j2 -= j2 - this.field_146294_l + k;
                                    }
                                    if (k2 + i1 + 6 > this.field_146295_m) {
                                        k2 = this.field_146295_m - i1 - 6;
                                    }
                                    int j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                    this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
                                    int k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                    int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
                                    this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
                                    this.field_146289_q.func_78276_b(((ItemStack)next).func_82833_r(), j2, k2, WHITE);
                                    GL11.glPopMatrix();
                                }
                                str = "" + e.getValue();
                                boolean bl = valid = amount >= (Integer)e.getValue();
                                if (!valid && validInputMaterials) {
                                    validInputMaterials = false;
                                }
                                int color = valid | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d ? GREEN : RED;
                                this.field_146289_q.func_78276_b(str, xPos + 8 - this.field_146289_q.func_78256_a(str) / 2, TOP + 170 + this.canCreateOffset, color);
                            } else if (next instanceof Collection) {
                                boolean valid;
                                Collection items = (Collection)next;
                                int amount = 0;
                                for (ItemStack stack : items) {
                                    amount += this.getAmountInInventory(stack);
                                }
                                RenderHelper.func_74520_c();
                                Iterator it = items.iterator();
                                int count = 0;
                                int toRenderIndex = (int)this.ticksSinceMenuOpenF / 20 % items.size();
                                ItemStack toRender = null;
                                while (it.hasNext()) {
                                    ItemStack stack = (ItemStack)it.next();
                                    if (count == toRenderIndex) {
                                        toRender = stack;
                                        break;
                                    }
                                    ++count;
                                }
                                if (toRender == null) continue;
                                this.field_146296_j.func_180450_b(toRender, xPos, yPos);
                                this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, toRender, xPos, yPos, null);
                                RenderHelper.func_74518_a();
                                GL11.glEnable((int)3042);
                                if (mousePosX >= xPos && mousePosX <= xPos + 16 && mousePosY >= yPos && mousePosY <= yPos + 16) {
                                    GL11.glDepthMask((boolean)true);
                                    GL11.glEnable((int)2929);
                                    GL11.glPushMatrix();
                                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                    int k = this.field_146289_q.func_78256_a(toRender.func_82833_r());
                                    int j2 = mousePosX - k / 2;
                                    int k2 = mousePosY - 12;
                                    int i1 = 8;
                                    if (j2 + k > this.field_146294_l) {
                                        j2 -= j2 - this.field_146294_l + k;
                                    }
                                    if (k2 + i1 + 6 > this.field_146295_m) {
                                        k2 = this.field_146295_m - i1 - 6;
                                    }
                                    int j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                    this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
                                    int k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                    int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
                                    this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
                                    this.field_146289_q.func_78276_b(toRender.func_82833_r(), j2, k2, WHITE);
                                    GL11.glPopMatrix();
                                }
                                str = "" + e.getValue();
                                boolean bl = valid = amount >= (Integer)e.getValue();
                                if (!valid && validInputMaterials) {
                                    validInputMaterials = false;
                                }
                                int color = valid | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d ? GREEN : RED;
                                this.field_146289_q.func_78276_b(str, xPos + 8 - this.field_146289_q.func_78256_a(str) / 2, TOP + 170 + this.canCreateOffset, color);
                            }
                            ++i;
                        }
                        if (validInputMaterials || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        this.field_146297_k.field_71446_o.func_110577_a(guiMain1);
                        if (!this.mapMode && mousePosX >= RHS - 95 && mousePosX <= RHS && mousePosY >= TOP + 182 + this.canCreateOffset && mousePosY <= TOP + 182 + 12 + this.canCreateOffset) {
                            this.drawTexturedModalRect(RHS - 95, TOP + 182 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                        }
                        this.drawTexturedModalRect(RHS - 95, TOP + 182 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                        int color = (int)((Math.sin((double)this.ticksSinceMenuOpenF / 5.0) * 0.5 + 0.5) * 255.0);
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.can_create_space_station.name"), RHS - 48, TOP + 137, 91, ColorUtil.to32BitColor((int)255, (int)color, (int)255, (int)color), true, false);
                        if (!this.mapMode) {
                            this.drawSplitString(GCCoreUtil.translate((String)"gui.message.create_ss.name").toUpperCase(), RHS - 48, TOP + 185 + this.canCreateOffset, 91, WHITE, false, false);
                        }
                    } else {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.cannot_create_space_station.name"), RHS - 48, TOP + 138, 91, WHITE, true, false);
                    }
                }
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f - Math.min(0.3f, this.ticksSinceSelectionF / 50.0f)));
                this.drawTexturedModalRect(LHS, TOP, 74, 11, 0, 392, 148, 22, false, false);
                str = GCCoreUtil.translate((String)"gui.message.catalog.name").toUpperCase();
                this.field_146289_q.func_78276_b(str, LHS + 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                if (this.selectedBody instanceof Satellite) {
                    if (this.selectedStationOwner.length() == 0 || !this.selectedStationOwner.equalsIgnoreCase(PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g))) {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                } else {
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                }
                if (this.selectedBody.getTierRequirement() >= 0 && !(this.selectedBody instanceof Satellite)) {
                    boolean canReach;
                    if (!this.selectedBody.getReachable() || this.possibleBodies != null && !this.possibleBodies.contains(this.selectedBody)) {
                        canReach = false;
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        canReach = true;
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 30, TOP + 11, 30, 11, 0, 414, 60, 22, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2, TOP + 11, 30, 11, 128, 414, 60, 22, false, false);
                    str = GCCoreUtil.translateWithFormat((String)"gui.message.tier.name", (Object[])new Object[]{this.selectedBody.getTierRequirement() == 0 ? "?" : Integer.valueOf(this.selectedBody.getTierRequirement())});
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + 13, canReach ? GREY4 : RED3);
                }
                str = this.selectedBody.getLocalizedName();
                if (this.selectedBody instanceof Satellite) {
                    str = GCCoreUtil.translate((String)"gui.message.rename.name").toUpperCase();
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + 2, this.selectedBody instanceof Star ? YELLOW : WHITE);
                this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(LHS + 4, TOP, 83, 12, 0, 477, 83, 12, false, false);
                if (!this.mapMode) {
                    if (!this.selectedBody.getReachable() || this.possibleBodies != null && !this.possibleBodies.contains(this.selectedBody) || this.selectedBody instanceof Satellite && this.selectedStationOwner.equals("")) {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                    this.drawTexturedModalRect(RHS - 74, TOP, 74, 11, 0, 392, 148, 22, true, false);
                    str = GCCoreUtil.translate((String)"gui.message.launch.name").toUpperCase();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, RHS - 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 2, WHITE);
                }
                if (this.selectionState == EnumSelection.SELECTED && !(this.selectedBody instanceof Satellite)) {
                    boolean flag1;
                    handledSliderPos = true;
                    int sliderPos = this.zoomTooltipPos;
                    if (this.zoomTooltipPos != 38) {
                        this.zoomTooltipPos = sliderPos = Math.min((int)this.ticksSinceSelectionF * 2, 38);
                    }
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
                    this.drawTexturedModalRect(RHS - 182, this.field_146295_m - BORDER_SIZE - BORDER_EDGE_SIZE - sliderPos, 83, 38, 346, 436, 166, 76, true, false);
                    boolean flag0 = GalaxyRegistry.getSatellitesForCelestialBody((CelestialBody)this.selectedBody).size() > 0;
                    boolean bl = flag1 = this.selectedBody instanceof Planet && GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selectedBody)).size() > 0;
                    if (flag0 && flag1) {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.0.name"), RHS - 182 + 41, this.field_146295_m - BORDER_SIZE - BORDER_EDGE_SIZE + 2 - sliderPos, 79, GREY5, false, false);
                    } else if (!flag0 && flag1) {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.1.name"), RHS - 182 + 41, this.field_146295_m - BORDER_SIZE - BORDER_EDGE_SIZE + 6 - sliderPos, 79, GREY5, false, false);
                    } else if (flag0) {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.2.name"), RHS - 182 + 41, this.field_146295_m - BORDER_SIZE - BORDER_EDGE_SIZE + 6 - sliderPos, 79, GREY5, false, false);
                    } else {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.3.name"), RHS - 182 + 41, this.field_146295_m - BORDER_SIZE - BORDER_EDGE_SIZE + 11 - sliderPos, 79, GREY5, false, false);
                    }
                }
                if (this.selectedBody instanceof Satellite && this.renamingSpaceStation) {
                    this.func_146276_q_();
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(guiMain1);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90, this.field_146295_m / 2 - 38, 179, 67, 159, 0, 179, 67, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 4, this.field_146295_m / 2 - 38 + 2, 171, 10, 159, 92, 171, 10, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 8, this.field_146295_m / 2 - 38 + 18, 161, 13, 159, 67, 161, 13, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 17, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, true, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, false, false);
                    str = GCCoreUtil.translate((String)"gui.message.assign_name.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 - 35, WHITE);
                    str = GCCoreUtil.translate((String)"gui.message.apply.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2 - 36, this.field_146295_m / 2 + 23, WHITE);
                    str = GCCoreUtil.translate((String)"gui.message.cancel.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 + 36 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 + 23, WHITE);
                    if (this.renamingString == null) {
                        Satellite selectedSatellite = (Satellite)this.selectedBody;
                        String playerName = PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g);
                        this.renamingString = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).get(playerName).getStationName();
                        if (this.renamingString == null) {
                            this.renamingString = this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite)).get(playerName.toLowerCase()).getStationName();
                        }
                        if (this.renamingString == null) {
                            this.renamingString = "";
                        }
                    }
                    str = this.renamingString;
                    String str0 = this.renamingString;
                    if (this.ticksSinceMenuOpenF / 10.0f % 2.0f == 0.0f) {
                        str0 = str0 + "_";
                    }
                    this.field_146289_q.func_78276_b(str0, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 - 17, WHITE);
                }
            }
        }
        if (!handledSliderPos) {
            this.zoomTooltipPos = 0;
        }
    }

    protected int drawChildren(List<CelestialBody> children, int xOffsetBase, int yOffsetPrior, boolean recursive) {
        xOffsetBase += BORDER_SIZE + BORDER_EDGE_SIZE;
        int yOffsetBase = BORDER_SIZE + BORDER_EDGE_SIZE + 50 + yOffsetPrior;
        int yOffset = 0;
        for (int i = 0; i < children.size(); ++i) {
            List<CelestialBody> grandchildren;
            float brightness;
            CelestialBody child = children.get(i);
            int xOffset = xOffsetBase + (child.equals((Object)this.selectedBody) ? 5 : 0);
            int scale = (int)Math.min(95.0f, Math.max(0.0f, this.ticksSinceMenuOpenF * 25.0f - (float)(95 * i)));
            this.field_146297_k.field_71446_o.func_110577_a(guiMain0);
            float f = brightness = child.equals((Object)this.selectedBody) ? 0.2f : 0.0f;
            if (child.getReachable()) {
                if (child.equals((Object)this.selectedBody)) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)((float)scale / 95.0f));
                } else {
                    GL11.glColor4f((float)0.0f, (float)(0.6f + brightness), (float)0.0f, (float)((float)scale / 95.0f));
                }
            } else {
                BodiesData data;
                boolean checked = false;
                if (child instanceof Planet) {
                    for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)child))) {
                        if (!moon.getReachable()) continue;
                        checked = true;
                        break;
                    }
                }
                if ((data = BodiesRegistry.getData().get(child)) != null && data.getTypePlanet() == IAdvancedSpace.TypeBody.STAR) {
                    GL11.glColor4f((float)0.0f, (float)0.4f, (float)(0.6f + brightness), (float)((float)scale / 95.0f));
                } else if (child instanceof Planet && checked) {
                    GL11.glColor4f((float)(0.6f + brightness), (float)0.6f, (float)0.0f, (float)((float)scale / 95.0f));
                } else {
                    GL11.glColor4f((float)(0.6f + brightness), (float)0.0f, (float)0.0f, (float)((float)scale / 95.0f));
                }
            }
            this.drawTexturedModalRect(3 + xOffset, yOffsetBase + yOffset + 1, 86, 10, 0, 489, 86, 10, false, false);
            GL11.glColor4f((float)(3.0f * brightness), (float)(0.6f + 2.0f * brightness), (float)1.0f, (float)((float)scale / 95.0f));
            this.drawTexturedModalRect(2 + xOffset, yOffsetBase + yOffset, 93, 12, 95, 464, 93, 12, false, false);
            if (scale > 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int color = 0xE0E0E0;
                GlStateManager.func_179094_E();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(child.getBodyIcon());
                this.drawTexturedModalRect(xOffset + 7, yOffsetBase + yOffset + 2, 8.0f, 8.0f, 0.0f, 0.0f, 32.0f, 32.0f, false, false, 32.0f, 32.0f);
                GlStateManager.func_179121_F();
                this.field_146289_q.func_78276_b(child.getLocalizedName(), 17 + xOffset, yOffsetBase + yOffset + 2, color);
            }
            yOffset += 14;
            if (!recursive || !child.equals((Object)this.selectedBody) || (grandchildren = this.getChildren(child, 0, this.maxBodyScroll)).size() <= 0) continue;
            if (this.animateGrandchildren == 14 * grandchildren.size()) {
                yOffset += this.drawChildren(grandchildren, 10, yOffset, false);
                continue;
            }
            if (this.animateGrandchildren >= 14) {
                LinkedList<CelestialBody> partial = new LinkedList<CelestialBody>();
                for (int j = 0; j < this.animateGrandchildren / 14; ++j) {
                    partial.add(grandchildren.get(j));
                }
                this.drawChildren(partial, 10, yOffset, false);
            }
            yOffset += this.animateGrandchildren;
            this.animateGrandchildren += 2;
        }
        if (recursive) {
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
            this.drawTexturedModalRect(BORDER_SIZE + 18, yOffsetBase + yOffset - 1, 62, 4, 280, 74, 62, 4, false, true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            this.drawTexturedModalRect(BORDER_SIZE + 47, yOffsetBase - 5, 7, 3, 344, 74, 7, 3, false, false);
            this.drawTexturedModalRect(BORDER_SIZE + 47, yOffsetBase + yOffset, 7, 3, 344, 74, 7, 3, false, true);
        }
        return yOffset;
    }

    protected int getAmountInInventory(ItemStack stack) {
        int amountInInv = 0;
        for (int x = 0; x < FMLClientHandler.instance().getClientPlayerEntity().field_71071_by.func_70302_i_(); ++x) {
            ItemStack slot = FMLClientHandler.instance().getClientPlayerEntity().field_71071_by.func_70301_a(x);
            if (slot == null || !SpaceStationRecipe.checkItemEquals((ItemStack)stack, (ItemStack)slot)) continue;
            amountInInv += slot.func_190916_E();
        }
        return amountInInv;
    }

    public int drawSplitString(String par1Str, int par2, int par3, int par4, int par5, boolean small, boolean simulate) {
        return this.renderSplitString(par1Str, par2, par3, par4, par5, small, simulate);
    }

    protected int renderSplitString(String par1Str, int par2, int par3, int par4, int par6, boolean small, boolean simulate) {
        if (small) {
            List list = this.field_146289_q.func_78271_c(par1Str, par4);
            for (String s1 : list) {
                if (!simulate) {
                    this.renderStringAligned(s1, par2, par3, par4, par6);
                }
                par3 += this.field_146289_q.field_78288_b;
            }
            return list.size();
        }
        List list = this.field_146289_q.func_78271_c(par1Str, par4);
        for (String s1 : list) {
            if (!simulate) {
                this.renderStringAligned(s1, par2, par3, par4, par6);
            }
            par3 += this.field_146289_q.field_78288_b;
        }
        return list.size();
    }

    protected void renderStringAligned(String par1Str, int par2, int par3, int par4, int par5) {
        if (this.field_146289_q.func_78260_a()) {
            int i1 = this.field_146289_q.func_78256_a(this.bidiReorder(par1Str));
            par2 = par2 + par4 - i1;
        }
        this.field_146289_q.func_175065_a(par1Str, (float)(par2 - this.field_146289_q.func_78256_a(par1Str) / 2), (float)par3, par5, false);
    }

    protected String bidiReorder(String p_147647_1_) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(p_147647_1_), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicshapingexception) {
            return p_147647_1_;
        }
    }

    public void drawTexturedModalRect(int x, int y, int width, int height, int u, int v, int uWidth, int vHeight, boolean invertX, boolean invertY) {
        this.drawTexturedModalRect(x, y, width, height, u, v, uWidth, vHeight, invertX, invertY, 512.0f, 512.0f);
    }

    public void drawTexturedModalRect(float x, float y, float width, float height, float u, float v, float uWidth, float vHeight, boolean invertX, boolean invertY, float texSizeX, float texSizeY) {
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        float texModX = 1.0f / texSizeX;
        float texModY = 1.0f / texSizeY;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float height0 = invertY ? 0.0f : vHeight;
        float height1 = invertY ? vHeight : 0.0f;
        float width0 = invertX ? uWidth : 0.0f;
        float width1 = invertX ? 0.0f : uWidth;
        worldRenderer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((u + width0) * texModX), (double)((v + height0) * texModY)).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((u + width1) * texModX), (double)((v + height0) * texModY)).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)((u + width1) * texModX), (double)((v + height1) * texModY)).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)((u + width0) * texModX), (double)((v + height1) * texModY)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void setBlackBackground() {
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(0.0, (double)this.field_146295_m, -90.0).func_181675_d();
        worldRenderer.func_181662_b((double)this.field_146294_l, (double)this.field_146295_m, -90.0).func_181675_d();
        worldRenderer.func_181662_b((double)this.field_146294_l, 0.0, -90.0).func_181675_d();
        worldRenderer.func_181662_b(0.0, 0.0, -90.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public Matrix4f setIsometric(float partialTicks) {
        float zoomLocal;
        Matrix4f mat0 = new Matrix4f();
        Matrix4f.translate((Vector3f)new Vector3f((float)this.field_146294_l / 2.0f, (float)(this.field_146295_m / 2), 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        Matrix4f.rotate((float)((float)Math.toRadians(55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        Matrix4f.rotate((float)((float)Math.toRadians(-45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        this.zoom = zoomLocal = this.getZoomAdvanced();
        Matrix4f.scale((Vector3f)new Vector3f(1.1f + zoomLocal, 1.1f + zoomLocal, 1.1f + zoomLocal), (Matrix4f)mat0, (Matrix4f)mat0);
        Vector2f cBodyPos = this.getTranslationAdvanced(partialTicks);
        this.position = this.getTranslationAdvanced(partialTicks);
        Matrix4f.translate((Vector3f)new Vector3f(-cBodyPos.x, -cBodyPos.y, 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)16);
        fb.rewind();
        mat0.store(fb);
        fb.flip();
        GL11.glMultMatrix((FloatBuffer)fb);
        return mat0;
    }

    public void drawGrid(float gridSize, float gridScale) {
        GL11.glColor4f((float)0.0f, (float)0.2f, (float)0.5f, (float)0.55f);
        GL11.glBegin((int)1);
        for (float v = -(gridSize += gridScale / 2.0f); v <= gridSize; v += gridScale) {
            GL11.glVertex3f((float)v, (float)(-gridSize), (float)-0.0f);
            GL11.glVertex3f((float)v, (float)gridSize, (float)-0.0f);
            GL11.glVertex3f((float)(-gridSize), (float)v, (float)-0.0f);
            GL11.glVertex3f((float)gridSize, (float)v, (float)-0.0f);
        }
        GL11.glEnd();
    }

    public void drawCircles() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)3.0f);
        int count = 0;
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        for (CelestialBody body : this.bodiesToRender) {
            Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
            if (body instanceof IChildBody) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((IChildBody)body).getParentPlanet());
            } else if (body instanceof Planet) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Planet)body).getParentSolarSystem().getMainStar());
            } else if (body instanceof Star) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
            } else if (body instanceof ICelestialRegistry && !(body instanceof IChildBody)) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((ICelestialRegistry)body).getParentSolarSystem().getMainStar());
            }
            float orbit_ext_x = body instanceof IExBody ? ((IExBody)body).getXOrbitEccentricity() : 1.0f;
            float orbit_ext_y = body instanceof IExBody ? ((IExBody)body).getYOrbitEccentricity() : 1.0f;
            float orbit_offset_x = body instanceof IExBody ? ((IExBody)body).getXOrbitOffset() : 0.0f;
            float orbit_offset_y = body instanceof IExBody ? ((IExBody)body).getYOrbitOffset() : 0.0f;
            float x = this.getScale(body);
            float y = 0.0f;
            float alpha = this.getAlpha(body);
            if (!(alpha > 0.0f)) continue;
            switch (count % 2) {
                case 0: {
                    GL11.glColor4f((float)0.0f, (float)0.2857143f, (float)0.64285713f, (float)(alpha / 2.4f));
                    break;
                }
                case 1: {
                    GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)(alpha / 2.4f));
                }
            }
            if (body.equals((Object)this.selectedBody)) {
                GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)1.0f);
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre(body, systemOffset);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            if (!preEvent.isCanceled()) {
                GL11.glTranslatef((float)systemOffset.x, (float)systemOffset.y, (float)systemOffset.z);
                GL11.glBegin((int)2);
                for (int i = 0; i < 90; ++i) {
                    GL11.glVertex2f((float)((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f)), (float)((y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f)));
                    float temp = x;
                    x = cos * x - sin * y;
                    y = sin * temp + cos * y;
                }
                GL11.glEnd();
                GL11.glTranslatef((float)(-systemOffset.x), (float)(-systemOffset.y), (float)(-systemOffset.z));
                ++count;
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Post postEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
        }
        GL11.glLineWidth((float)1.0f);
    }

    public float getAlpha(CelestialBody body) {
        float alpha = 1.0f;
        if (body instanceof IChildBody) {
            boolean isPossible;
            boolean selected = body == this.selectedBody || ((IChildBody)body).getParentPlanet() == this.selectedBody && this.selectionState != EnumSelection.SELECTED;
            boolean ready = this.lastSelectedBody != null || this.ticksSinceSelectionF > 35.0f;
            boolean isSibling = this.getSiblings(this.selectedBody).contains(body);
            boolean bl = isPossible = !(body instanceof Satellite) || this.possibleBodies != null && this.possibleBodies.contains(body);
            if (!selected && !isSibling || !isPossible) {
                alpha = 0.0f;
            } else if (!(!this.isZoomed() || selected && ready || isSibling)) {
                alpha = Math.min(Math.max((this.ticksSinceSelectionF - 30.0f) / 15.0f, 0.0f), 1.0f);
            }
        } else {
            boolean isOwnChildSelected;
            boolean isSelected = this.selectedBody == body;
            boolean isChildSelected = this.selectedBody instanceof IChildBody;
            boolean bl = isOwnChildSelected = isChildSelected && ((IChildBody)this.selectedBody).getParentPlanet() == body;
            if (!isSelected && !isOwnChildSelected && (this.isZoomed() || isChildSelected)) {
                alpha = this.lastSelectedBody != null || this.selectedBody instanceof IChildBody ? 0.0f : 1.0f - Math.min(this.ticksSinceSelectionF / 25.0f, 1.0f);
            }
        }
        return alpha;
    }

    protected boolean isZoomed() {
        return this.selectionState == EnumSelection.ZOOMED;
    }

    protected boolean isSelected() {
        return this.selectionState != EnumSelection.UNSELECTED;
    }

    protected Matrix4f setupMatrix(CelestialBody body, Matrix4f worldMatrix, FloatBuffer fb) {
        return this.setupMatrix(body, worldMatrix, fb, 1.0f);
    }

    protected Matrix4f setupMatrix(CelestialBody body, Matrix4f worldMatrix, FloatBuffer fb, float scaleXZ) {
        Matrix4f worldMatrix0 = new Matrix4f(worldMatrix);
        Matrix4f.translate((Vector3f)this.getCelestialBodyPosition(body), (Matrix4f)worldMatrix0, (Matrix4f)worldMatrix0);
        Matrix4f worldMatrix1 = new Matrix4f();
        Matrix4f.rotate((float)((float)Math.toRadians(45.0)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        Matrix4f.rotate((float)((float)Math.toRadians(-55.0)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        if (scaleXZ != 1.0f) {
            Matrix4f.scale((Vector3f)new Vector3f(scaleXZ, scaleXZ, 1.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        }
        worldMatrix1 = Matrix4f.mul((Matrix4f)worldMatrix0, (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        fb.rewind();
        worldMatrix1.store(fb);
        fb.flip();
        GL11.glMultMatrix((FloatBuffer)fb);
        return worldMatrix1;
    }

    public static class StationDataGUI {
        private String stationName;
        private Integer stationDimensionID;

        public StationDataGUI(String stationName, Integer stationDimensionID) {
            this.stationName = stationName;
            this.stationDimensionID = stationDimensionID;
        }

        public String getStationName() {
            return this.stationName;
        }

        public void setStationName(String stationName) {
            this.stationName = stationName;
        }

        public Integer getStationDimensionID() {
            return this.stationDimensionID;
        }
    }

    protected static enum EnumSelection {
        UNSELECTED,
        SELECTED,
        ZOOMED;

    }

    protected static enum EnumView {
        PREVIEW,
        PROFILE,
        ASMODEUS;

    }
}

