/*
 * Decompiled with CFR 0.152.
 */
package shadows.spawn;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.spawn.SpawnerModifiers;
import shadows.spawn.SpawnerModule;
import shadows.spawn.TileSpawnerExt;
import shadows.spawn.modifiers.SpawnerModifier;

public class BlockSpawnerExt
extends BlockMobSpawner {
    public BlockSpawnerExt() {
        this.setRegistryName("minecraft", "mob_spawner");
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("mobSpawner");
        this.func_149649_H();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack s = new ItemStack((Block)this);
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            te.func_189515_b(s.func_190925_c("spawner"));
        }
        return s;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            te.func_145839_a(stack.func_190925_c("spawner"));
            te.func_174878_a(pos);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (SpawnerModule.spawnerSilkLevel != -1 && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) >= SpawnerModule.spawnerSilkLevel) {
            ItemStack s = new ItemStack((Block)this);
            if (te != null) {
                te.func_189515_b(s.func_190925_c("spawner"));
            }
            BlockSpawnerExt.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s);
            player.func_184614_ca().func_77972_a(35, (EntityLivingBase)player);
        }
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        if (player.field_71075_bZ.field_75098_d) {
            return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        }
        return willHarvest;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSpawnerExt();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileSpawnerExt) {
            TileSpawnerExt tile = (TileSpawnerExt)te;
            boolean inverse = SpawnerModifiers.inverseItem.apply(player.func_184586_b(hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND));
            for (SpawnerModifier sm : SpawnerModifiers.MODIFIERS) {
                if (!sm.canModify(tile, stack, inverse) || !sm.modify(tile, stack, inverse)) continue;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("spawner", 10)) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("spawner");
            if (tag.func_74764_b("SpawnData")) {
                tooltip.add(I18n.func_135052_a((String)"info.spw.entity", (Object[])new Object[]{EntityList.func_191302_a((ResourceLocation)new ResourceLocation(tag.func_74775_l("SpawnData").func_74779_i("id")))}));
            }
            if (tag.func_74764_b("MinSpawnDelay")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.mindelay", (Object[])new Object[]{tag.func_74765_d("MinSpawnDelay")}));
            }
            if (tag.func_74764_b("MaxSpawnDelay")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.maxdelay", (Object[])new Object[]{tag.func_74765_d("MaxSpawnDelay")}));
            }
            if (tag.func_74764_b("SpawnCount")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.spawncount", (Object[])new Object[]{tag.func_74765_d("SpawnCount")}));
            }
            if (tag.func_74764_b("MaxNearbyEntities")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.maxnearby", (Object[])new Object[]{tag.func_74765_d("MaxNearbyEntities")}));
            }
            if (tag.func_74764_b("RequiredPlayerRange")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.playerrange", (Object[])new Object[]{tag.func_74765_d("RequiredPlayerRange")}));
            }
            if (tag.func_74764_b("SpawnRange")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.spawnrange", (Object[])new Object[]{tag.func_74765_d("SpawnRange")}));
            }
            if (tag.func_74767_n("ignore_players")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.ignoreplayers", (Object[])new Object[0]));
            }
            if (tag.func_74767_n("ignore_conditions")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.ignoreconditions", (Object[])new Object[0]));
            }
            if (tag.func_74767_n("ignore_cap")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.ignorecap", (Object[])new Object[0]));
            }
            if (tag.func_74767_n("redstone_control")) {
                tooltip.add(I18n.func_135052_a((String)"waila.spw.redstone", (Object[])new Object[0]));
            }
        }
    }
}

