/*
 * Decompiled with CFR 0.152.
 */
package shadows.potion;

import java.io.File;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.Apotheosis;
import shadows.ApotheosisObjects;
import shadows.potion.EnchantmentTrueInfinity;
import shadows.potion.ItemLuckyFoot;
import shadows.potion.potions.PotionKnowledge;
import shadows.potion.potions.PotionSundering;

public class PotionModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Potion");
    public static final ResourceLocation POTION_TEX = new ResourceLocation("apotheosis", "textures/potions.png");
    static Configuration config;
    static int knowledgeMult;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisPreInit e) {
        config = new Configuration(new File(Apotheosis.configDir, "potion.cfg"));
        knowledgeMult = config.getInt("Knowledge XP Multiplier", "general", knowledgeMult, 1, Integer.MAX_VALUE, "The strength of Ancient Knowledge.  This multiplier determines how much additional xp is granted.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void init(Apotheosis.ApotheosisInit e) {
        PotionHelper.func_193357_a((PotionType)PotionTypes.field_185233_e, (Item)Items.field_190930_cZ, (PotionType)ApotheosisObjects.RESISTANCE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.RESISTANCE, (Item)Items.field_151137_ax, (PotionType)ApotheosisObjects.LONG_RESISTANCE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.RESISTANCE, (Item)Items.field_151114_aO, (PotionType)ApotheosisObjects.STRONG_RESISTANCE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.RESISTANCE, (Item)Items.field_151071_bq, (PotionType)ApotheosisObjects.T_SUNDERING);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.LONG_RESISTANCE, (Item)Items.field_151071_bq, (PotionType)ApotheosisObjects.LONG_SUNDERING);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.STRONG_RESISTANCE, (Item)Items.field_151071_bq, (PotionType)ApotheosisObjects.STRONG_SUNDERING);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.T_SUNDERING, (Item)Items.field_151137_ax, (PotionType)ApotheosisObjects.LONG_SUNDERING);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.T_SUNDERING, (Item)Items.field_151114_aO, (PotionType)ApotheosisObjects.STRONG_SUNDERING);
        PotionHelper.func_193357_a((PotionType)PotionTypes.field_185233_e, (Item)Items.field_151153_ao, (PotionType)ApotheosisObjects.ABSORPTION);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.ABSORPTION, (Item)Items.field_151137_ax, (PotionType)ApotheosisObjects.LONG_ABSORPTION);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.ABSORPTION, (Item)Items.field_151114_aO, (PotionType)ApotheosisObjects.STRONG_ABSORPTION);
        PotionHelper.func_193357_a((PotionType)PotionTypes.field_185233_e, (Item)Items.field_151009_A, (PotionType)ApotheosisObjects.HASTE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.HASTE, (Item)Items.field_151137_ax, (PotionType)ApotheosisObjects.LONG_HASTE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.HASTE, (Item)Items.field_151114_aO, (PotionType)ApotheosisObjects.STRONG_HASTE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.HASTE, (Item)Items.field_151071_bq, (PotionType)ApotheosisObjects.FATIGUE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.LONG_HASTE, (Item)Items.field_151071_bq, (PotionType)ApotheosisObjects.LONG_FATIGUE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.STRONG_HASTE, (Item)Items.field_151071_bq, (PotionType)ApotheosisObjects.STRONG_FATIGUE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.FATIGUE, (Item)Items.field_151137_ax, (PotionType)ApotheosisObjects.LONG_FATIGUE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.FATIGUE, (Item)Items.field_151114_aO, (PotionType)ApotheosisObjects.STRONG_FATIGUE);
        if (ApotheosisObjects.SKULL_FRAGMENT != null) {
            PotionHelper.func_193357_a((PotionType)PotionTypes.field_185233_e, (Item)ApotheosisObjects.SKULL_FRAGMENT, (PotionType)ApotheosisObjects.WITHER);
        } else {
            PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151144_bL, 1, 1)}), (PotionType)ApotheosisObjects.WITHER);
        }
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.WITHER, (Item)Items.field_151137_ax, (PotionType)ApotheosisObjects.LONG_WITHER);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.WITHER, (Item)Items.field_151114_aO, (PotionType)ApotheosisObjects.STRONG_WITHER);
        PotionHelper.func_193357_a((PotionType)PotionTypes.field_185233_e, (Item)Items.field_151062_by, (PotionType)ApotheosisObjects.T_KNOWLEDGE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.T_KNOWLEDGE, (Item)Items.field_151137_ax, (PotionType)ApotheosisObjects.LONG_KNOWLEDGE);
        PotionHelper.func_193357_a((PotionType)ApotheosisObjects.T_KNOWLEDGE, (Item)Items.field_151062_by, (PotionType)ApotheosisObjects.STRONG_KNOWLEDGE);
        PotionHelper.func_193357_a((PotionType)PotionTypes.field_185233_e, (Item)ApotheosisObjects.LUCKY_FOOT, (PotionType)((PotionType)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation("luck"))));
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().register(new EnchantmentTrueInfinity().setRegistryName("apotheosis", "true_infinity"));
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new ItemLuckyFoot().setRegistryName("apotheosis", "lucky_foot"));
    }

    @SubscribeEvent
    public void recipes(Apotheosis.ApotheosisRecipeEvent e) {
        Ingredient fireRes = Apotheosis.potionIngredient(PotionTypes.field_185241_m);
        Ingredient abs = Apotheosis.potionIngredient(ApotheosisObjects.STRONG_ABSORPTION);
        Ingredient res = Apotheosis.potionIngredient(ApotheosisObjects.RESISTANCE);
        Ingredient regen = Apotheosis.potionIngredient(PotionTypes.field_185222_E);
        e.helper.addShaped(new ItemStack(Items.field_151153_ao, 1, 1), 3, 3, new Object[]{fireRes, regen, fireRes, abs, Items.field_151153_ao, abs, res, abs, res});
    }

    @SubscribeEvent
    public void types(RegistryEvent.Register<PotionType> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new PotionType[]{(PotionType)new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, 3600)}).setRegistryName("apotheosis", "resistance"), (PotionType)new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, 9600)}).setRegistryName("apotheosis", "long_resistance"), (PotionType)new PotionType("resistance", new PotionEffect[]{new PotionEffect(MobEffects.field_76429_m, 1800, 1)}).setRegistryName("apotheosis", "strong_resistance"), (PotionType)new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, 1200, 1)}).setRegistryName("apotheosis", "absorption"), (PotionType)new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, 3600, 1)}).setRegistryName("apotheosis", "long_absorption"), (PotionType)new PotionType("absorption", new PotionEffect[]{new PotionEffect(MobEffects.field_76444_x, 600, 3)}).setRegistryName("apotheosis", "strong_absorption"), (PotionType)new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, 3600)}).setRegistryName("apotheosis", "haste"), (PotionType)new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, 9600)}).setRegistryName("apotheosis", "long_haste"), (PotionType)new PotionType("haste", new PotionEffect[]{new PotionEffect(MobEffects.field_76422_e, 1800, 1)}).setRegistryName("apotheosis", "strong_haste"), (PotionType)new PotionType("fatigue", new PotionEffect[]{new PotionEffect(MobEffects.field_76419_f, 3600)}).setRegistryName("apotheosis", "fatigue"), (PotionType)new PotionType("fatigue", new PotionEffect[]{new PotionEffect(MobEffects.field_76419_f, 9600)}).setRegistryName("apotheosis", "long_fatigue"), (PotionType)new PotionType("fatigue", new PotionEffect[]{new PotionEffect(MobEffects.field_76419_f, 1800, 1)}).setRegistryName("apotheosis", "strong_fatigue"), (PotionType)new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 3600)}).setRegistryName("apotheosis", "wither"), (PotionType)new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 9600)}).setRegistryName("apotheosis", "long_wither"), (PotionType)new PotionType("wither", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 1800, 1)}).setRegistryName("apotheosis", "strong_wither"), (PotionType)new PotionType("sundering", new PotionEffect[]{new PotionEffect((Potion)ApotheosisObjects.SUNDERING, 3600)}).setRegistryName("apotheosis", "sundering"), (PotionType)new PotionType("sundering", new PotionEffect[]{new PotionEffect((Potion)ApotheosisObjects.SUNDERING, 9600)}).setRegistryName("apotheosis", "long_sundering"), (PotionType)new PotionType("sundering", new PotionEffect[]{new PotionEffect((Potion)ApotheosisObjects.SUNDERING, 1800, 1)}).setRegistryName("apotheosis", "strong_sundering"), (PotionType)new PotionType("knowledge", new PotionEffect[]{new PotionEffect((Potion)ApotheosisObjects.P_KNOWLEDGE, 2400)}).setRegistryName("apotheosis", "knowledge"), (PotionType)new PotionType("knowledge", new PotionEffect[]{new PotionEffect((Potion)ApotheosisObjects.P_KNOWLEDGE, 4800)}).setRegistryName("apotheosis", "long_knowledge"), (PotionType)new PotionType("knowledge", new PotionEffect[]{new PotionEffect((Potion)ApotheosisObjects.P_KNOWLEDGE, 1200, 1)}).setRegistryName("apotheosis", "strong_knowledge")});
    }

    @SubscribeEvent
    public void potions(RegistryEvent.Register<Potion> e) {
        e.getRegistry().register(new PotionSundering().setRegistryName("apotheosis", "sundering"));
        e.getRegistry().register(new PotionKnowledge().setRegistryName("apotheosis", "knowledge"));
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
    }

    @SubscribeEvent
    public void drops(LivingDropsEvent e) {
        if (e.getEntityLiving() instanceof EntityRabbit) {
            EntityRabbit rabbit = (EntityRabbit)e.getEntityLiving();
            if (rabbit.field_70170_p.field_73012_v.nextFloat() < 0.02f) {
                e.getDrops().clear();
                e.getDrops().add(new EntityItem(rabbit.field_70170_p, rabbit.field_70165_t, rabbit.field_70163_u, rabbit.field_70161_v, new ItemStack((Item)ApotheosisObjects.LUCKY_FOOT)));
            }
        }
    }

    @SubscribeEvent
    public void xp(LivingExperienceDropEvent e) {
        if (e.getAttackingPlayer() != null && e.getAttackingPlayer().func_70660_b((Potion)ApotheosisObjects.P_KNOWLEDGE) != null) {
            int level = e.getAttackingPlayer().func_70660_b((Potion)ApotheosisObjects.P_KNOWLEDGE).func_76458_c() + 1;
            int curXp = e.getDroppedExperience();
            int newXp = curXp + e.getOriginalExperience() * level * knowledgeMult;
            e.setDroppedExperience(newXp);
        }
    }

    static {
        knowledgeMult = 10;
    }
}

