/*
 * Decompiled with CFR 0.152.
 */
package shadows.ench;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.Apotheosis;
import shadows.ApotheosisObjects;
import shadows.ench.ContainerEnchantmentExt;
import shadows.ench.EnchantmentInfo;
import shadows.ench.altar.BlockPrismaticAltar;
import shadows.ench.altar.TilePrismaticAltar;
import shadows.ench.anvil.BlockAnvilExt;
import shadows.ench.anvil.EnchantmentSplitting;
import shadows.ench.anvil.ItemAnvilExt;
import shadows.ench.anvil.TileAnvil;
import shadows.ench.compat.keeplapis.KeepLapisEventHandler;
import shadows.ench.enchantments.EnchantmentBerserk;
import shadows.ench.enchantments.EnchantmentDepths;
import shadows.ench.enchantments.EnchantmentHellInfused;
import shadows.ench.enchantments.EnchantmentIcyThorns;
import shadows.ench.enchantments.EnchantmentKnowledge;
import shadows.ench.enchantments.EnchantmentLifeMend;
import shadows.ench.enchantments.EnchantmentMagicProt;
import shadows.ench.enchantments.EnchantmentMounted;
import shadows.ench.enchantments.EnchantmentNatureBless;
import shadows.ench.enchantments.EnchantmentRebounding;
import shadows.ench.enchantments.EnchantmentReflective;
import shadows.ench.enchantments.EnchantmentScavenger;
import shadows.ench.enchantments.EnchantmentShieldBash;
import shadows.ench.enchantments.EnchantmentStableFooting;
import shadows.ench.enchantments.EnchantmentTempting;
import shadows.ench.objects.BlockHellBookshelf;
import shadows.ench.objects.ItemHellBookshelf;
import shadows.ench.objects.ItemScrapTome;
import shadows.ench.objects.ItemShearsExt;
import shadows.ench.objects.ItemTypedBook;
import shadows.placebo.itemblock.ItemBlockBase;
import shadows.placebo.util.PlaceboUtil;
import shadows.util.NBTIngredient;

public class EnchModule {
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final List<ItemTypedBook> TYPED_BOOKS = new LinkedList<ItemTypedBook>();
    public static final List<Enchantment> BLACKLISTED_ENCHANTS = new ArrayList<Enchantment>();
    public static final DamageSource CORRUPTED = new DamageSource("corrupted"){

        public ITextComponent func_151519_b(EntityLivingBase entity) {
            return new TextComponentTranslation("death.apotheosis.corrupted", new Object[]{entity.func_145748_c_()});
        }
    }.func_76348_h().func_151518_m();
    public static final EntityEquipmentSlot[] ARMOR = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    static Configuration enchInfoConfig;
    public static OreIngredient blockIron;
    public static int absMax;
    public static boolean allowWeb;
    public static float maxNormalPower;
    public static float maxPower;
    public static boolean itemMerging;
    Method dropLoot;
    final EntityEquipmentSlot[] slots = EntityEquipmentSlot.values();

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void init(Apotheosis.ApotheosisInit e) {
        void var6_12;
        Configuration config = new Configuration(new File(Apotheosis.configDir, "enchantability.cfg"));
        EnchModule.setEnch(Item.ToolMaterial.GOLD, 40);
        EnchModule.setEnch(ItemArmor.ArmorMaterial.GOLD, 40);
        for (ItemArmor.ArmorMaterial armorMaterial : ItemArmor.ArmorMaterial.values()) {
            EnchModule.setEnch(armorMaterial, config.getInt(armorMaterial.name(), "Enchantability - Armor", armorMaterial.func_78045_a(), 0, Integer.MAX_VALUE, "The enchantability of this armor material."));
        }
        for (ItemArmor.ArmorMaterial armorMaterial : Item.ToolMaterial.values()) {
            EnchModule.setEnch((Item.ToolMaterial)armorMaterial, config.getInt(armorMaterial.name(), "Enchantability - Tools", armorMaterial.func_77995_e(), 0, Integer.MAX_VALUE, "The enchantability of this tool material."));
        }
        if (config.hasChanged()) {
            config.save();
        }
        config = new Configuration(new File(Apotheosis.configDir, "enchantment_module.cfg"));
        String[] blacklist = config.getStringList("Enchantment Blacklist", "general", new String[0], "A list of enchantments that are banned from the enchanting table and other natural sources.");
        String[] stringArray = blacklist;
        int n = stringArray.length;
        boolean bl = false;
        while (var6_12 < n) {
            String s = stringArray[var6_12];
            Enchantment ex = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ex == null) {
                LOGGER.error("Invalid enchantment blacklist entry {} will be ignored!", (Object)ex);
            } else {
                BLACKLISTED_ENCHANTS.add(ex);
            }
            ++var6_12;
        }
        allowWeb = config.getBoolean("Enable Cobwebs", "general", allowWeb, "If cobwebs can be used in anvils to remove enchantments.");
        maxNormalPower = config.getFloat("Max Normal Power", "general", maxNormalPower, 0.0f, Float.MAX_VALUE, "The maximum enchantment power a table can receive from normal sources.");
        maxPower = config.getFloat("Max Power", "general", maxPower, 0.0f, Float.MAX_VALUE, "The maximum enchantment power a table can receive.");
        itemMerging = config.getBoolean("Item Merging", "general", false, "If any two enchanted items can be combined in an Anvil.");
        if (config.hasChanged()) {
            config.save();
        }
        EnchModule.recalcAbsMax();
        config = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            String minF;
            int n2 = config.getInt("Max Level", ench.getRegistryName().toString(), EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment.");
            int min = config.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (min > n2) {
                min = n2;
            }
            EnchantmentInfo info = new EnchantmentInfo(ench, n2, min);
            String maxF = config.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = config.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
        }
        if (config.hasChanged()) {
            config.save();
        }
        enchInfoConfig = config;
        blockIron = new OreIngredient("blockIron");
        if (Loader.isModLoaded((String)"csb_ench_table")) {
            MinecraftForge.EVENT_BUS.register(KeepLapisEventHandler.class);
        }
    }

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisPreInit e) {
        GameRegistry.registerTileEntity(TileAnvil.class, (ResourceLocation)new ResourceLocation("apotheosis", "anvil"));
        GameRegistry.registerTileEntity(TilePrismaticAltar.class, (ResourceLocation)new ResourceLocation("apotheosis", "prismatic_altar"));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{new BlockHellBookshelf(new ResourceLocation("apotheosis", "hellshelf")), (Block)new BlockAnvilExt().setRegistryName("minecraft", "anvil"), new BlockPrismaticAltar()});
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{((Item)new ItemShearsExt().setRegistryName(Items.field_151097_aZ.getRegistryName())).func_77655_b("shears"), (Item)new ItemHellBookshelf(ApotheosisObjects.HELLSHELF).setRegistryName(ApotheosisObjects.HELLSHELF.getRegistryName()), ((Item)new Item().setRegistryName("apotheosis", "prismatic_web")).func_77655_b("apotheosis.prismatic_web"), new ItemAnvilExt(Blocks.field_150467_bQ), new ItemTypedBook(Items.field_190931_a, null), new ItemTypedBook((Item)Items.field_151161_ac, EnumEnchantmentType.ARMOR_HEAD), new ItemTypedBook((Item)Items.field_151163_ad, EnumEnchantmentType.ARMOR_CHEST), new ItemTypedBook((Item)Items.field_151173_ae, EnumEnchantmentType.ARMOR_LEGS), new ItemTypedBook((Item)Items.field_151175_af, EnumEnchantmentType.ARMOR_FEET), new ItemTypedBook(Items.field_151048_u, EnumEnchantmentType.WEAPON), new ItemTypedBook(Items.field_151046_w, EnumEnchantmentType.DIGGER), new ItemTypedBook((Item)Items.field_151112_aM, EnumEnchantmentType.FISHING_ROD), new ItemTypedBook((Item)Items.field_151031_f, EnumEnchantmentType.BOW), new ItemBlockBase((Block)ApotheosisObjects.PRISMATIC_ALTAR), new ItemScrapTome()});
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{(Enchantment)new EnchantmentHellInfused().setRegistryName("apotheosis", "hell_infusion"), (Enchantment)new EnchantmentMounted().setRegistryName("apotheosis", "mounted_strike"), (Enchantment)new EnchantmentDepths().setRegistryName("apotheosis", "depth_miner"), (Enchantment)new EnchantmentStableFooting().setRegistryName("apotheosis", "stable_footing"), (Enchantment)new EnchantmentScavenger().setRegistryName("apotheosis", "scavenger"), (Enchantment)new EnchantmentLifeMend().setRegistryName("apotheosis", "life_mending"), (Enchantment)new EnchantmentIcyThorns().setRegistryName("apotheosis", "icy_thorns"), (Enchantment)new EnchantmentTempting().setRegistryName("apotheosis", "tempting"), (Enchantment)new EnchantmentShieldBash().setRegistryName("apotheosis", "shield_bash"), (Enchantment)new EnchantmentReflective().setRegistryName("apotheosis", "reflective"), (Enchantment)new EnchantmentBerserk().setRegistryName("apotheosis", "berserk"), (Enchantment)new EnchantmentKnowledge().setRegistryName("apotheosis", "knowledge"), (Enchantment)new EnchantmentSplitting().setRegistryName("apotheosis", "splitting"), (Enchantment)new EnchantmentNatureBless().setRegistryName("apotheosis", "natures_blessing"), (Enchantment)new EnchantmentRebounding().setRegistryName("apotheosis", "rebounding"), (Enchantment)new EnchantmentMagicProt().setRegistryName("apotheosis", "magic_protection")});
    }

    @SubscribeEvent
    public void sounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().register(new SoundEvent(new ResourceLocation("apotheosis", "altar")).setRegistryName("apotheosis", "altar_sound"));
    }

    @SubscribeEvent
    public void models(ModelRegistryEvent e) {
        PlaceboUtil.sMRL((Block)ApotheosisObjects.HELLSHELF, (int)0, (String)"normal");
    }

    @SubscribeEvent
    public void recipes(Apotheosis.ApotheosisRecipeEvent e) {
        NBTIngredient pot = new NBTIngredient(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185220_C));
        e.helper.addShaped((IForgeRegistryEntry)ApotheosisObjects.HELLSHELF, 3, 3, new Object[]{Blocks.field_150385_bj, Blocks.field_150385_bj, Blocks.field_150385_bj, Items.field_151072_bj, Blocks.field_150342_X, pot, Blocks.field_150385_bj, Blocks.field_150385_bj, Blocks.field_150385_bj});
        e.helper.addShaped((IForgeRegistryEntry)ApotheosisObjects.PRISMATIC_WEB, 3, 3, new Object[]{null, Items.field_179562_cC, null, Items.field_179562_cC, Blocks.field_150321_G, Items.field_179562_cC, null, Items.field_179562_cC, null});
        ItemStack book = new ItemStack(Items.field_151122_aG);
        ItemStack stick = new ItemStack(Items.field_151055_y);
        ItemStack blaze = new ItemStack(Items.field_151072_bj);
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.ARMOR_HEAD_BOOK, 5), 3, 2, new Object[]{book, book, book, book, blaze, book});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.ARMOR_CHEST_BOOK, 8), 3, 3, new Object[]{book, blaze, book, book, book, book, book, book, book});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.ARMOR_LEGS_BOOK, 7), 3, 3, new Object[]{book, null, book, book, blaze, book, book, book, book});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.ARMOR_FEET_BOOK, 4), 3, 2, new Object[]{book, null, book, book, blaze, book});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.WEAPON_BOOK, 2), 1, 3, new Object[]{book, book, blaze});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.DIGGER_BOOK, 3), 3, 3, new Object[]{book, book, book, null, blaze, null, null, stick, null});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.FISHING_ROD_BOOK, 2), 3, 3, new Object[]{null, null, blaze, null, stick, book, stick, null, book});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.BOW_BOOK, 3), 3, 3, new Object[]{null, stick, book, blaze, null, book, null, stick, book});
        e.helper.addShapeless(new ItemStack((Item)ApotheosisObjects.NULL_BOOK, 4), new Object[]{book, book, book, book, blaze});
        ItemStack msBrick = new ItemStack(Blocks.field_150417_aV, 1, 1);
        e.helper.addShaped((IForgeRegistryEntry)ApotheosisObjects.PRISMATIC_ALTAR, 3, 3, new Object[]{msBrick, null, msBrick, msBrick, Blocks.field_180398_cJ, msBrick, msBrick, Blocks.field_150381_bn, msBrick});
        e.helper.addShaped(new ItemStack(Items.field_151062_by, 16), 3, 3, new Object[]{Items.field_151061_bv, Items.field_151074_bl, Items.field_151061_bv, Items.field_151065_br, Items.field_185157_bK, Items.field_151065_br, Items.field_151114_aO, Items.field_151114_aO, Items.field_151114_aO});
        e.helper.addShaped(new ItemStack(Items.field_151062_by, 1), 3, 3, new Object[]{Items.field_151061_bv, Blocks.field_150340_R, Items.field_151061_bv, Items.field_151072_bj, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b), Items.field_151072_bj, Blocks.field_150426_aN, Blocks.field_150426_aN, Blocks.field_150426_aN});
        e.helper.addShaped(new ItemStack((Item)ApotheosisObjects.SCRAP_TOME, 8), 3, 3, new Object[]{book, book, book, book, Blocks.field_150467_bQ, book, book, book, book});
    }

    @SubscribeEvent
    public void anvilEvent(AnvilUpdateEvent e) {
        if (!EnchantmentHelper.func_82781_a((ItemStack)e.getLeft()).isEmpty()) {
            if (allowWeb && e.getRight().func_77973_b() == ApotheosisObjects.WEB) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> ((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(ent -> (Enchantment)ent.getKey(), ent -> (Integer)ent.getValue())), (ItemStack)stack);
                e.setCost(1);
                e.setMaterialCost(1);
                e.setOutput(stack);
            } else if (e.getRight().func_77973_b() == ApotheosisObjects.PRISMATIC_WEB) {
                ItemStack stack = e.getLeft().func_77946_l();
                EnchantmentHelper.func_82782_a(EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(ent -> !((Enchantment)ent.getKey()).func_190936_d()).collect(Collectors.toMap(ent -> (Enchantment)ent.getKey(), ent -> (Integer)ent.getValue())), (ItemStack)stack);
                e.setCost(30);
                e.setMaterialCost(1);
                e.setOutput(stack);
                return;
            }
        }
        if (e.getLeft().func_77973_b() == ApotheosisObjects.ANVIL && blockIron.apply(e.getRight())) {
            int dmg = e.getLeft().func_77960_j();
            if (dmg == 0 || e.getLeft().func_190916_E() != 1) {
                return;
            }
            ItemStack out = e.getLeft().func_77946_l();
            out.func_77964_b(dmg - 1);
            out.func_190920_e(1);
            e.setOutput(out);
            e.setCost(5 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)e.getLeft()) * 2 + EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SPLITTING, (ItemStack)e.getLeft()) * 3);
            e.setMaterialCost(1);
            return;
        }
        if (ItemTypedBook.updateAnvil(e)) {
            return;
        }
        if (ItemScrapTome.updateAnvil(e)) {
            return;
        }
        if (itemMerging && this.mergeAll(e)) {
            return;
        }
    }

    private boolean mergeAll(AnvilUpdateEvent ev) {
        ItemStack right = ev.getRight();
        ItemStack left = ev.getLeft();
        if (!right.func_77948_v() || !left.func_77973_b().func_77616_k(left)) {
            return false;
        }
        Map rightEnch = EnchantmentHelper.func_82781_a((ItemStack)right);
        Map leftEnch = EnchantmentHelper.func_82781_a((ItemStack)left);
        int cost = 0;
        for (Enchantment ench : rightEnch.keySet()) {
            int curLevel;
            if (ench == null) continue;
            int level = (Integer)rightEnch.get(ench);
            int n = curLevel = leftEnch.containsKey(ench) ? (Integer)leftEnch.get(ench) : 0;
            if (level > 0 && level == curLevel) {
                level = Math.min(EnchModule.getEnchInfo(ench).getMaxLevel(), level + 1);
            }
            if (curLevel > level) {
                level = curLevel;
            }
            if (!ench.func_92089_a(left)) continue;
            boolean isCompat = true;
            for (Enchantment ench2 : leftEnch.keySet()) {
                if (ench == ench2 || ench.func_191560_c(ench2)) continue;
                isCompat = false;
            }
            if (!isCompat) {
                return false;
            }
            leftEnch.put(ench, level);
            int addition = 0;
            switch (ench.func_77324_c()) {
                case COMMON: {
                    addition += 2 * level;
                    break;
                }
                case UNCOMMON: {
                    addition += 4 * level;
                    break;
                }
                case RARE: {
                    addition += 6 * level;
                    break;
                }
                case VERY_RARE: {
                    addition += 12 * level;
                }
            }
            cost += Math.max(1, addition / 2);
        }
        if (cost > 0) {
            ItemStack out = left.func_77946_l();
            out.func_82841_c(left.func_82838_A() * 2 + 1);
            EnchantmentHelper.func_82782_a((Map)leftEnch, (ItemStack)out);
            ev.setMaterialCost(1);
            ev.setCost(cost += left.func_82838_A());
            ev.setOutput(out);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) throws Exception {
        Entity attacker = e.getSource().func_76346_g();
        if (attacker instanceof EntityPlayer) {
            int knowledge;
            EntityPlayer p = (EntityPlayer)attacker;
            if (p.field_70170_p.field_72995_K) {
                return;
            }
            int scavenger = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.SCAVENGER, (ItemStack)p.func_184614_ca());
            if (scavenger > 0 && (float)p.field_70170_p.field_73012_v.nextInt(100) < (float)scavenger * 2.5f) {
                if (this.dropLoot == null) {
                    this.dropLoot = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"dropLoot", (String)"func_184610_a", (Class[])new Class[]{Boolean.TYPE, Integer.TYPE, DamageSource.class});
                }
                this.dropLoot.invoke((Object)e.getEntityLiving(), true, e.getLootingLevel(), e.getSource());
            }
            if ((knowledge = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.KNOWLEDGE, (ItemStack)p.func_184614_ca())) > 0 && !(e.getEntityLiving() instanceof EntityPlayer)) {
                int items = 0;
                for (EntityItem i : e.getDrops()) {
                    items += i.func_92059_d().func_190916_E();
                }
                if (items > 0) {
                    e.getDrops().clear();
                }
                items *= knowledge * 25;
                EntityLivingBase ded = e.getEntityLiving();
                while (items > 0) {
                    int i = EntityXPOrb.func_70527_a((int)items);
                    items -= i;
                    p.field_70170_p.func_72838_d((Entity)new EntityXPOrb(p.field_70170_p, ded.field_70165_t, ded.field_70163_u, ded.field_70161_v, i));
                }
            }
        }
    }

    @SubscribeEvent
    public void lifeMend(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        for (EntityEquipmentSlot slot : this.slots) {
            int level;
            ItemStack stack = e.getEntityLiving().func_184582_a(slot);
            if (stack.func_190926_b() || !stack.func_77951_h() || (level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.LIFE_MENDING, (ItemStack)stack)) <= 0 || e.getEntityLiving().field_70170_p.field_73012_v.nextInt(10) != 0) continue;
            int i = Math.min(level, stack.func_77952_i());
            e.getEntityLiving().func_70097_a(CORRUPTED, (float)i * 0.7f);
            stack.func_77964_b(stack.func_77952_i() - i);
            return;
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed e) {
        ItemStack stack;
        EntityPlayer p = e.getEntityPlayer();
        if (!p.field_70122_E && EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.STABLE_FOOTING, (EntityLivingBase)p) > 0 && e.getOriginalSpeed() < e.getNewSpeed() * 5.0f) {
            e.setNewSpeed(e.getNewSpeed() * 5.0f);
        }
        if ((stack = p.func_184614_ca()).func_190926_b()) {
            return;
        }
        int depth = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.DEPTH_MINER, (ItemStack)stack);
        if (depth > 0) {
            float effectiveness = ((float)p.field_70170_p.func_181545_F() - (float)p.field_70163_u) / (float)p.field_70170_p.func_181545_F();
            if (effectiveness < 0.0f) {
                effectiveness /= 3.0f;
            }
            float speedChange = 1.0f + (float)(depth * depth) * effectiveness;
            e.setNewSpeed(e.getNewSpeed() + speedChange);
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock e) {
        ItemStack s = e.getItemStack();
        int nbLevel = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.NATURES_BLESSING, (ItemStack)s);
        if (!e.getEntityPlayer().func_70093_af() && nbLevel > 0 && ItemDye.applyBonemeal((ItemStack)s.func_77946_l(), (World)e.getWorld(), (BlockPos)e.getPos(), (EntityPlayer)e.getEntityPlayer(), (EnumHand)e.getHand())) {
            s.func_77972_a(6 - nbLevel, (EntityLivingBase)e.getEntityPlayer());
            e.setCanceled(true);
            e.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void applyUnbreaking(AnvilRepairEvent e) {
        if (e.getEntityPlayer().field_71070_bA instanceof ContainerRepair) {
            ContainerRepair r = (ContainerRepair)e.getEntityPlayer().field_71070_bA;
            TileEntity te = r.field_82860_h.func_175625_s(r.field_178156_j);
            if (te instanceof TileAnvil) {
                e.setBreakChance(e.getBreakChance() / (float)(((TileAnvil)te).getUnbreaking() + 1));
            }
        }
    }

    @SubscribeEvent
    public void enchLevel(EnchantmentLevelSetEvent e) {
        int power = e.getPower();
        e.setLevel(MathHelper.func_76141_d((float)((float)power * (1.0f + (float)e.getEnchantRow() * 0.5f))));
    }

    @SubscribeEvent
    public void enchContainer(PlayerContainerEvent.Open e) {
        if (!e.getEntityPlayer().field_70170_p.field_72995_K && e.getContainer().getClass() == ContainerEnchantment.class) {
            ContainerEnchantment old = (ContainerEnchantment)e.getContainer();
            ContainerEnchantmentExt newC = new ContainerEnchantmentExt(e.getEntityPlayer().field_71071_by, old.field_75172_h, old.field_178150_j);
            newC.field_75152_c = old.field_75152_c;
            newC.func_75132_a((IContainerListener)((EntityPlayerMP)e.getEntityPlayer()));
            e.getEntityPlayer().field_71070_bA = newC;
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent e) {
        EntityLivingBase src;
        int lvl;
        int level;
        EntityLivingBase user = e.getEntityLiving();
        if (e.getSource().func_76346_g() instanceof Entity && user.func_70660_b(MobEffects.field_76429_m) == null && (level = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.BERSERK, (EntityLivingBase)user)) > 0) {
            user.func_70097_a(CORRUPTED, (float)(level * level));
            user.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200 * level, level - 1));
            user.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200 * level, level - 1));
            user.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200 * level, level - 1));
        }
        if (e.getSource().func_82725_o() && e.getSource().func_76346_g() instanceof EntityLivingBase && (lvl = EnchantmentHelper.func_185284_a((Enchantment)ApotheosisObjects.MAGIC_PROTECTION, (EntityLivingBase)(src = (EntityLivingBase)e.getSource().func_76346_g()))) > 0) {
            e.setAmount(CombatRules.func_188401_b((float)e.getAmount(), (float)EnchantmentHelper.func_77508_a((Iterable)src.func_184193_aE(), (DamageSource)e.getSource())));
        }
    }

    public static void setEnch(Item.ToolMaterial mat, int ench) {
        ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)mat, (Object)ench, (String)"enchantability", (String)"field_78008_j");
    }

    public static void setEnch(ItemArmor.ArmorMaterial mat, int ench) {
        ReflectionHelper.setPrivateValue(ItemArmor.ArmorMaterial.class, (Object)mat, (Object)ench, (String)"enchantability", (String)"field_78055_h");
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (enchInfoConfig == null) {
            LOGGER.error("A mod has attempted to access enchantment information before Apotheosis init, this should not happen.");
            Thread.dumpStack();
            return new EnchantmentInfo(ench, ench.func_77325_b(), ench.func_77319_d());
        }
        if (info == null) {
            String minF;
            int max = enchInfoConfig.getInt("Max Level", ench.getRegistryName().toString(), ench.func_77325_b(), 1, 127, "The max level of this enchantment.");
            int min = enchInfoConfig.getInt("Min Level", ench.getRegistryName().toString(), ench.func_77319_d(), 1, 127, "The min level of this enchantment.");
            if (ench == Enchantments.field_151369_A) {
                max = Enchantments.field_151369_A.func_77325_b();
            }
            if (min > max) {
                min = max;
            }
            info = new EnchantmentInfo(ench, max, min);
            String maxF = enchInfoConfig.getString("Max Power Function", ench.getRegistryName().toString(), "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
            if (!maxF.isEmpty()) {
                info.setMaxPower(new EnchantmentInfo.ExpressionPowerFunc(maxF));
            }
            if (!(minF = enchInfoConfig.getString("Min Power Function", ench.getRegistryName().toString(), "", "A function to determine the min enchanting power.")).isEmpty()) {
                info.setMinPower(new EnchantmentInfo.ExpressionPowerFunc(minF));
            }
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)ench.getRegistryName(), (Object)ench.getRegistryName().func_110624_b());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.func_77325_b();
        int maxPower = ench.func_77317_b(level);
        if (maxPower >= absMax) {
            return level;
        }
        int lastMaxPower = maxPower;
        while (maxPower < absMax) {
            if (lastMaxPower == (maxPower = ench.func_77317_b(++level))) {
                --level;
                break;
            }
            lastMaxPower = maxPower;
        }
        if (ench == Enchantments.field_185306_r) {
            return 1;
        }
        return level;
    }

    static void recalcAbsMax() {
        int max = MathHelper.func_76123_f((float)(maxPower * 2.0f));
        int maxEnch = 0;
        for (Item.ToolMaterial toolMaterial : Item.ToolMaterial.values()) {
            maxEnch = Math.max(maxEnch, toolMaterial.func_77995_e());
        }
        for (Item.ToolMaterial toolMaterial : ItemArmor.ArmorMaterial.values()) {
            maxEnch = Math.max(maxEnch, toolMaterial.func_78045_a());
        }
        absMax = max + maxEnch / 2 + 3;
    }

    static {
        absMax = 170;
        allowWeb = true;
        maxNormalPower = 20.0f;
        maxPower = 75.0f;
        itemMerging = false;
    }
}

