/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.loot.affix;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.ApotheosisObjects;
import shadows.deadly.gen.BossItem;
import shadows.deadly.loot.AffixModifier;
import shadows.deadly.loot.LootEntry;
import shadows.deadly.loot.LootManager;
import shadows.deadly.loot.affix.Affix;
import shadows.deadly.loot.affix.impl.AttributeAffix;
import shadows.deadly.loot.affix.impl.EnchantmentAffix;
import shadows.deadly.loot.affix.impl.GenericAffix;
import shadows.deadly.loot.affix.impl.RangedAffix;
import shadows.deadly.loot.affix.impl.SharpshooterAffix;
import shadows.deadly.loot.attributes.CustomAttributes;

@Mod.EventBusSubscriber(modid="apotheosis")
@GameRegistry.ObjectHolder(value="apotheosis")
public class Affixes {
    public static final Affix FIRE_DAMAGE = null;
    public static final Affix LUNAR_DAMAGE = null;
    public static final Affix SOLAR_DAMAGE = null;
    public static final Affix COLD_DAMAGE = null;
    public static final Affix QUARTZ_FUSED = null;
    public static final Affix MOVEMENT_SPEED = null;
    public static final Affix ARMOR_TOUGHNESS = null;
    public static final Affix ENDER_SLAYING = null;
    public static final Affix ARMOR = null;
    public static final Affix ALWAYS_CRIT = null;
    public static final Affix CRIT_DAMAGE = null;
    public static final Affix SHARPSHOOTER = null;
    public static final Affix ETERNAL = null;
    public static final Affix REACH_DISTANCE = null;
    public static final Affix FORTUNATE = null;
    public static final Affix REFLECTIVE = null;
    public static final Affix POWER = null;
    public static final Affix MAGIC_RESIST = null;
    public static final Affix SIFTING = null;
    public static final Affix RESISTANCE = null;
    public static final Affix WEAK_DAMAGE = null;
    public static final Affix WEAK_ARMOR = null;
    public static final Affix SWIM_SPEED = null;
    public static final Affix ATTACK_SPEED = null;
    public static final Affix MAX_HEALTH = null;
    public static final Affix REGENERATION = null;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Affix> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Affix[]{new AttributeAffix(CustomAttributes.FIRE_DAMAGE, 0.5f, 4.0f, 0, true, 3).setRegistryName("fire_damage"), new AttributeAffix(CustomAttributes.LUNAR_DAMAGE, 0.5f, 6.0f, 0, false, 1).setRegistryName("lunar_damage"), new AttributeAffix(CustomAttributes.SOLAR_DAMAGE, 0.5f, 6.0f, 0, false, 1).setRegistryName("solar_damage"), new AttributeAffix(CustomAttributes.COLD_DAMAGE, 0.5f, 4.0f, 0, true, 3).setRegistryName("cold_damage"), new EnchantmentAffix(Enchantments.field_185302_k, 15, true, 2).setRegistryName("quartz_fused"), new AttributeAffix(SharedMonsterAttributes.field_111263_d, 0.05f, 0.2f, 1, true, 3).setRegistryName("movement_speed"), new AttributeAffix(SharedMonsterAttributes.field_189429_h, 0.2f, 1.5f, 0, false, 1).setRegistryName("armor_toughness"), new AttributeAffix(CustomAttributes.VORPAL_DAMAGE, 1.0f, 5.0f, 0, true, 2).setRegistryName("ender_slaying"), new AttributeAffix(SharedMonsterAttributes.field_188791_g, 1.0f, 3.0f, 0, true, 3).setRegistryName("armor"), new GenericAffix(true, 1).setRegistryName("always_crit"), new AttributeAffix(CustomAttributes.CRIT_DAMAGE, 0.1f, 1.0f, 1, false, 2).setRegistryName("crit_damage"), new SharpshooterAffix(1).setRegistryName("sharpshooter"), new EnchantmentAffix(Enchantments.field_185307_s, 15, true, 1).setRegistryName("eternal"), new AttributeAffix(EntityPlayer.REACH_DISTANCE, 1.0f, 3.0f, 0, false, 2).setRegistryName("reach_distance"), new EnchantmentAffix(Enchantments.field_185308_t, 10, false, 1).setRegistryName("fortunate"), new EnchantmentAffix(() -> ApotheosisObjects.REFLECTIVE, 8, false, 2).setRegistryName("reflective"), new EnchantmentAffix(Enchantments.field_185309_u, 10, true, 2).setRegistryName("power"), new AttributeAffix(CustomAttributes.MAGIC_RESIST, 1.0f, 5.0f, 0, false, 1).setRegistryName("magic_resist"), new RangedAffix(1.0E-4f, 0.001f, true, 1).setRegistryName("sifting"), new RangedAffix(3.0f, 15.0f, false, 1).setRegistryName("resistance"), new AttributeAffix(SharedMonsterAttributes.field_111264_e, 0.3f, 1.0f, 0, true, 1).setRegistryName("weak_damage"), new AttributeAffix(SharedMonsterAttributes.field_188791_g, 0.3f, 1.0f, 0, true, 1).setRegistryName("weak_armor"), new AttributeAffix(EntityLivingBase.SWIM_SPEED, 0.1f, 0.4f, 1, false, 3).setRegistryName("swim_speed"), new AttributeAffix(SharedMonsterAttributes.field_188790_f, 0.3f, 1.0f, 1, true, 2).setRegistryName("attack_speed"), new AttributeAffix(SharedMonsterAttributes.field_111267_a, 4.0f, 20.0f, 0, true, 1).setRegistryName("max_health")});
    }

    public static void init() {
        Affixes.initArmor();
        Affixes.initSwords();
        Affixes.initShield();
        Affixes.initRanged();
        Affixes.initTools();
        Affixes.initEpic();
        Affixes.initEntries();
        Affixes.initModifiers();
    }

    private static void initSwords() {
        LootManager.registerAffix(BossItem.EquipmentType.SWORD, FIRE_DAMAGE);
        LootManager.registerAffix(BossItem.EquipmentType.SWORD, LUNAR_DAMAGE);
        LootManager.registerAffix(BossItem.EquipmentType.SWORD, SOLAR_DAMAGE);
        LootManager.registerAffix(BossItem.EquipmentType.SWORD, COLD_DAMAGE);
        LootManager.registerAffix(BossItem.EquipmentType.SWORD, ALWAYS_CRIT);
        LootManager.registerAffix(BossItem.EquipmentType.SWORD, CRIT_DAMAGE);
        LootManager.registerAffix(BossItem.EquipmentType.SWORD, ATTACK_SPEED);
        LootManager.registerWeakAffix(BossItem.EquipmentType.SWORD, WEAK_DAMAGE);
    }

    private static void initArmor() {
        LootManager.registerAffix(BossItem.EquipmentType.ARMOR, MOVEMENT_SPEED);
        LootManager.registerAffix(BossItem.EquipmentType.ARMOR, ARMOR_TOUGHNESS);
        LootManager.registerAffix(BossItem.EquipmentType.ARMOR, ARMOR);
        LootManager.registerAffix(BossItem.EquipmentType.ARMOR, MAGIC_RESIST);
        LootManager.registerAffix(BossItem.EquipmentType.ARMOR, MAX_HEALTH);
        LootManager.registerAffix(BossItem.EquipmentType.ARMOR, SWIM_SPEED);
        LootManager.registerWeakAffix(BossItem.EquipmentType.ARMOR, WEAK_ARMOR);
    }

    private static void initRanged() {
        LootManager.registerAffix(BossItem.EquipmentType.BOW, MOVEMENT_SPEED);
        LootManager.registerAffix(BossItem.EquipmentType.BOW, SHARPSHOOTER);
    }

    private static void initTools() {
        LootManager.registerAffix(BossItem.EquipmentType.TOOL, REACH_DISTANCE);
        LootManager.registerAffix(BossItem.EquipmentType.TOOL, SIFTING);
    }

    private static void initShield() {
        LootManager.registerAffix(BossItem.EquipmentType.SHIELD, MOVEMENT_SPEED);
        LootManager.registerAffix(BossItem.EquipmentType.SHIELD, ARMOR_TOUGHNESS);
        LootManager.registerAffix(BossItem.EquipmentType.SHIELD, ARMOR);
        LootManager.registerAffix(BossItem.EquipmentType.SHIELD, RESISTANCE);
        LootManager.registerAffix(BossItem.EquipmentType.SHIELD, MAX_HEALTH);
    }

    private static void initEpic() {
        LootManager.registerEpicAffix(BossItem.EquipmentType.SWORD, QUARTZ_FUSED);
        LootManager.registerEpicAffix(BossItem.EquipmentType.ARMOR, ETERNAL);
        LootManager.registerEpicAffix(BossItem.EquipmentType.TOOL, ETERNAL);
        LootManager.registerEpicAffix(BossItem.EquipmentType.TOOL, FORTUNATE);
        LootManager.registerEpicAffix(BossItem.EquipmentType.SHIELD, REFLECTIVE);
        LootManager.registerEpicAffix(BossItem.EquipmentType.BOW, POWER);
    }

    private static void initEntries() {
        LootManager.registerEntry(new LootEntry(new ItemStack(Items.field_151048_u), BossItem.EquipmentType.SWORD, 3));
        LootManager.registerEntry(new LootEntry(new ItemStack((Item)Items.field_151031_f), BossItem.EquipmentType.BOW, 2));
        LootManager.registerEntry(new LootEntry(new ItemStack(Items.field_185159_cQ), BossItem.EquipmentType.SHIELD, 1));
        LootManager.registerEntry(new LootEntry(new ItemStack((Item)Items.field_151161_ac), BossItem.EquipmentType.ARMOR, 2));
        LootManager.registerEntry(new LootEntry(new ItemStack((Item)Items.field_151163_ad), BossItem.EquipmentType.ARMOR, 2));
        LootManager.registerEntry(new LootEntry(new ItemStack((Item)Items.field_151173_ae), BossItem.EquipmentType.ARMOR, 2));
        LootManager.registerEntry(new LootEntry(new ItemStack((Item)Items.field_151175_af), BossItem.EquipmentType.ARMOR, 2));
        LootManager.registerEntry(new LootEntry(new ItemStack(Items.field_151047_v), BossItem.EquipmentType.TOOL, 1));
        LootManager.registerEntry(new LootEntry(new ItemStack(Items.field_151056_x), BossItem.EquipmentType.TOOL, 2));
        LootManager.registerEntry(new LootEntry(new ItemStack(Items.field_151046_w), BossItem.EquipmentType.TOOL, 2));
    }

    private static void initModifiers() {
        LootManager.registerModifier(new AffixModifier("double", AffixModifier.Operation.MULTIPLY, 2.0f, 6));
        LootManager.registerModifier(new AffixModifier("plus_three", AffixModifier.Operation.ADD, 3.0f, 2).dontEditName());
        LootManager.registerModifier(new AffixModifier("plus_one", AffixModifier.Operation.ADD, 1.0f, 10).dontEditName());
        LootManager.registerModifier(new AffixModifier("set_to_five", AffixModifier.Operation.SET, 5.0f, 1).dontEditName());
    }
}

