/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.loot;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import shadows.deadly.gen.BossItem;
import shadows.deadly.loot.AffixModifier;
import shadows.deadly.loot.LootEntry;
import shadows.deadly.loot.LootRarity;
import shadows.deadly.loot.Unique;
import shadows.deadly.loot.affix.Affix;
import shadows.deadly.loot.affix.AffixHelper;

public class LootManager {
    private static final Map<BossItem.EquipmentType, List<Affix>> PREFIXES = new EnumMap<BossItem.EquipmentType, List<Affix>>(BossItem.EquipmentType.class);
    private static final Map<BossItem.EquipmentType, List<Affix>> SUFFIXES = new EnumMap<BossItem.EquipmentType, List<Affix>>(BossItem.EquipmentType.class);
    private static final Map<BossItem.EquipmentType, List<Affix>> WEAK_AFFIXES = new EnumMap<BossItem.EquipmentType, List<Affix>>(BossItem.EquipmentType.class);
    private static final Map<BossItem.EquipmentType, List<Affix>> EPIC_AFFIXES = new EnumMap<BossItem.EquipmentType, List<Affix>>(BossItem.EquipmentType.class);
    private static final List<AffixModifier> MODIFIERS = new ArrayList<AffixModifier>();
    private static final List<LootEntry> ENTRIES = new ArrayList<LootEntry>();
    private static final List<Unique> UNIQUES = new ArrayList<Unique>();

    public static void registerAffix(BossItem.EquipmentType type, Affix affix) {
        if (affix == null) {
            throw new NullPointerException("Attempted to register null affix!");
        }
        Map<BossItem.EquipmentType, List<Affix>> afxMap = affix.isPrefix() ? PREFIXES : SUFFIXES;
        List affixes = afxMap.computeIfAbsent(type, t -> new ArrayList());
        if (affixes.contains((Object)affix)) {
            throw new UnsupportedOperationException("Attempted to register affix " + affix.getRegistryName() + " for category " + (Object)((Object)type) + " but it is already present!");
        }
        affixes.add(affix);
    }

    public static void registerWeakAffix(BossItem.EquipmentType type, Affix affix) {
        if (affix == null) {
            throw new NullPointerException("Attempted to register null weak affix!");
        }
        List affixes = WEAK_AFFIXES.computeIfAbsent(type, t -> new ArrayList());
        if (affixes.contains((Object)affix)) {
            throw new UnsupportedOperationException("Attempted to register weak affix " + affix.getRegistryName() + " for category " + (Object)((Object)type) + " but it is already present!");
        }
        affixes.add(affix);
    }

    public static void registerEpicAffix(BossItem.EquipmentType type, Affix affix) {
        if (affix == null) {
            throw new NullPointerException("Attempted to register null epic affix!");
        }
        List affixes = EPIC_AFFIXES.computeIfAbsent(type, t -> new ArrayList());
        if (affixes.contains((Object)affix)) {
            throw new UnsupportedOperationException("Attempted to register epic affix " + affix.getRegistryName() + " for category " + (Object)((Object)type) + " but it is already present!");
        }
        affixes.add(affix);
    }

    public static void registerModifier(AffixModifier entry) {
        if (entry == null) {
            throw new NullPointerException("Attempted to register invalid affix modifier!");
        }
        MODIFIERS.add(entry);
    }

    public static void registerEntry(LootEntry entry) {
        if (entry == null || entry.getStack().func_190926_b()) {
            throw new NullPointerException("Attempted to register invalid loot entry!");
        }
        ENTRIES.add(entry);
    }

    public static void registerUnique(Unique entry) {
        if (entry == null || entry.getStack().func_190926_b()) {
            throw new NullPointerException("Attempted to register invalid loot entry!");
        }
        UNIQUES.add(entry);
    }

    public static ItemStack getRandomEntry(Random rand, LootRarity rarity) {
        LootEntry entry = (LootEntry)WeightedRandom.func_76271_a((Random)rand, ENTRIES);
        ItemStack stack = rarity == LootRarity.UNIQUE ? LootManager.genUnique(rand) : entry.getStack().func_77946_l();
        return stack;
    }

    public static ItemStack genLootItem(ItemStack stack, Random rand, LootRarity rarity) {
        TextComponentString name = new TextComponentString(stack.func_82833_r());
        BossItem.EquipmentType type = BossItem.EquipmentType.getTypeFor(stack);
        HashMap<WeightedRandom.Item, AffixModifier> affixes = new HashMap<WeightedRandom.Item, AffixModifier>();
        EntityEquipmentSlot slot = BossItem.EquipmentType.getTypeFor(stack).getSlot(stack);
        Multimap modifs = stack.func_111283_C(slot);
        AffixHelper.addLore(stack, new TextComponentTranslation("rarity.apoth." + rarity.name().toLowerCase(Locale.ROOT), new Object[0]).func_150255_a(new Style().func_150238_a(rarity.color).func_150217_b(Boolean.valueOf(true))).func_150254_d());
        modifs.forEach((s, a) -> stack.func_185129_a(s, a, slot));
        switch (rarity) {
            case COMMON: {
                List<Affix> afxList = WEAK_AFFIXES.get((Object)type);
                if (!(rand.nextFloat() <= 0.33f) || afxList == null) break;
                affixes.put(WeightedRandom.func_76271_a((Random)rand, afxList), null);
                break;
            }
            case UNCOMMON: {
                List<Affix> afxList = rand.nextBoolean() ? PREFIXES.get((Object)type) : SUFFIXES.get((Object)type);
                affixes.put(WeightedRandom.func_76271_a((Random)rand, afxList), null);
                break;
            }
            case RARE: 
            case EPIC: 
            case ANCIENT: 
            case UNIQUE: {
                List<Affix> afxList = PREFIXES.get((Object)type);
                affixes.put(WeightedRandom.func_76271_a((Random)rand, afxList), null);
                afxList = SUFFIXES.get((Object)type);
                affixes.put(WeightedRandom.func_76271_a((Random)rand, afxList), null);
                break;
            }
        }
        boolean epicModif = false;
        if (rarity.ordinal() >= LootRarity.EPIC.ordinal()) {
            if (rarity.ordinal() >= LootRarity.ANCIENT.ordinal()) {
                epicModif = rand.nextBoolean();
            }
            int numModifs = rarity == LootRarity.EPIC ? 1 : (epicModif ? 1 : 2);
            Affix[] keys = affixes.keySet().toArray(new Affix[2]);
            int modifKey = rand.nextInt(2);
            affixes.put(keys[modifKey], LootManager.getModifier(rand));
            if (numModifs == 2) {
                modifKey = modifKey == 1 ? 0 : 1;
                affixes.put(keys[modifKey], LootManager.getModifier(rand));
            }
        }
        for (Affix a2 : affixes.keySet()) {
            name = a2.chainName((ITextComponent)name, (AffixModifier)((Object)affixes.get((Object)a2)));
            AffixHelper.applyAffix(stack, a2, a2.apply(stack, rand, (AffixModifier)((Object)affixes.get((Object)a2))));
        }
        if (rarity.ordinal() >= LootRarity.EPIC.ordinal()) {
            Affix afx = (Affix)WeightedRandom.func_76271_a((Random)rand, EPIC_AFFIXES.get((Object)type));
            AffixModifier epic = epicModif ? LootManager.getModifier(rand) : null;
            AffixHelper.applyAffix(stack, afx, afx.apply(stack, rand, epic));
            name = afx.chainName((ITextComponent)name, epic);
        }
        if (rarity.ordinal() >= LootRarity.ANCIENT.ordinal()) {
            NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            tag.func_74757_a("Unbreakable", true);
            stack.func_77982_d(tag);
        }
        stack.func_151001_c(TextFormatting.RESET + rarity.getColor().toString() + name.func_150254_d().replace(TextFormatting.RESET.toString(), ""));
        return stack;
    }

    public static AffixModifier getModifier(Random rand) {
        return (AffixModifier)WeightedRandom.func_76271_a((Random)rand, MODIFIERS);
    }

    public static ItemStack genUnique(Random rand) {
        return ItemStack.field_190927_a;
    }
}

