/*
 * Decompiled with CFR 0.152.
 */
package shadows.deadly.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import shadows.deadly.config.DeadlyConfig;
import shadows.deadly.gen.BossItem;
import shadows.deadly.gen.WorldFeature;
import shadows.deadly.gen.WorldGenerator;

public class BossFeature
extends WorldFeature {
    public static final List<BossItem> BOSS_ITEMS = new ArrayList<BossItem>();

    @Override
    public void generate(World world, int chunkX, int chunkZ, Random rand) {
        int y;
        if ((double)DeadlyConfig.bossChance <= rand.nextDouble()) {
            return;
        }
        int x = (chunkX << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        int z = (chunkZ << 4) + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(x, y, z);
        BossItem item = (BossItem)WeightedRandom.func_76271_a((Random)rand, BOSS_ITEMS);
        for (y = 15 + rand.nextInt(35); y > 10; --y) {
            if (world.func_180495_p((BlockPos)mPos.func_181079_c(x, y, z)).func_193401_d((IBlockAccess)world, (BlockPos)mPos, EnumFacing.UP) != BlockFaceShape.SOLID || world.func_72829_c(item.getAABB(world).func_186670_a((BlockPos)mPos.func_181079_c(x, y + 1, z)))) continue;
            item.place(world, (BlockPos)mPos, rand);
            WorldGenerator.setSuccess(world.field_73011_w.getDimension(), chunkX, chunkZ);
            return;
        }
    }

    @Override
    public boolean canBePlaced(World world, BlockPos pos, Random rand) {
        return false;
    }

    @Override
    public void place(World world, BlockPos pos, Random rand) {
    }

    public static void init() {
        for (Pair<Integer, ResourceLocation> pair : DeadlyConfig.BOSS_MOBS) {
            BossItem i = new BossItem((Integer)pair.getLeft(), (ResourceLocation)pair.getRight());
            BOSS_ITEMS.add(i);
        }
    }

    @Override
    public boolean isEnabled() {
        return !BOSS_ITEMS.isEmpty() && DeadlyConfig.bossChance > 0.0f;
    }
}

