/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.item.util;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class ItemStackUtil {
    public static ItemStack getItemStack(String id, int meta) {
        if (StringUtils.func_151246_b((String)id)) {
            return null;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id));
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Block blk = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(id));
        if (blk != null) {
            return new ItemStack(blk, 1, meta);
        }
        return null;
    }

    public static List<ItemStack> getAllItemsByType(Class clazz) {
        NonNullList itms = NonNullList.func_191196_a();
        Item.field_150901_e.forEach(itm -> {
            if (clazz.isInstance(itm)) {
                itm.func_150895_a(CreativeTabs.field_78027_g, itms);
            }
        });
        return itms;
    }

    public static List<ItemStack> getAllCombustableMaterials() {
        NonNullList itms = NonNullList.func_191196_a();
        Item.field_150901_e.forEach(itm -> {
            NonNullList temp = NonNullList.func_191196_a();
            itm.func_150895_a(CreativeTabs.field_78027_g, temp);
            temp.forEach(stack -> {
                if (TileEntityFurnace.func_145954_b((ItemStack)stack)) {
                    itms.add(stack);
                }
            });
        });
        return itms;
    }

    public static List<ItemStack> getAllSubItems(ItemStack stack) {
        NonNullList itms = NonNullList.func_191196_a();
        Item itm = stack.func_77973_b();
        itm.func_150895_a(CreativeTabs.field_78027_g, itms);
        return itms;
    }

    public static ResourceLocation getResourceLocationFromStack(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null) {
            return stack.func_77973_b().getRegistryName();
        }
        return null;
    }

    public static IBlockState itemStackToBlockState(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null) {
            Block blk = Block.func_149634_a((Item)stack.func_77973_b());
            IBlockState iBlockState = blk.func_176203_a(stack.func_77960_j());
        }
        return null;
    }

    public static void dropItemStack(ItemStack stack, BlockPos pos, World world) {
        if (stack != null) {
            EntityItem ent = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack.func_77946_l());
            world.func_72838_d((Entity)ent);
        }
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, double x, double y, double z, boolean randomDirection) {
        if (stack == null) {
            return false;
        }
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = 0.5f;
        if (randomDirection) {
            f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            f3 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        }
        EntityItem localEntityItem = new EntityItem(world, x + (double)f1, y + (double)f2, z + (double)f3, stack.func_77946_l());
        if (randomDirection) {
            localEntityItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
            localEntityItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
            localEntityItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
        } else {
            localEntityItem.field_70181_x = -0.05f;
            localEntityItem.field_70159_w = 0.0;
            localEntityItem.field_70179_y = 0.0;
        }
        world.func_72838_d((Entity)localEntityItem);
        return true;
    }

    public static ItemStack transferStack(IItemHandler destination, ItemStack stack, boolean simulate) {
        ItemStack rem = stack.func_77946_l();
        for (int i = 0; i < destination.getSlots() && (rem = destination.insertItem(0, stack, simulate)) != ItemStack.field_190927_a; ++i) {
        }
        return rem;
    }
}

