/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BlockMetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockWoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twistedgate.immersiveposts.IPOConfig;
import twistedgate.immersiveposts.common.blocks.IPOBlockBase;
import twistedgate.immersiveposts.enums.EnumFlipState;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public class BlockPost
extends IPOBlockBase
implements IPostBlock {
    public static final AxisAlignedBB POST_SHAPE = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
    public static final AxisAlignedBB LPARM_NORTH_BOUNDS = new AxisAlignedBB(0.3125, 0.25, 0.0, 0.6875, 0.75, 0.3125);
    public static final AxisAlignedBB LPARM_SOUTH_BOUNDS = new AxisAlignedBB(0.3125, 0.25, 0.6875, 0.6875, 0.75, 1.0);
    public static final AxisAlignedBB LPARM_EAST_BOUNDS = new AxisAlignedBB(0.6875, 0.25, 0.3125, 1.0, 0.75, 0.6875);
    public static final AxisAlignedBB LPARM_WEST_BOUNDS = new AxisAlignedBB(0.0, 0.25, 0.3125, 0.3125, 0.75, 0.6875);
    public static final PropertyBool LPARM_NORTH = PropertyBool.func_177716_a((String)"parm_north");
    public static final PropertyBool LPARM_EAST = PropertyBool.func_177716_a((String)"parm_east");
    public static final PropertyBool LPARM_SOUTH = PropertyBool.func_177716_a((String)"parm_south");
    public static final PropertyBool LPARM_WEST = PropertyBool.func_177716_a((String)"parm_west");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumPostType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumPostType.class);
    public static final PropertyEnum<EnumFlipState> FLIPSTATE = PropertyEnum.func_177709_a((String)"flipstate", EnumFlipState.class);
    protected EnumPostMaterial postMaterial;

    public BlockPost(Material blockMaterial, EnumPostMaterial postMaterial) {
        super(blockMaterial, postMaterial.func_176610_l());
        this.postMaterial = postMaterial;
        this.func_149752_b(5.0f);
        this.func_149711_c(3.0f);
        if (this.postMaterial == EnumPostMaterial.URANIUM) {
            this.func_149715_a(8.0f);
        }
        if (this.postMaterial == EnumPostMaterial.WOOD) {
            this.setHarvestLevel("axe", 0);
        } else {
            this.setHarvestLevel("pickaxe", 1);
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(FLIPSTATE, (Comparable)((Object)EnumFlipState.UP)).func_177226_a(TYPE, (Comparable)((Object)EnumPostType.POST)).func_177226_a((IProperty)LPARM_NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LPARM_WEST, (Comparable)Boolean.valueOf(false)));
    }

    public final EnumPostMaterial getPostMaterial() {
        return this.postMaterial;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer(this, new IProperty[]{FACING, FLIPSTATE, TYPE, LPARM_NORTH, LPARM_EAST, LPARM_SOUTH, LPARM_WEST}){

            protected BlockStateContainer.StateImplementation createState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
                return new PostState(block, properties);
            }
        };
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (((EnumPostType)((Object)state.func_177229_b(TYPE))).id() < 2) {
            drops.add((Object)this.postMaterial.getItemStack());
        }
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
            case POST_TOP: {
                return 1;
            }
            case ARM: {
                int rot;
                switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                    case WEST: {
                        rot = 5;
                        break;
                    }
                    case SOUTH: {
                        rot = 4;
                        break;
                    }
                    case EAST: {
                        rot = 3;
                        break;
                    }
                    default: {
                        rot = 2;
                    }
                }
                return rot;
            }
            case ARM_DOUBLE: {
                switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                    case WEST: {
                        return 9;
                    }
                    case SOUTH: {
                        return 8;
                    }
                    case EAST: {
                        return 7;
                    }
                }
                return 6;
            }
            case EMPTY: {
                return 15;
            }
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        switch (meta) {
            case 0: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.POST));
            }
            case 1: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.POST_TOP));
            }
            case 2: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            case 3: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 4: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 5: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
            case 6: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            case 7: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 8: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 9: {
                return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
        }
        return state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.EMPTY));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.postMaterial == EnumPostMaterial.URANIUM && stateIn.func_177229_b(TYPE) != EnumPostType.ARM && rand.nextFloat() < 0.125f) {
            double x = (double)pos.func_177958_n() + 0.375 + 0.25 * rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + 0.375 + 0.25 * rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, -1.0, 1.0, 0.25, new int[0]);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.postMaterial.getItemStack();
    }

    public boolean canConnectTransformer(IBlockAccess world, BlockPos pos) {
        return ((EnumPostType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).id() < 2;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        List<AxisAlignedBB> list = this.getSelectionBounds(state, worldIn, pos);
        if (list != null && !list.isEmpty()) {
            for (AxisAlignedBB aabb : list) {
                if ((aabb = aabb.func_186670_a(pos)) == null || !entityBox.func_72326_a(aabb)) continue;
                collidingBoxes.add(aabb);
            }
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    public RayTraceResult func_180636_a(IBlockState state, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        List<AxisAlignedBB> bounds = this.getSelectionBounds(state, worldIn, pos);
        if (bounds != null && !bounds.isEmpty()) {
            RayTraceResult ret = null;
            double minDist = Double.POSITIVE_INFINITY;
            for (AxisAlignedBB aabb : bounds) {
                double dist;
                RayTraceResult res;
                if (aabb == null || (res = this.func_185503_a(pos, start, end, aabb)) == null || !((dist = res.field_72307_f.func_72436_e(start)) < minDist)) continue;
                ret = res;
                minDist = dist;
            }
            return ret;
        }
        return this.func_185503_a(pos, start, end, state.func_185900_c((IBlockAccess)worldIn, pos));
    }

    private List<AxisAlignedBB> getSelectionBounds(IBlockState state, World world, BlockPos pos) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        ArrayList<AxisAlignedBB> bounds = null;
        if (((EnumPostType)((Object)state.func_177229_b(TYPE))).id() < 2) {
            bounds = new ArrayList<AxisAlignedBB>(5);
            if (((Boolean)state.func_177229_b((IProperty)LPARM_NORTH)).booleanValue()) {
                bounds.add(LPARM_NORTH_BOUNDS);
            }
            if (((Boolean)state.func_177229_b((IProperty)LPARM_SOUTH)).booleanValue()) {
                bounds.add(LPARM_SOUTH_BOUNDS);
            }
            if (((Boolean)state.func_177229_b((IProperty)LPARM_EAST)).booleanValue()) {
                bounds.add(LPARM_EAST_BOUNDS);
            }
            if (((Boolean)state.func_177229_b((IProperty)LPARM_WEST)).booleanValue()) {
                bounds.add(LPARM_WEST_BOUNDS);
            }
            bounds.add(POST_SHAPE);
        }
        return bounds;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack held = playerIn.func_184614_ca();
            if (EnumPostMaterial.isFenceItem(held)) {
                if (!held.func_77969_a(this.postMaterial.getItemStack())) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("immersiveposts.expectedlocal", new Object[]{new TextComponentString(this.postMaterial.getItemStack().func_82833_r())}), true);
                    return true;
                }
                if (!IPOConfig.isEnabled(EnumPostMaterial.getFrom(held))) {
                    return true;
                }
                for (int y = 0; y < worldIn.func_72940_L() - pos.func_177956_o(); ++y) {
                    BlockPos nPos = pos.func_177982_a(0, y, 0);
                    if (BlockPost.getBlockFrom((IBlockAccess)worldIn, nPos) instanceof BlockPost) {
                        IBlockState s = worldIn.func_180495_p(nPos);
                        EnumPostType type = (EnumPostType)((Object)s.func_177229_b(TYPE));
                        if (type != EnumPostType.POST && type != EnumPostType.POST_TOP && s.func_177229_b(FLIPSTATE) == EnumFlipState.DOWN) {
                            return true;
                        }
                        BlockPos up = nPos.func_177972_a(EnumFacing.UP);
                        if (BlockPost.getBlockFrom((IBlockAccess)worldIn, up) instanceof BlockPost && (type = (EnumPostType)((Object)(s = worldIn.func_180495_p(up)).func_177229_b(TYPE))) != EnumPostType.POST && type != EnumPostType.POST_TOP) {
                            return true;
                        }
                    }
                    if (worldIn.func_175623_d(nPos)) {
                        IBlockState fb = EnumPostMaterial.getPostStateFrom(held);
                        if (fb != null && !playerIn.func_180425_c().equals((Object)nPos) && worldIn.func_175656_a(nPos, fb) && !playerIn.field_71075_bZ.field_75098_d) {
                            held.func_190918_g(1);
                        }
                        return true;
                    }
                    if (worldIn.func_180495_p(nPos).func_177230_c() instanceof BlockPost) continue;
                    return true;
                }
            } else if (Utils.isHammer((ItemStack)held)) {
                switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
                    case POST_TOP: 
                    case POST: {
                        IBlockState defaultState = this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM));
                        switch (facing) {
                            case WEST: 
                            case SOUTH: 
                            case EAST: 
                            case NORTH: {
                                BlockPos nPos = pos.func_177972_a(facing);
                                if (worldIn.func_175623_d(nPos)) {
                                    defaultState = defaultState.func_177226_a((IProperty)FACING, (Comparable)facing);
                                    worldIn.func_175656_a(nPos, defaultState);
                                    defaultState.func_189546_a(worldIn, nPos, (Block)this, null);
                                    break;
                                }
                                if (BlockPost.getBlockFrom((IBlockAccess)worldIn, nPos) != this) break;
                                switch ((EnumPostType)((Object)worldIn.func_180495_p(nPos).func_177229_b(TYPE))) {
                                    case ARM: {
                                        worldIn.func_175698_g(nPos);
                                        return true;
                                    }
                                    case EMPTY: {
                                        worldIn.func_175698_g(nPos);
                                        return true;
                                    }
                                }
                            }
                        }
                        return true;
                    }
                    case ARM: {
                        EnumFacing bfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                        if (worldIn.func_175623_d(pos.func_177972_a(bfacing))) {
                            worldIn.func_175656_a(pos.func_177972_a(bfacing), state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE)));
                            worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.EMPTY)));
                        }
                        return true;
                    }
                    case ARM_DOUBLE: {
                        EnumFacing bfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                        worldIn.func_175698_g(pos);
                        worldIn.func_175656_a(pos.func_177972_a(bfacing.func_176734_d()), state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                        return true;
                    }
                    case EMPTY: {
                        EnumFacing bfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                        worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                        worldIn.func_175698_g(pos.func_177972_a(bfacing));
                        return true;
                    }
                }
            }
        }
        return Utils.isHammer((ItemStack)playerIn.func_184614_ca()) || EnumPostMaterial.isFenceItem(playerIn.func_184614_ca());
    }

    public static boolean canConnect(IBlockAccess worldIn, BlockPos posIn, EnumFacing facingIn) {
        boolean b;
        BlockPos nPos = posIn.func_177972_a(facingIn);
        IBlockState otherState = worldIn.func_180495_p(nPos);
        Block otherBlock = otherState.func_177230_c();
        if (otherBlock == Blocks.field_150350_a) {
            return false;
        }
        if (facingIn == EnumFacing.DOWN || facingIn == EnumFacing.UP) {
            AxisAlignedBB box = otherState.func_185900_c(worldIn, nPos);
            switch (facingIn) {
                case UP: {
                    return box.field_72338_b == 0.0;
                }
                case DOWN: {
                    boolean bool = otherBlock instanceof BlockPost;
                    return !bool && box.field_72337_e == 1.0;
                }
            }
            return false;
        }
        if (otherBlock instanceof BlockPost || otherState.func_193401_d(worldIn, nPos, facingIn) == BlockFaceShape.MIDDLE_POLE) {
            return false;
        }
        AxisAlignedBB box = otherState.func_185900_c(worldIn, nPos);
        switch (facingIn) {
            case NORTH: {
                b = box.field_72334_f == 1.0;
                break;
            }
            case SOUTH: {
                b = box.field_72339_c == 0.0;
                break;
            }
            case WEST: {
                b = box.field_72336_d == 1.0;
                break;
            }
            case EAST: {
                b = box.field_72340_a == 0.0;
                break;
            }
            default: {
                b = false;
            }
        }
        return b && (facingIn.func_176740_k() == EnumFacing.Axis.Z && box.field_72340_a > 0.0 && box.field_72336_d < 1.0 || facingIn.func_176740_k() == EnumFacing.Axis.X && box.field_72339_c > 0.0 && box.field_72334_f < 1.0);
    }

    public static class PostState
    extends BlockStateContainer.StateImplementation {
        private static final AxisAlignedBB X_BOUNDS = new AxisAlignedBB(0.0, 0.34375, 0.3125, 1.0, 1.0, 0.6875);
        private static final AxisAlignedBB Z_BOUNDS = new AxisAlignedBB(0.3125, 0.34375, 0.0, 0.6875, 1.0, 1.0);
        private static final Map<Integer, AxisAlignedBB> shapeCache = new HashMap<Integer, AxisAlignedBB>();

        public PostState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties) {
            super(block, properties);
        }

        public IBlockState func_185899_b(IBlockAccess blockAccess, BlockPos pos) {
            if (((EnumPostType)((Object)this.func_177229_b((IProperty)TYPE))).id() > 1) {
                return this.func_177226_a((IProperty)FLIPSTATE, (Comparable)((Object)this.getFlipState(blockAccess, pos)));
            }
            boolean b0 = BlockPost.canConnect(blockAccess, pos, EnumFacing.NORTH);
            boolean b1 = BlockPost.canConnect(blockAccess, pos, EnumFacing.EAST);
            boolean b2 = BlockPost.canConnect(blockAccess, pos, EnumFacing.SOUTH);
            boolean b3 = BlockPost.canConnect(blockAccess, pos, EnumFacing.WEST);
            return this.func_177226_a((IProperty)LPARM_NORTH, Boolean.valueOf(b0)).func_177226_a((IProperty)LPARM_EAST, (Comparable)Boolean.valueOf(b1)).func_177226_a((IProperty)LPARM_SOUTH, (Comparable)Boolean.valueOf(b2)).func_177226_a((IProperty)LPARM_WEST, (Comparable)Boolean.valueOf(b3));
        }

        public BlockFaceShape func_193401_d(IBlockAccess worldIn, BlockPos pos, EnumFacing face) {
            int tmp;
            IBlockState state = worldIn.func_180495_p(pos.func_177972_a(face));
            Block block = state.func_177230_c();
            if (block instanceof BlockFence || block instanceof BlockWall) {
                return BlockFaceShape.UNDEFINED;
            }
            boolean f = false;
            if (block instanceof BlockWoodenDecoration && block.func_176201_c(state) == BlockTypes_WoodenDecoration.FENCE.getMeta()) {
                f = true;
            }
            if (block instanceof BlockMetalDecoration1 && ((tmp = block.func_176201_c(state)) == BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta() || tmp == BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta())) {
                f = true;
            }
            return f ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
        }

        public AxisAlignedBB func_185900_c(IBlockAccess blockAccess, BlockPos pos) {
            return PostState.stateBounds((IBlockState)this);
        }

        public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
            return false;
        }

        public boolean func_185915_l() {
            return false;
        }

        public boolean func_185914_p() {
            return false;
        }

        public boolean func_185917_h() {
            return false;
        }

        public void func_189546_a(World world, BlockPos pos, Block block, BlockPos fromPos) {
            this.updateState(world, pos);
        }

        private void updateState(World world, BlockPos pos) {
            BlockPos belowPos;
            EnumPostType thisType = (EnumPostType)((Object)this.func_177229_b((IProperty)TYPE));
            if (thisType.id() <= 1 && IPOBlockBase.getBlockFrom((IBlockAccess)world, belowPos = pos.func_177972_a(EnumFacing.DOWN)) == Blocks.field_150350_a) {
                IPOBlockBase.getBlockFrom((IBlockAccess)world, pos).func_176226_b(world, pos, (IBlockState)this, 0);
                world.func_175698_g(pos);
                return;
            }
            IBlockState aboveState = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
            Block aboveBlock = aboveState.func_177230_c();
            switch (thisType) {
                case POST: {
                    if (!(aboveBlock instanceof BlockPost)) {
                        world.func_175656_a(pos, this.func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumPostType.POST_TOP)));
                    }
                    return;
                }
                case POST_TOP: {
                    if (aboveBlock instanceof BlockPost && aboveState.func_177229_b(TYPE) == EnumPostType.POST_TOP) {
                        world.func_175656_a(pos, this.func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumPostType.POST)));
                    }
                    return;
                }
                case ARM: {
                    EnumFacing f = ((EnumFacing)this.func_177229_b((IProperty)FACING)).func_176734_d();
                    IBlockState state = world.func_180495_p(pos.func_177972_a(f));
                    if (state != null && !(state.func_177230_c() instanceof BlockPost)) {
                        world.func_175698_g(pos);
                        return;
                    }
                    world.func_175656_a(pos, this.func_177226_a((IProperty)FLIPSTATE, (Comparable)((Object)this.getFlipState((IBlockAccess)world, pos))));
                    return;
                }
                case ARM_DOUBLE: {
                    EnumFacing f = ((EnumFacing)this.func_177229_b((IProperty)FACING)).func_176734_d();
                    IBlockState state = world.func_180495_p(pos.func_177972_a(f));
                    if (state != null && !(state.func_177230_c() instanceof BlockPost)) {
                        world.func_175698_g(pos);
                    }
                    return;
                }
                case EMPTY: {
                    EnumFacing f = ((EnumFacing)this.func_177229_b((IProperty)FACING)).func_176734_d();
                    IBlockState state = world.func_180495_p(pos.func_177972_a(f));
                    if (state != null && !(state.func_177230_c() instanceof BlockPost)) {
                        world.func_175698_g(pos);
                        return;
                    }
                    state = world.func_180495_p(pos);
                    f = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    if ((state = world.func_180495_p(pos.func_177972_a(f))).func_177230_c() != Blocks.field_150350_a) break;
                    world.func_175698_g(pos);
                }
            }
        }

        private EnumFlipState getFlipState(IBlockAccess world, BlockPos pos) {
            boolean down;
            IBlockState aboveState = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
            IBlockState belowState = world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
            Block aboveBlock = aboveState.func_177230_c();
            Block belowBlock = belowState.func_177230_c();
            boolean up = BlockPost.canConnect(world, pos, EnumFacing.UP) && (!(aboveBlock instanceof BlockPost) || aboveState.func_177229_b(TYPE) != EnumPostType.ARM);
            boolean bl = down = BlockPost.canConnect(world, pos, EnumFacing.DOWN) && (!(belowBlock instanceof BlockPost) || belowState.func_177229_b(TYPE) != EnumPostType.ARM);
            EnumFlipState flipState = up && down ? EnumFlipState.BOTH : (down ? EnumFlipState.DOWN : EnumFlipState.UP);
            return flipState;
        }

        static AxisAlignedBB stateBounds(IBlockState state) {
            switch ((EnumPostType)((Object)state.func_177229_b(TYPE))) {
                case ARM: 
                case ARM_DOUBLE: {
                    EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    EnumFlipState flipstate = (EnumFlipState)((Object)state.func_177229_b(FLIPSTATE));
                    int id = 0;
                    switch (flipstate) {
                        case UP: {
                            id = 16;
                            break;
                        }
                        case DOWN: {
                            id = 32;
                            break;
                        }
                        case BOTH: {
                            id = 48;
                        }
                    }
                    switch (dir) {
                        case WEST: {
                            id |= 8;
                        }
                        case SOUTH: {
                            id |= 4;
                        }
                        case EAST: {
                            id |= 2;
                        }
                    }
                    if (!shapeCache.containsKey(id |= 1)) {
                        double minY = 0.0;
                        double maxY = 1.0;
                        switch (flipstate) {
                            case UP: {
                                minY = 0.34375;
                                maxY = 1.0;
                                break;
                            }
                            case DOWN: {
                                minY = 0.0;
                                maxY = 0.65625;
                                break;
                            }
                            case BOTH: {
                                minY = 0.0;
                                maxY = 1.0;
                            }
                        }
                        double minX = dir == EnumFacing.EAST ? 0.0 : 0.3125;
                        double maxX = dir == EnumFacing.WEST ? 1.0 : 0.6875;
                        double minZ = dir == EnumFacing.SOUTH ? 0.0 : 0.3125;
                        double maxZ = dir == EnumFacing.NORTH ? 1.0 : 0.6875;
                        AxisAlignedBB shape = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
                        shapeCache.put(id, shape);
                        return shape;
                    }
                    return shapeCache.get(id);
                }
                case EMPTY: {
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                    EnumFacing.Axis axis = facing.func_176740_k();
                    if (axis == EnumFacing.Axis.X) {
                        return X_BOUNDS;
                    }
                    return Z_BOUNDS;
                }
            }
            return POST_SHAPE;
        }
    }
}

