/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop.configuration;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="endercrop")
@Config(modid="endercrop")
public class EnderCropConfiguration {
    @Config.Comment(value={"Percent chance to get an ender pearl"})
    @Config.RangeInt(min=0, max=100)
    public static int pearlChance = 100;
    @Config.Comment(value={"Percent chance to get a second ender pearl"})
    @Config.RangeInt(min=0, max=100)
    public static int secondPearlChance = 10;
    @Config.Comment(value={"Percent chance to get a seed drop"})
    @Config.RangeInt(min=0, max=100)
    public static int seedChance = 100;
    @Config.Comment(value={"Percent chance to get a second seed drop"})
    @Config.RangeInt(min=0, max=100)
    public static int secondSeedChance = 10;
    @Config.Comment(value={"Crop growth multiplier on tilled soil, this value multiplies default vanilla growth rate", "e.g. 10.5 -> Ten and a half times the speed of vanilla crop"})
    @Config.RangeDouble(min=0.0)
    public static float tilledSoilMultiplier = 0.5f;
    @Config.Comment(value={"Crop growth multiplier on tilled end stone, this value multiplies default vanilla growth rate", "e.g. 10.5 -> Ten and a half times the speed of vanilla crop"})
    @Config.RangeDouble(min=0.0)
    public static float tilledEndMultiplier = 1.0f;
    @Config.Comment(value={"Enable Tilled End Stone"})
    @Config.RequiresMcRestart
    public static boolean tilledEndStone = true;
    @Config.Comment(value={"Chance to spawn endermite when harvesting an Ender Crop on Tilled End Stone (1 in ...)", "0 to disable"})
    @Config.Name(value="Endermite chance")
    @Config.RangeInt(min=0)
    public static int miteChance = 50;
    @Config.Comment(value={"Ender Seed dungeon spawn weight (e.g.: 1:golden apple, 100:bread)", "0 to disable"})
    @Config.RangeInt(min=0)
    public static int dungeonChance = 1;
    @Config.Comment(value={"Is a hoe enchanted with Unbreaking (I) needed to till endstone?"})
    @Config.Name(value="Tilling end stone needs unbreaking")
    public static boolean endstoneNeedsUnbreaking = true;
    @Config.Comment(value={"Minimum mattock material level needed to till endstone"})
    @Config.Name(value="Minimum mattock harvest level")
    @Config.RangeInt(min=0)
    public static int mattockHarvestLevelEndstone = 1;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("endercrop")) {
            ConfigManager.sync((String)"endercrop", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

