/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.endercrop.compat;

import com.google.common.base.Function;
import io.github.drmanganese.endercrop.HoeHelper;
import io.github.drmanganese.endercrop.block.BlockCropEnder;
import io.github.drmanganese.endercrop.block.BlockTilledEndStone;
import io.github.drmanganese.endercrop.configuration.EnderCropConfiguration;
import io.github.drmanganese.endercrop.init.ModBlocks;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class TOPCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"io.github.drmanganese.endercrop.compat.TOPCompatibility$GetTheOneProbe");
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "endercrop";
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                    ItemStack hoeStack;
                    if (blockState.func_177230_c() instanceof BlockTilledEndStone) {
                        if (mode == ProbeMode.EXTENDED) {
                            if ((Integer)blockState.func_177229_b((IProperty)BlockTilledEndStone.field_176531_a) == 7) {
                                probeInfo.text(TextStyleClass.LABEL + "{*endercrop.wailatop.moist*}");
                            } else {
                                probeInfo.text(TextStyleClass.LABEL + "{*endercrop.wailatop.dry*}");
                            }
                        }
                        if (mode == ProbeMode.DEBUG) {
                            probeInfo.text("MOISTURE: " + blockState.func_177229_b((IProperty)BlockTilledEndStone.field_176531_a));
                        }
                    } else if (blockState.func_177230_c() == ModBlocks.CROP_ENDER) {
                        float age = (float)((Integer)blockState.func_177229_b((IProperty)BlockCropEnder.field_176488_a)).intValue() / 7.0f;
                        if (age < 1.0f && world.func_180495_p(data.getPos().func_177977_b()).func_177230_c() == Blocks.field_150458_ak && !ModBlocks.CROP_ENDER.func_176473_a(world, data.getPos(), blockState, world.field_72995_K)) {
                            probeInfo.text(TextStyleClass.ERROR + "{*endercrop.wailatop.nogrowth*}");
                        }
                        if (mode != ProbeMode.NORMAL) {
                            String text = TextStyleClass.WARNING + "{*endercrop.wailatop.light*}: " + world.func_175671_l(data.getPos().func_177984_a());
                            if (world.func_175671_l(data.getPos().func_177984_a()) >= 7) {
                                text = text + TextFormatting.RED + "(>=7)";
                            }
                            probeInfo.text(text);
                        }
                    } else if (blockState.func_177230_c() == Blocks.field_150377_bs && !(hoeStack = HoeHelper.holdingHoeTool(player)).func_190926_b()) {
                        IProbeInfo hori = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                        if (HoeHelper.canHoeEndstone(hoeStack) || player.func_184812_l_()) {
                            hori.icon(new ResourceLocation("theoneprobe", "textures/gui/icons.png"), 0, 16, 13, 13, probeInfo.defaultIconStyle().width(18).height(14).textureWidth(32).textureHeight(32));
                            if (hoeStack.func_77973_b() instanceof ItemHoe) {
                                hori.text(TextStyleClass.OK + "{*endercrop.top.hoe*}");
                            } else {
                                hori.text(TextStyleClass.OK + "Mattock");
                            }
                        } else {
                            hori.icon(new ResourceLocation("theoneprobe", "textures/gui/icons.png"), 16, 16, 13, 13, probeInfo.defaultIconStyle().width(18).height(14).textureWidth(32).textureHeight(32));
                            if (hoeStack.func_77973_b() instanceof ItemHoe) {
                                hori.text(TextStyleClass.WARNING + "{*endercrop.top.hoe*}" + (EnderCropConfiguration.endstoneNeedsUnbreaking ? " (Unbreaking I+)" : ""));
                            } else {
                                hori.text(TextStyleClass.WARNING + "Mattock (" + HoeHelper.getHarvestLevelName(EnderCropConfiguration.mattockHarvestLevelEndstone) + TextStyleClass.WARNING + ")");
                            }
                        }
                    }
                }
            });
            return null;
        }
    }
}

