/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.items.ItemImpl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMultiblockMaker
extends ItemImpl {
    private static List<IMultiblock> multiblocks;

    public ItemMultiblockMaker() {
        super("multiblock_maker");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.field_71075_bZ.field_75098_d) {
            int curr = ItemMultiblockMaker.getMultiblock(stack);
            int next = (curr + 1) % ItemMultiblockMaker.multiblocks().size();
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a("multiblock", next);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.field_71075_bZ.field_75098_d) {
            IMultiblock multi = ItemMultiblockMaker.multiblocks().get(ItemMultiblockMaker.getMultiblock(player.func_184586_b(hand)));
            if (multi == null) {
                return EnumActionResult.PASS;
            }
            if (!worldIn.field_72995_K) {
                multi.forEach(pos.func_177984_a(), '\u0000', (blockPos, matcher) -> {
                    worldIn.func_175656_a(blockPos, matcher.getDefaultState());
                    return true;
                });
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        IMultiblock multi = ItemMultiblockMaker.multiblocks().get(ItemMultiblockMaker.getMultiblock(stack));
        return multi == null ? name : name + " (" + multi.getName() + ")";
    }

    private static int getMultiblock(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("multiblock");
    }

    private static List<IMultiblock> multiblocks() {
        if (multiblocks == null) {
            multiblocks = new ArrayList<IMultiblock>();
            multiblocks.addAll(NaturesAuraAPI.MULTIBLOCKS.values());
        }
        return multiblocks;
    }
}

