/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.api.recipes.ing.AmountIngredient;
import de.ellpeck.naturesaura.compat.crafttweaker.CraftTweakerCompat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.naturesaura.Offering")
public final class OfferingTweaker {
    @ZenMethod
    public static void addRecipe(String name, IIngredient input, int inputAmount, IIngredient startItem, IItemStack output) {
        CraftTweakerCompat.SCHEDULED_ACTIONS.add(() -> {
            ResourceLocation res = new ResourceLocation("crafttweaker", name);
            return new Add(Collections.singletonMap(res, new OfferingRecipe(res, new AmountIngredient(CraftTweakerMC.getIngredient((IIngredient)input), inputAmount), CraftTweakerMC.getIngredient((IIngredient)startItem), InputHelper.toStack((IItemStack)output))));
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerCompat.SCHEDULED_ACTIONS.add(() -> {
            HashMap<ResourceLocation, OfferingRecipe> recipes = new HashMap<ResourceLocation, OfferingRecipe>();
            for (OfferingRecipe recipe : NaturesAuraAPI.OFFERING_RECIPES.values()) {
                if (!Helper.areItemsEqual(recipe.output, InputHelper.toStack((IItemStack)output), true)) continue;
                recipes.put(recipe.name, recipe);
            }
            return new Remove(recipes);
        });
    }

    private static class Remove
    extends BaseMapRemoval<ResourceLocation, OfferingRecipe> {
        protected Remove(Map<ResourceLocation, OfferingRecipe> map) {
            super("Offering", NaturesAuraAPI.OFFERING_RECIPES, map);
        }

        protected String getRecipeInfo(Map.Entry<ResourceLocation, OfferingRecipe> recipe) {
            return LogHelper.getStackDescription((Object)recipe.getValue().output);
        }
    }

    private static class Add
    extends BaseMapAddition<ResourceLocation, OfferingRecipe> {
        protected Add(Map<ResourceLocation, OfferingRecipe> map) {
            super("Offering", NaturesAuraAPI.OFFERING_RECIPES, map);
        }

        protected String getRecipeInfo(Map.Entry<ResourceLocation, OfferingRecipe> recipe) {
            return LogHelper.getStackDescription((Object)recipe.getValue().output);
        }
    }
}

