/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.event.ComponentEvent;

public class UIListContainer<S>
extends UIContainer<UIListContainer<S>> {
    protected int elementSpacing = 0;
    protected boolean unselect = true;
    protected Collection<S> elements = Collections.emptyList();
    protected S selected;
    protected int lastSize = 0;
    protected BiFunction<MalisisGui, S, UIComponent<?>> elementComponentFactory = (x$0, x$1) -> new DefaultElementComponent((MalisisGui)((Object)x$0), x$1);
    protected UIScrollBar scrollbar;
    protected int yOffset;
    protected int elementsSize;

    public UIListContainer(MalisisGui gui) {
        super(gui);
        this.scrollbar = new UIScrollBar(gui, this.self(), UIScrollBar.Type.VERTICAL);
        this.scrollbar.setAutoHide(true);
    }

    public UIListContainer(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    @Override
    public UIListContainer<S> setSize(int width, int height) {
        super.setSize(width, height);
        this.scrollbar.updateScrollbar();
        return (UIListContainer)this.self();
    }

    protected void buildElementComponents() {
        this.removeAll();
        int y = 0;
        for (S element : this.elements) {
            UIComponent<?> comp = this.elementComponentFactory.apply(this.getGui(), element);
            comp.attachData(element);
            comp.setPosition(0, y);
            this.add(comp);
            y += comp.getHeight() + this.elementSpacing;
        }
        this.elementsSize = this.elements.size();
    }

    public void setElements(Collection<S> elements) {
        this.elements = elements != null ? elements : Collections.emptyList();
        this.buildElementComponents();
    }

    public Iterable<S> getElements() {
        return this.elements;
    }

    public UIListContainer<S> setComponentFactory(BiFunction<MalisisGui, S, UIComponent<?>> factory) {
        this.elementComponentFactory = factory;
        return (UIListContainer)this.self();
    }

    public void setElementSpacing(int elementSpacing) {
        this.elementSpacing = elementSpacing;
    }

    public boolean canUnselect() {
        return this.unselect;
    }

    public void setUnselect(boolean unselect) {
        this.unselect = unselect;
    }

    public void setSelected(S comp) {
        this.selected = comp;
    }

    public S getSelected() {
        return this.selected;
    }

    public boolean isSelected(S element) {
        return element == this.selected;
    }

    public S select(S element) {
        if (!this.fireEvent(new SelectEvent<S>((UIListContainer)this.self(), element))) {
            return this.getSelected();
        }
        this.setSelected(element);
        return element;
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea(this);
    }

    @Override
    public void setClipContent(boolean clipContent) {
    }

    @Override
    public boolean shouldClipContent() {
        return true;
    }

    @Override
    public void draw(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.elements.size() != this.elementsSize) {
            this.buildElementComponents();
        }
        super.draw(renderer, mouseX, mouseY, partialTick);
    }

    public class DefaultElementComponent
    extends UIComponent<DefaultElementComponent> {
        private S element;

        public DefaultElementComponent(MalisisGui gui, S element) {
            super(gui);
            this.element = element;
        }

        @Override
        public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        }

        @Override
        public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
            renderer.drawText(this.element.toString());
        }
    }

    public static class SelectEvent<S>
    extends ComponentEvent.ValueChange<UIListContainer<S>, S> {
        public SelectEvent(UIListContainer<S> component, S selected) {
            super(component, component.getSelected(), selected);
        }

        public S getSelected() {
            return (S)this.newValue;
        }
    }
}

