/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.DoorState;
import net.malisis.doors.block.RustyHatch;
import net.malisis.doors.movement.RustyHatchMovement;
import net.malisis.doors.sound.RustyHatchSound;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

@Syncable(value="TileEntity")
public class RustyHatchTileEntity
extends DoorTileEntity {
    private boolean isTop = false;

    public RustyHatchTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(RustyHatchMovement.class));
        descriptor.setSound(DoorRegistry.getSound(RustyHatchSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(60);
        this.setDescriptor(descriptor);
    }

    @Override
    public IBlockState getBlockState() {
        return null;
    }

    public boolean isTop() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() == this.func_145838_q() && (Boolean)state.func_177229_b((IProperty)RustyHatch.TOP) != false;
    }

    @Override
    public EnumFacing getDirection() {
        return DirectionalComponent.getDirection((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    @Override
    public boolean isOpened() {
        return this.state == DoorState.OPENED;
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    public boolean shouldLadder(BlockPos pos) {
        EnumFacing dir = this.getDirection();
        if (pos.func_177952_p() == this.field_174879_c.func_177952_p() && (dir == EnumFacing.NORTH || dir == EnumFacing.SOUTH)) {
            return false;
        }
        if (pos.func_177958_n() == this.field_174879_c.func_177958_n() && (dir == EnumFacing.WEST || dir == EnumFacing.EAST)) {
            return false;
        }
        return this.func_145831_w().isSideSolid(pos.func_177972_a(dir), dir.func_176734_d());
    }

    @Override
    public void openOrCloseDoor() {
        if (this.getState() != DoorState.CLOSED && this.getState() != DoorState.OPENED) {
            return;
        }
        super.openOrCloseDoor();
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isTop = nbt.func_74767_n("top");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("top", this.isTop);
        return nbt;
    }
}

