/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.blocks.BlockDynamicLeavesPalm;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import java.util.HashMap;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.property.IExtendedBlockState;

public class TreePalm
extends TreeFamilyPHC {
    public TreePalm() {
        this(new ResourceLocation("dynamictreesphc", "palm"));
        this.canSupportCocoa = true;
        for (LeavesProperties properties : ModBlocks.palmLeavesProperties.values()) {
            properties.setTree((TreeFamily)this);
        }
    }

    public TreePalm(ResourceLocation name) {
        super(name);
        this.setPrimitiveLog(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), new ItemStack(Blocks.field_150364_r, 1, 3));
        this.addConnectableVanillaLeaves(state -> state == Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE));
    }

    public float getPrimaryThickness() {
        return 3.0f;
    }

    public float getSecondaryThickness() {
        return 3.0f;
    }

    public HashMap<BlockPos, IBlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        if (destructionData.getNumEndpoints() < 1) {
            return null;
        }
        HashMap<BlockPos, IBlockState> leaves = new HashMap<BlockPos, IBlockState>();
        BlockPos relPos = destructionData.getEndPointRelPos(0).func_177984_a();
        ILeavesProperties leavesProperties = this.getCommonSpecies().getLeavesProperties();
        leaves.put(relPos, leavesProperties.getDynamicLeavesState(4));
        leaves.put(relPos.func_177984_a(), leavesProperties.getDynamicLeavesState(3));
        for (int hydro = 1; hydro <= 2; ++hydro) {
            IExtendedBlockState extState = (IExtendedBlockState)leavesProperties.getDynamicLeavesState(hydro);
            for (CoordUtils.Surround surr : BlockDynamicLeavesPalm.hydroSurroundMap[hydro]) {
                leaves.put(relPos.func_177971_a(surr.getOpposite().getOffset()), (IBlockState)extState.withProperty(BlockDynamicLeavesPalm.CONNECTIONS[surr.ordinal()], (Object)true));
            }
        }
        return leaves;
    }
}

