/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.ModConfigs;
import com.ferreusveritas.dynamictreesphc.blocks.BlockBranchPamSpecial;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import com.pam.harvestcraft.blocks.FruitRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeCinnamon
extends TreeFamilyPHC {
    public static final String speciesName = "cinnamon";

    public TreeCinnamon() {
        super(new ResourceLocation("dynamictreesphc", speciesName));
        this.setPrimitiveLog(FruitRegistry.getLog((String)speciesName).func_176223_P());
        ModBlocks.cinnamonLeavesProperties.setTree((TreeFamily)this);
    }

    public void createSpecies() {
        this.setCommonSpecies(new TreeCinnamonSpecies(this));
    }

    public BlockBranch createBranch() {
        return new BlockBranchPamSpecial(this.getName() + "branch", speciesName, ModConfigs.treeCinnamonYieldPerLog);
    }

    public class TreeCinnamonSpecies
    extends Species {
        public TreeCinnamonSpecies(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, (ILeavesProperties)ModBlocks.cinnamonLeavesProperties);
            this.setBasicGrowingParameters(0.1f, 14.0f, 12, this.getLowestBranchHeight(), 1.8f);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public boolean useDefaultWailaBody() {
            return false;
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        }

        public int maxBranchRadius() {
            return 4;
        }
    }
}

