/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.dropcreators;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictreesphc.blocks.BlockPamFruit;
import com.ferreusveritas.dynamictreesphc.blocks.BlockPamFruitPalm;
import java.util.List;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenFruitPalm
implements IPostGenFeature,
IPostGrowFeature {
    BlockFruit fruitPod;
    int allowedSize;
    int frondHeight;
    boolean isSided;
    Integer forceHeight = null;
    protected int fruitingRadius = 6;

    public FeatureGenFruitPalm(BlockFruit fruitPod, int size, boolean isSided, boolean forceHeightDown) {
        this(fruitPod, size, isSided);
        this.forceHeight = forceHeightDown ? 1 : 0;
    }

    public FeatureGenFruitPalm(BlockFruit fruitPod, int size, boolean isSided, int frondHeight) {
        this.fruitPod = fruitPod;
        this.allowedSize = Math.max(size, 1);
        this.isSided = isSided;
        this.frondHeight = frondHeight;
    }

    public FeatureGenFruitPalm(BlockFruit fruitPod, int size, boolean isSided) {
        this(fruitPod, size, isSided, 20);
    }

    public void setFruitingRadius(int fruitingRadius) {
        this.fruitingRadius = fruitingRadius;
    }

    private int getRandPosition(World world) {
        if (this.forceHeight != null) {
            return this.forceHeight;
        }
        return world.field_73012_v.nextInt(this.allowedSize);
    }

    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, Species species, int soilLife, boolean natural) {
        if (TreeHelper.getRadius((IBlockAccess)world, (BlockPos)rootPos.func_177984_a()) >= this.fruitingRadius && natural && world.field_73012_v.nextInt() % 16 == 0 && species.seasonalFruitProductionFactor(world, rootPos) > world.field_73012_v.nextFloat()) {
            this.addFruit(world, rootPos, this.getLeavesHeight(rootPos, world).func_177979_c(this.getRandPosition(world)), false);
        }
        return false;
    }

    private BlockPos getLeavesHeight(BlockPos rootPos, World world) {
        for (int y = 1; y < this.frondHeight; ++y) {
            BlockPos testPos = rootPos.func_177981_b(y);
            if (!(world.func_180495_p(testPos).func_177230_c() instanceof BlockLeaves)) continue;
            return testPos;
        }
        return rootPos;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        boolean placed = false;
        int qty = 8;
        qty = (int)((float)qty * species.seasonalFruitProductionFactor(world, rootPos));
        for (int i = 0; i < qty; ++i) {
            if (world.field_73012_v.nextInt(4) != 0) continue;
            this.addFruit(world, rootPos, this.getLeavesHeight(rootPos, world).func_177979_c(this.getRandPosition(world)), true);
            placed = true;
        }
        return placed;
    }

    private void addFruit(World world, BlockPos rootPos, BlockPos leavesPos, boolean worldGen) {
        if (rootPos.func_177956_o() == leavesPos.func_177956_o()) {
            return;
        }
        if (this.isSided) {
            EnumFacing placeDir = EnumFacing.field_176754_o[world.field_73012_v.nextInt(4)];
            if (world.func_175623_d((leavesPos = leavesPos.func_177977_b()).func_177972_a(placeDir))) {
                world.func_175656_a(leavesPos.func_177972_a(placeDir), this.fruitPod.func_176223_P().func_177226_a((IProperty)BlockPamFruitPalm.FACING, (Comparable)placeDir.func_176734_d()).func_177226_a((IProperty)BlockPamFruitPalm.AGE, (Comparable)Integer.valueOf(worldGen ? 1 + world.field_73012_v.nextInt(3) : 0)));
            }
        } else {
            CoordUtils.Surround placeDir = CoordUtils.Surround.values()[world.field_73012_v.nextInt(8)];
            if (world.func_175623_d(leavesPos.func_177971_a(placeDir.getOffset()))) {
                world.func_175656_a(leavesPos.func_177971_a(placeDir.getOffset()), this.fruitPod.func_176223_P().func_177226_a((IProperty)BlockPamFruit.AGE, (Comparable)Integer.valueOf(worldGen ? 1 + world.field_73012_v.nextInt(3) : 0)));
            }
        }
    }
}

