/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.positional;

import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public interface ICoords {
    public BlockPos toPos();

    public ChunkPos toChunkPos();

    public int get(int var1);

    public int get(char var1);

    public int getX();

    public int getY();

    public int getZ();

    public int hashCode();

    public boolean equals(Object var1);

    public String toString();

    public ICoords add(int var1, int var2, int var3);

    public ICoords add(ICoords var1);

    public ICoords delta(ICoords var1);

    public ICoords rotate90(int var1);

    public ICoords rotate180(int var1, int var2);

    public ICoords rotate270(int var1);

    public String toShortString();

    public double getDistanceSq(double var1, double var3, double var5);

    public double getDistanceSq(ICoords var1);

    public double getDistance(double var1, double var3, double var5);

    public double getDistance(ICoords var1);

    public double getXZAngle(double var1, double var3);

    public double getXZAngle(ICoords var1);

    public ICoords up(int var1);

    public ICoords down(int var1);

    public ICoords north(int var1);

    public ICoords south(int var1);

    public ICoords east(int var1);

    public ICoords west(int var1);

    public ICoords resetY(int var1);

    public ICoords resetZ(int var1);

    public ICoords resetX(int var1);

    public static ICoords readFromNBT(NBTTagCompound nbt) {
        Integer x = null;
        Integer y = null;
        Integer z = null;
        Coords coords = null;
        if (nbt.func_74764_b("x")) {
            x = nbt.func_74762_e("x");
        }
        if (nbt.func_74764_b("y")) {
            y = nbt.func_74762_e("y");
        }
        if (nbt.func_74764_b("z")) {
            z = nbt.func_74762_e("z");
        }
        if (x != null && y != null && z != null) {
            coords = new Coords(x, y, z);
        }
        return coords;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound var1);

    public ICoords add(Direction var1, int var2);

    public ICoords rotate(double var1, double var3, double var5);

    public ICoords offset(EnumFacing var1);

    public ICoords offset(EnumFacing var1, int var2);

    public ICoords withY(ICoords var1);

    public ICoords withY(int var1);

    public ICoords withX(ICoords var1);

    public ICoords withX(int var1);

    public ICoords withZ(ICoords var1);

    public ICoords withZ(int var1);
}

