/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import com.someguyssoftware.gottschcore.loot.functions.LootFunction;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.RandomValueRange;

public class SetAttributes
extends LootFunction {
    private final Modifier[] modifiers;

    public SetAttributes(LootCondition[] conditionsIn, Modifier[] modifiersIn) {
        super(conditionsIn);
        this.modifiers = modifiersIn;
    }

    @Override
    public ItemStack apply(ItemStack stack, Random rand, LootContext context) {
        for (Modifier setattributes$modifier : this.modifiers) {
            UUID uuid = setattributes$modifier.uuid;
            if (uuid == null) {
                uuid = UUID.randomUUID();
            }
            EntityEquipmentSlot entityequipmentslot = setattributes$modifier.slots[rand.nextInt(setattributes$modifier.slots.length)];
            stack.func_185129_a(setattributes$modifier.attributeName, new AttributeModifier(uuid, setattributes$modifier.modifierName, (double)setattributes$modifier.amount.func_186507_b(rand), setattributes$modifier.operation), entityequipmentslot);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetAttributes> {
        public Serializer() {
            super(new ResourceLocation("set_attributes"), SetAttributes.class);
        }

        @Override
        public void serialize(JsonObject object, SetAttributes functionClazz, JsonSerializationContext serializationContext) {
            JsonArray jsonarray = new JsonArray();
            for (Modifier setattributes$modifier : functionClazz.modifiers) {
                jsonarray.add((JsonElement)setattributes$modifier.serialize(serializationContext));
            }
            object.add("modifiers", (JsonElement)jsonarray);
        }

        @Override
        public SetAttributes deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)object, (String)"modifiers");
            Modifier[] asetattributes$modifier = new Modifier[jsonarray.size()];
            int i = 0;
            for (JsonElement jsonelement : jsonarray) {
                asetattributes$modifier[i++] = Modifier.deserialize(JsonUtils.func_151210_l((JsonElement)jsonelement, (String)"modifier"), deserializationContext);
            }
            if (asetattributes$modifier.length == 0) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new SetAttributes(conditionsIn, asetattributes$modifier);
        }
    }

    static class Modifier {
        private final String modifierName;
        private final String attributeName;
        private final int operation;
        private final RandomValueRange amount;
        @Nullable
        private final UUID uuid;
        private final EntityEquipmentSlot[] slots;

        private Modifier(String modifName, String attrName, int operationIn, RandomValueRange randomAmount, EntityEquipmentSlot[] slotsIn, @Nullable UUID uuidIn) {
            this.modifierName = modifName;
            this.attributeName = attrName;
            this.operation = operationIn;
            this.amount = randomAmount;
            this.uuid = uuidIn;
            this.slots = slotsIn;
        }

        public JsonObject serialize(JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("name", this.modifierName);
            jsonobject.addProperty("attribute", this.attributeName);
            jsonobject.addProperty("operation", Modifier.getOperationFromStr(this.operation));
            jsonobject.add("amount", context.serialize((Object)this.amount));
            if (this.uuid != null) {
                jsonobject.addProperty("id", this.uuid.toString());
            }
            if (this.slots.length == 1) {
                jsonobject.addProperty("slot", this.slots[0].func_188450_d());
            } else {
                JsonArray jsonarray = new JsonArray();
                for (EntityEquipmentSlot entityequipmentslot : this.slots) {
                    jsonarray.add((JsonElement)new JsonPrimitive(entityequipmentslot.func_188450_d()));
                }
                jsonobject.add("slot", (JsonElement)jsonarray);
            }
            return jsonobject;
        }

        public static Modifier deserialize(JsonObject jsonObj, JsonDeserializationContext context) {
            EntityEquipmentSlot[] aentityequipmentslot;
            String s = JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"name");
            String s1 = JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"attribute");
            int i = Modifier.getOperationFromInt(JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"operation"));
            RandomValueRange randomvaluerange = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)jsonObj, (String)"amount", (JsonDeserializationContext)context, RandomValueRange.class);
            UUID uuid = null;
            if (JsonUtils.func_151205_a((JsonObject)jsonObj, (String)"slot")) {
                aentityequipmentslot = new EntityEquipmentSlot[]{EntityEquipmentSlot.func_188451_a((String)JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"slot"))};
            } else {
                if (!JsonUtils.func_151202_d((JsonObject)jsonObj, (String)"slot")) {
                    throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
                }
                JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)jsonObj, (String)"slot");
                aentityequipmentslot = new EntityEquipmentSlot[jsonarray.size()];
                int j = 0;
                for (JsonElement jsonelement : jsonarray) {
                    aentityequipmentslot[j++] = EntityEquipmentSlot.func_188451_a((String)JsonUtils.func_151206_a((JsonElement)jsonelement, (String)"slot"));
                }
                if (aentityequipmentslot.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            }
            if (jsonObj.has("id")) {
                String s2 = JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"id");
                try {
                    uuid = UUID.fromString(s2);
                }
                catch (IllegalArgumentException var12) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + s2 + "' (must be UUID format, with dashes)");
                }
            }
            return new Modifier(s, s1, i, randomvaluerange, aentityequipmentslot, uuid);
        }

        private static String getOperationFromStr(int operationIn) {
            switch (operationIn) {
                case 0: {
                    return "addition";
                }
                case 1: {
                    return "multiply_base";
                }
                case 2: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException("Unknown operation " + operationIn);
        }

        private static int getOperationFromInt(String operationIn) {
            if ("addition".equals(operationIn)) {
                return 0;
            }
            if ("multiply_base".equals(operationIn)) {
                return 1;
            }
            if ("multiply_total".equals(operationIn)) {
                return 2;
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + operationIn);
        }
    }
}

