/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.loot;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.loot.LootContext;
import com.someguyssoftware.gottschcore.loot.LootEntry;
import com.someguyssoftware.gottschcore.loot.LootPool;
import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.loot.conditions.LootCondition;
import com.someguyssoftware.gottschcore.loot.conditions.LootConditionManager;
import com.someguyssoftware.gottschcore.loot.functions.LootFunction;
import com.someguyssoftware.gottschcore.loot.functions.LootFunctionManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LootTableManager {
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private final LoadingCache<ResourceLocation, LootTable> registeredLootTables = CacheBuilder.newBuilder().build((CacheLoader)new Loader());
    private final File baseFolder;
    private static ThreadLocal<Deque<LootTableContext>> lootContext = new ThreadLocal();

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could not grab json context!");
        }
        return ctx;
    }

    public LootTableManager(File folder) {
        this.baseFolder = folder;
    }

    public LootTable getLootTableFromLocation(ResourceLocation location) {
        return (LootTable)this.registeredLootTables.getUnchecked((Object)location);
    }

    public void reloadLootTables() {
        this.registeredLootTables.invalidateAll();
        for (ResourceLocation resourcelocation : LootTableList.func_186374_a()) {
            this.getLootTableFromLocation(resourcelocation);
        }
    }

    @Nullable
    public static LootTable loadLootTable(Gson gson, ResourceLocation name, String data, boolean custom, LootTableManager lootTableManager) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        LootTable ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (LootTable)gson.fromJson(data, LootTable.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = LootTableManager.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(JsonUtils.func_151200_h((JsonObject)json, (String)"entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
        } else if ("loot_table".equals(type)) {
            name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static LootEntry deserializeJsonLootEntry(String type, JsonObject json, int weight, int quality, LootCondition[] conditions) {
        return null;
    }

    public static String getLootEntryType(LootEntry entry) {
        return null;
    }

    public static int getLootingLevel(Entity target, @Nullable Entity killer, DamageSource cause) {
        int looting = 0;
        if (killer instanceof EntityLivingBase) {
            looting = EnchantmentHelper.func_185283_h((EntityLivingBase)((EntityLivingBase)killer));
        }
        if (target instanceof EntityLivingBase) {
            looting = LootTableManager.getLootingLevel((EntityLivingBase)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(EntityLivingBase target, DamageSource cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getLootingLevel();
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = LootTableManager.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return JsonUtils.func_151200_h((JsonObject)json, (String)"name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static Gson getGsonInstance() {
        return GSON_INSTANCE;
    }

    private static class LootTableContext {
        public final ResourceLocation name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(ResourceLocation name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.func_110624_b());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(@Nullable String name) {
            if (name != null && !this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x = 0;
            while (this.entryNames.contains(name + "#" + x)) {
                ++x;
            }
            name = name + "#" + x;
            this.entryNames.add(name);
            return name;
        }
    }

    class Loader
    extends CacheLoader<ResourceLocation, LootTable> {
        private Loader() {
        }

        public LootTable load(ResourceLocation location) throws Exception {
            if (location.func_110623_a().contains(".")) {
                GottschCore.logger.debug("Invalid loot table name '{}' (can't contain periods)", (Object)location);
                return null;
            }
            GottschCore.logger.debug("loading loot table from location -> {}", (Object)location);
            LootTable loottable = this.loadLootTable(location);
            if (loottable == null) {
                GottschCore.logger.debug("custom location null, loading loot table from builtin -> {}", (Object)location);
                loottable = this.loadBuiltinLootTable(location);
            }
            if (loottable == null) {
                loottable = LootTable.EMPTY_LOOT_TABLE;
                GottschCore.logger.warn("Couldn't find resource table {}", (Object)location);
            }
            return loottable;
        }

        @Nullable
        private LootTable loadLootTable(ResourceLocation resource) {
            if (LootTableManager.this.baseFolder == null) {
                return null;
            }
            File file1 = new File(new File(LootTableManager.this.baseFolder, resource.func_110624_b()), resource.func_110623_a() + ".json");
            if (file1.exists()) {
                if (file1.isFile()) {
                    String s;
                    try {
                        s = Files.toString((File)file1, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException ioexception) {
                        GottschCore.logger.warn("Couldn't load loot table {} from {}", (Object)resource, (Object)file1, (Object)ioexception);
                        return LootTable.EMPTY_LOOT_TABLE;
                    }
                    try {
                        return LootTableManager.loadLootTable(GSON_INSTANCE, resource, s, true, LootTableManager.this);
                    }
                    catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                        GottschCore.logger.error("Couldn't load loot table {} from {}", (Object)resource, (Object)file1, (Object)jsonparseexception);
                        return LootTable.EMPTY_LOOT_TABLE;
                    }
                }
                GottschCore.logger.warn("Expected to find loot table {} at {} but it was a folder.", (Object)resource, (Object)file1);
                return LootTable.EMPTY_LOOT_TABLE;
            }
            return null;
        }

        @Nullable
        private LootTable loadBuiltinLootTable(ResourceLocation resource) {
            URL url = LootTableManager.class.getResource("/assets/" + resource.func_110624_b() + "/loot_tables/" + resource.func_110623_a() + ".json");
            if (url != null) {
                String s;
                try {
                    s = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException ioexception) {
                    GottschCore.logger.warn("Couldn't load loot table {} from {}", (Object)resource, (Object)url, (Object)ioexception);
                    return LootTable.EMPTY_LOOT_TABLE;
                }
                try {
                    return LootTableManager.loadLootTable(GSON_INSTANCE, resource, s, false, LootTableManager.this);
                }
                catch (JsonParseException jsonparseexception) {
                    GottschCore.logger.error("Couldn't load loot table {} from {}", (Object)resource, (Object)url, (Object)jsonparseexception);
                    return LootTable.EMPTY_LOOT_TABLE;
                }
            }
            return null;
        }
    }
}

