/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.enums;

import com.someguyssoftware.gottschcore.enums.IEnum;
import com.someguyssoftware.gottschcore.enums.IRarity;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Rarity implements IRarity
{
    COMMON(0, "common"),
    UNCOMMON(1, "uncommon"),
    SCARCE(2, "scarce"),
    RARE(3, "rare"),
    EPIC(4, "epic"),
    BOSS(5, "boss"),
    UNIQUE(99, "unique");

    private static final Map<Integer, IEnum> codes;
    private static final Map<String, IEnum> values;
    private Integer code;
    private String value;

    private Rarity(int code, String value) {
        this.code = code;
        this.value = value;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Map<Integer, IEnum> getCodes() {
        return codes;
    }

    @Override
    public Map<String, IEnum> getValues() {
        return values;
    }

    static {
        codes = new HashMap<Integer, IEnum>();
        values = new HashMap<String, IEnum>();
        for (Rarity ps : EnumSet.allOf(Rarity.class)) {
            codes.put(ps.getCode(), ps);
            values.put(ps.getValue(), ps);
        }
    }
}

