/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc.trees.species;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreestc.featuregen.FeatureGenVishroom;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.world.biomes.BiomeHandler;

public class SpeciesOakMagic
extends Species {
    public SpeciesOakMagic(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreestc", treeFamily.getName().func_110623_a() + "magic"), treeFamily);
        this.setRequiresTileEntity(true);
        this.setBasicGrowingParameters(0.3f, 14.0f, 4, 4, 1.25f);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.setupStandardSeedDropping();
        this.addGenFeature((IGenFeature)new FeatureGenVishroom());
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesOakMagic.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{BiomeHandler.MAGICAL_FOREST});
    }

    public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
        return super.isAcceptableSoil(world, pos, soilBlockState) || soilBlockState.func_177230_c() instanceof BlockDirt || soilBlockState.func_177230_c() instanceof BlockGrass;
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, BlocksTC.vishroom.func_176223_P());
            }
            return true;
        }
        return false;
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public boolean isThick() {
        return false;
    }
}

