/*
 * Decompiled with CFR 0.152.
 */
package dynamictreestc.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorSeed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenGroup;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenPredicate;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreestc.ModContent;
import dynamictreestc.featuregen.FeatureGenDungeonChest;
import dynamictreestc.featuregen.FeatureGenMobSpawner;
import dynamictreestc.featuregen.FeatureGenVishroom;
import dynamictreestc.featuregen.FeatureGenWeb;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.world.biomes.BiomeHandler;

public class TreeGreatwood
extends TreeFamily {
    BlockSurfaceRoot surfaceRootBlock;

    public TreeGreatwood() {
        super(new ResourceLocation("dynamictreestc", "greatwood"));
        IBlockState primLog = BlocksTC.logGreatwood.func_176223_P();
        this.setPrimitiveLog(primLog, new ItemStack(BlocksTC.logGreatwood));
        ModContent.greatwoodLeavesProperties.setTree((TreeFamily)this);
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == BlocksTC.leafGreatwood);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesGreatwood(this));
    }

    public boolean isThick() {
        return true;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public class SpeciesGreatwood
    extends Species {
        SpeciesGreatwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.greatwoodLeavesProperties);
            this.setBasicGrowingParameters(0.5f, 22.0f, 8, 7, 1.25f);
            this.setSoilLongevity(14);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.envFactor(BiomeDictionary.Type.MAGICAL, 1.1f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorSeed(0.25f){

                public List<ItemStack> getHarvestDrop(World world, Species species, BlockPos leafPos, Random random, List<ItemStack> dropList, int soilLife, int fortune) {
                    int chance = 150;
                    if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                        chance = 10;
                    }
                    if (random.nextInt(chance) == 0) {
                        dropList.add(species.getSeedStack(1));
                    }
                    return dropList;
                }

                public List<ItemStack> getLeavesDrop(IBlockAccess access, Species species, BlockPos breakPos, Random random, List<ItemStack> dropList, int fortune) {
                    int chance = 176;
                    if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                        chance = 10;
                    }
                    if (random.nextInt(chance) == 0) {
                        dropList.add(species.getSeedStack(1));
                    }
                    return dropList;
                }
            });
            Random rand = new Random();
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            this.addGenFeature((IGenFeature)new FeatureGenMound(5));
            this.addGenFeature((IGenFeature)new FeatureGenVishroom().setMaxAttempts(3).setChance(3));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(13).setScaler(this.getRootScaler()));
            this.addGenFeature((IGenFeature)new FeatureGenPredicate((IPostGenFeature)new FeatureGenGroup().add((IPostGenFeature)new FeatureGenMobSpawner(EntityCaveSpider.class, 1)).add((IPostGenFeature)new FeatureGenDungeonChest(2)).add((IPostGenFeature)new FeatureGenWeb(this))).onlyWorldGen(true).setBiomePredicate(biome -> rand.nextInt(biome == BiomeHandler.MAGICAL_FOREST ? 56 : 12) == 0));
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesGreatwood.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{BiomeHandler.MAGICAL_FOREST});
        }

        public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
            return super.isAcceptableSoil(world, pos, soilBlockState) || soilBlockState.func_177230_c() instanceof BlockDirt || soilBlockState.func_177230_c() instanceof BlockGrass;
        }

        public int getReinfTravel() {
            return 3;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy *= 1.25f;
                if (signal.energy > 7.0f) {
                    signal.energy = 7.0f;
                }
            }
            return newDir;
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 13 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, BlocksTC.vishroom.func_176223_P());
                }
                return true;
            }
            return false;
        }

        public boolean isThick() {
            return true;
        }
    }
}

