/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker.praescriptum;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.ingredients.output.ItemStackOutputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.recipe.Recipes;
import techreborn.compatmod.crafttweaker.ZenDocumentation;
import techreborn.compatmod.crafttweaker.praescriptum.CTPraescriptumRecipe;

@ZenClass(value="mods.techreborn.solidCanningMachine")
public class CTSolidCanningMachine
extends CTPraescriptumRecipe {
    @ZenMethod
    @ZenDocumentation(value="IItemStack output, IIngredient ingredientA, IIngredient ingredientB, int tickTime, int energyCostPerTick")
    public static void addRecipe(IItemStack output, IIngredient ingredientA, IIngredient ingredientB, int operationDuration, int energyCostPerTick) {
        ItemStackInputIngredient inputA = ingredientA instanceof IItemStack ? ItemStackInputIngredient.of((ItemStack)ItemUtils.copyWithSize((ItemStack)CraftTweakerMC.getItemStack((IIngredient)ingredientA), (int)ingredientA.getAmount())) : OreDictionaryInputIngredient.of((String)((IOreDictEntry)ingredientA).getName(), (int)ingredientA.getAmount());
        ItemStackInputIngredient inputB = ingredientB instanceof IItemStack ? ItemStackInputIngredient.of((ItemStack)ItemUtils.copyWithSize((ItemStack)CraftTweakerMC.getItemStack((IIngredient)ingredientB), (int)ingredientB.getAmount())) : OreDictionaryInputIngredient.of((String)((IOreDictEntry)ingredientB).getName(), (int)ingredientB.getAmount());
        Recipe recipe = CTSolidCanningMachine.getRecipeHandler().createRecipe().withInput((Collection)ImmutableList.of((Object)inputA, (Object)inputB)).withOutput(CraftTweakerMC.getItemStack((IItemStack)output)).withEnergyCostPerTick(energyCostPerTick).withOperationDuration(operationDuration);
        CTSolidCanningMachine.add(recipe);
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack output")
    public static void removeRecipe(IItemStack output) {
        ItemStack outStack = CraftTweakerMC.getItemStack((IItemStack)output);
        Recipe recipe = CTSolidCanningMachine.getRecipeHandler().getRecipeByOutput(Collections.singleton(ItemStackOutputIngredient.of((ItemStack)outStack)));
        if (recipe != null) {
            CTSolidCanningMachine.getRecipeHandler().removeRecipe(recipe);
        }
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack ingredientA, IItemStack ingredientB")
    public static void removeInputRecipe(IItemStack ingredientA, IItemStack ingredientB) {
        ItemStack inputA = CraftTweakerMC.getItemStack((IItemStack)ingredientA);
        ItemStack inputB = CraftTweakerMC.getItemStack((IItemStack)ingredientB);
        Recipe recipe = CTSolidCanningMachine.getRecipeHandler().findRecipe((Collection)Lists.newArrayList((Object[])new ItemStack[]{inputA, inputB}));
        if (recipe != null) {
            CTSolidCanningMachine.getRecipeHandler().removeRecipe(recipe);
        }
    }

    @ZenMethod
    public static void removeAll() {
        CTSolidCanningMachine.removeAll(CTSolidCanningMachine.getRecipeHandler());
    }

    public static RecipeHandler getRecipeHandler() {
        return Recipes.solidCanningMachine;
    }
}

