/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.advanced;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.conduits.render.BakedQuadBuilder;
import crazypants.enderio.conduits.render.ConduitBundleRenderManager;
import crazypants.enderio.conduits.render.ConduitInOutRenderer;
import crazypants.enderio.conduits.render.DefaultConduitRenderer;
import gg.galaxygaming.gasconduits.client.utils.GasRenderUtil;
import gg.galaxygaming.gasconduits.common.conduit.advanced.AdvancedGasConduit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;

public class AdvancedGasConduitRenderer
extends DefaultConduitRenderer {
    public boolean isRendererForConduit(@Nonnull IConduit conduit) {
        return conduit instanceof AdvancedGasConduit;
    }

    public boolean canRenderInLayer(@Nonnull IClientConduit.WithDefaultRendering con, @Nonnull BlockRenderLayer layer) {
        return super.canRenderInLayer(con, layer) || layer == BlockRenderLayer.CUTOUT;
    }

    protected void addConduitQuads(@Nonnull IConduitBundle bundle, @Nonnull IClientConduit conduit, @Nonnull IConduitTexture tex, @Nonnull CollidableComponent component, float selfIllum, BlockRenderLayer layer, @Nonnull List<BakedQuad> quads) {
        super.addConduitQuads(bundle, conduit, tex, component, selfIllum, layer, quads);
        ConduitInOutRenderer.renderIO((IConduitBundle)bundle, (IClientConduit)conduit, (CollidableComponent)component, (BlockRenderLayer)layer, quads, (DyeColor)DyeColor.RED, (DyeColor)DyeColor.RED);
        if (component.isCore() || component.data != null) {
            return;
        }
        AdvancedGasConduit lc = (AdvancedGasConduit)conduit;
        GasStack gas = lc.getGasType();
        TextureAtlasSprite texture = gas != null && gas.getGas() != null && gas.amount > 0 ? GasRenderUtil.getStillTexture(gas) : lc.getNotSetEdgeTexture();
        float shrink = 0.03125f;
        EnumFacing componentDirection = component.getDirection();
        float xLen = Math.abs(componentDirection.func_82601_c()) == 1 ? 0.0f : shrink;
        float yLen = Math.abs(componentDirection.func_96559_d()) == 1 ? 0.0f : shrink;
        float zLen = Math.abs(componentDirection.func_82599_e()) == 1 ? 0.0f : shrink;
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.expand((double)(-xLen), (double)(-yLen), (double)(-zLen));
        ArrayList vertices = new ArrayList();
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            if (dir == componentDirection || dir == componentDirection.func_176734_d()) continue;
            EnumFacing vDir = RenderUtil.getVDirForFace((EnumFacing)dir);
            if (componentDirection == EnumFacing.UP || componentDirection == EnumFacing.DOWN) {
                vDir = RenderUtil.getUDirForFace((EnumFacing)dir);
            } else if ((componentDirection == EnumFacing.NORTH || componentDirection == EnumFacing.SOUTH) && dir.func_96559_d() != 0) {
                vDir = RenderUtil.getUDirForFace((EnumFacing)dir);
            }
            float minU = texture.func_94209_e();
            float maxU = texture.func_94212_f();
            float minV = texture.func_94206_g();
            float maxV = texture.func_94210_h();
            double sideScale = Math.max(bb.sizeX(), bb.sizeY()) * 2.0 / 16.0;
            sideScale = Math.max(sideScale, bb.sizeZ() * 2.0 / 16.0);
            double width = Math.min(bb.sizeX(), bb.sizeY()) * 15.0 / 16.0;
            NNList corners = bb.getCornersWithUvForFace(dir, minU, maxU, minV, maxV);
            this.moveEdgeCorners((List<Vertex>)corners, vDir, width);
            this.moveEdgeCorners((List<Vertex>)corners, componentDirection.func_176734_d(), sideScale);
            vertices.addAll(corners);
            corners = bb.getCornersWithUvForFace(dir, minU, maxU, minV, maxV);
            this.moveEdgeCorners((List<Vertex>)corners, vDir.func_176734_d(), width);
            this.moveEdgeCorners((List<Vertex>)corners, componentDirection.func_176734_d(), sideScale);
            vertices.addAll(corners);
        }
        BakedQuadBuilder.addBakedQuads(quads, vertices, (TextureAtlasSprite)texture, null);
        if (conduit.getConnectionMode(component.getDirection()) == ConnectionMode.DISABLED) {
            TextureAtlasSprite tex2 = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
            NNList corners = component.bound.getCornersWithUvForFace(component.getDirection(), tex2.func_94209_e(), tex2.func_94212_f(), tex2.func_94206_g(), tex2.func_94210_h());
            ArrayList<Vertex> vertices2 = new ArrayList<Vertex>((Collection<Vertex>)corners);
            for (int i = corners.size() - 1; i >= 0; --i) {
                Vertex c = (Vertex)corners.get(i);
                vertices2.add(c);
            }
            BakedQuadBuilder.addBakedQuads(quads, vertices2, (TextureAtlasSprite)tex2, null);
        }
    }

    private void moveEdgeCorners(List<Vertex> vertices, EnumFacing edge, double scaleFactor) {
        int[] indices = this.getClosest(edge, vertices);
        vertices.get((int)indices[0]).xyz.x -= scaleFactor * (double)edge.func_82601_c();
        vertices.get((int)indices[1]).xyz.x -= scaleFactor * (double)edge.func_82601_c();
        vertices.get((int)indices[0]).xyz.y -= scaleFactor * (double)edge.func_96559_d();
        vertices.get((int)indices[1]).xyz.y -= scaleFactor * (double)edge.func_96559_d();
        vertices.get((int)indices[0]).xyz.z -= scaleFactor * (double)edge.func_82599_e();
        vertices.get((int)indices[1]).xyz.z -= scaleFactor * (double)edge.func_82599_e();
    }

    private int[] getClosest(EnumFacing edge, List<Vertex> vertices) {
        int[] res = new int[]{-1, -1};
        boolean highest = edge.func_82601_c() > 0 || edge.func_96559_d() > 0 || edge.func_82599_e() > 0;
        double minMax = highest ? -1.7976931348623157E308 : Double.MAX_VALUE;
        int index = 0;
        for (Vertex v : vertices) {
            double val = this.get(v.xyz, edge);
            if (highest ? val >= minMax : val <= minMax) {
                if (val != minMax) {
                    res[0] = index;
                } else {
                    res[1] = index;
                }
                minMax = val;
            }
            ++index;
        }
        return res;
    }

    private double get(Vector3d xyz, EnumFacing edge) {
        if (edge == EnumFacing.EAST || edge == EnumFacing.WEST) {
            return xyz.x;
        }
        if (edge == EnumFacing.UP || edge == EnumFacing.DOWN) {
            return xyz.y;
        }
        return xyz.z;
    }
}

