/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.size;

import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.SidedHandler;
import dev.necauqua.mods.cm.api.ISizedEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public final class EntitySizeInteractions {
    private static final String NBT_KEY_SIZE = "chiseled_me:size";
    private static final EntityPlayer.SleepResult TOO_SMALL = EnumHelper.addStatus((String)"TOO_SMALL");
    private static final EntityPlayer.SleepResult TOO_BIG = EnumHelper.addStatus((String)"TOO_BIG");

    private EntitySizeInteractions() {
    }

    @ChiseledMe.Init
    private static void fixBedAABB() {
        if (!Config.changeBedAABB) {
            return;
        }
        try {
            EnumHelper.setFailsafeFieldValue((Field)ObfuscationReflectionHelper.findField(BlockBed.class, (String)"field_185513_c"), null, (Object)new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 0.5625, 1.0));
        }
        catch (Exception e) {
            Log.error("Failed to modify bed AABB!", e);
        }
    }

    @SubscribeEvent
    public static void on(PlayerInteractEvent.EntityInteractSpecific e) {
        if (((ISizedEntity)e.getEntity()).getSizeCM() != ((ISizedEntity)e.getTarget()).getSizeCM()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void on(EntityMountEvent e) {
        if (e.isMounting() && (((ISizedEntity)e.getEntityMounting()).getSizeCM() != 1.0 || ((ISizedEntity)e.getEntityBeingMounted()).getSizeCM() != 1.0)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void on(PlayerSleepInBedEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        double size = ((ISizedEntity)player).getSizeCM();
        if (size < 1.0) {
            e.setResult(TOO_SMALL);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_small", new Object[0]));
        } else if (size > 1.0) {
            e.setResult(TOO_BIG);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_big", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void on(LivingDropsEvent e) {
        double size = ((ISizedEntity)e.getEntity()).getSizeCM();
        if (size == 1.0) {
            return;
        }
        for (EntityItem item : e.getDrops()) {
            ((ISizedEntity)item).setSizeCM(size, 0);
        }
    }

    @SubscribeEvent
    public static void on(ItemTossEvent e) {
        double size = ((ISizedEntity)e.getPlayer()).getSizeCM();
        if (size != 1.0) {
            ((ISizedEntity)e.getEntity()).setSizeCM(size, 0);
        }
    }

    @SubscribeEvent
    public static void on(BlockEvent.HarvestDropsEvent e) {
        EntityPlayer player = e.getHarvester();
        if (player == null) {
            return;
        }
        double size = ((ISizedEntity)player).getSizeCM();
        if (size == 1.0) {
            return;
        }
        for (ItemStack stack : e.getDrops()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74780_a(NBT_KEY_SIZE, size);
            stack.func_77982_d(nbt);
        }
    }

    private static void applyDefaultSize(Entity entity, String entitySizeRule) {
        try {
            double size = MathHelper.func_151237_a((double)Double.parseDouble(entity.field_70170_p.func_82736_K().func_82767_a(entitySizeRule)), (double)2.44140625E-4, (double)16.0);
            if (size != 1.0 && ((ISizedEntity)entity).getSizeCM() == 1.0) {
                ((ISizedEntity)entity).setSizeCM(size);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void on(EntityJoinWorldEvent e) {
        EntityLivingBase thrower;
        Entity entity = e.getEntity();
        if (entity instanceof EntityPlayer) {
            EntitySizeInteractions.applyDefaultSize(entity, "chiseled_me:defaultPlayerSize");
        } else {
            EntitySizeInteractions.applyDefaultSize(entity, "chiseled_me:defaultEntitySize");
        }
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_150297_b(NBT_KEY_SIZE, 6)) {
                ((ISizedEntity)entity).setSizeCM(nbt.func_74769_h(NBT_KEY_SIZE), 0);
                nbt.func_82580_o(NBT_KEY_SIZE);
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            return;
        }
        if (entity instanceof EntityThrowable) {
            thrower = ((EntityThrowable)entity).func_85052_h();
        } else if (entity instanceof EntityArrow) {
            thrower = ((EntityArrow)entity).field_70250_c;
        } else if (entity instanceof EntityFireball) {
            thrower = ((EntityFireball)entity).field_70235_a;
        } else if (entity instanceof IThrowableEntity) {
            thrower = ((IThrowableEntity)entity).getThrower();
        } else {
            return;
        }
        if (thrower == null) {
            return;
        }
        double size = ((ISizedEntity)thrower).getSizeCM();
        if (size != 1.0) {
            ((ISizedEntity)entity).setSizeCM(size);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void on(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed((float)((double)e.getNewSpeed() * ((ISizedEntity)e.getEntity()).getSizeCM()));
    }

    @SubscribeEvent
    public static void on(RenderGameOverlayEvent.Text e) {
        ArrayList list;
        EntityPlayer player = SidedHandler.instance.getClientPlayer();
        if (player == null) {
            return;
        }
        double size = ((ISizedEntity)player).getSizeCM();
        if (size != 1.0 && (list = e.getLeft()).size() >= 3) {
            list.add(list.size() - 3, String.format("Size: %f", size));
        }
    }

    @SubscribeEvent
    public static void on(BabyEntitySpawnEvent e) {
        double size = ((ISizedEntity)e.getParentA()).getSizeCM();
        EntityAgeable child = e.getChild();
        if (child != null && size != 1.0) {
            ((ISizedEntity)child).setSizeCM(size, 0);
        }
    }

    public static void wakeUp(Entity entity) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_70999_a(true, !entity.field_70170_p.field_72995_K, true);
        }
    }

    public static int[] appendSize(int[] array, double d) {
        if (d == 1.0) {
            return array;
        }
        int[] modified = Arrays.copyOf(array, array.length + 2);
        long bits = Double.doubleToRawLongBits(d);
        modified[array.length] = (int)(bits >> 32);
        modified[array.length + 1] = (int)bits;
        return modified;
    }
}

