/*
 * Decompiled with CFR 0.152.
 */
package familiarfauna.entities;

import familiarfauna.api.FFItems;
import familiarfauna.api.FFSounds;
import familiarfauna.config.ConfigurationHandler;
import familiarfauna.core.FamiliarFauna;
import familiarfauna.init.ModLootTable;
import familiarfauna.item.ItemBugHabitat;
import familiarfauna.particle.FFParticleTypes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityPixie
extends EntityAmbientCreature
implements EntityFlying {
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityPixie.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityPixie(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
        this.field_70765_h = new PixieMoveHelper();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIPixieRandomFly());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return FFSounds.pixie_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FFSounds.pixie_hurt;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTable.PIXIE_LOOT;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == FFItems.bug_net && !player.field_71075_bZ.field_75098_d && !this.func_70631_g_()) {
            ItemStack emptyHabitat = EntityPixie.findEmptyHabitatStack(player);
            if (emptyHabitat != ItemStack.field_190927_a) {
                player.func_184609_a(hand);
                emptyHabitat.func_190918_g(1);
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                this.func_70106_y();
                ItemStack habitat = new ItemStack(FFItems.bug_habitat);
                habitat.func_77982_d(new NBTTagCompound());
                habitat.func_77978_p().func_74778_a("Bug", "pixie");
                if (this.func_95999_t() != "") {
                    habitat.func_77978_p().func_74778_a("Name", this.func_95999_t());
                }
                habitat.func_77978_p().func_74768_a("Type", this.getPixieType());
                if (!player.field_71071_by.func_70441_a(habitat)) {
                    player.func_71019_a(habitat, false);
                }
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return super.func_184645_a(player, hand);
    }

    @Nonnull
    public static ItemStack findEmptyHabitatStack(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!EntityPixie.isHabitatEmpty(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isHabitatEmpty(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBugHabitat) {
            return !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Bug");
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("PixieType", this.getPixieType());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setPixieType(tagCompund.func_74762_e("PixieType"));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.field_70146_Z.nextInt(3);
        boolean flag = false;
        if (livingdata instanceof PixieTypeData) {
            i = ((PixieTypeData)livingdata).typeData;
            flag = true;
        } else {
            livingdata = new PixieTypeData(i);
        }
        this.setPixieType(i);
        return livingdata;
    }

    public int getPixieType() {
        return ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue();
    }

    public void setPixieType(int pixieTypeId) {
        this.field_70180_af.func_187227_b(TYPE, (Object)((byte)pixieTypeId));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            FFParticleTypes particle = FFParticleTypes.PINK_PIXIE_TRAIL;
            switch (this.getPixieType()) {
                default: {
                    particle = FFParticleTypes.PINK_PIXIE_TRAIL;
                    break;
                }
                case 1: {
                    particle = FFParticleTypes.BLUE_PIXIE_TRAIL;
                    break;
                }
                case 2: {
                    particle = FFParticleTypes.PURPLE_PIXIE_TRAIL;
                }
            }
            FamiliarFauna.proxy.spawnParticle(particle, this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !ConfigurationHandler.pixieEnable) {
            this.func_70106_y();
        }
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (blockpos.func_177956_o() <= this.field_70170_p.func_181545_F()) {
            return false;
        }
        if (blockpos.func_177956_o() >= 90) {
            return false;
        }
        int light = this.field_70170_p.func_175671_l(blockpos);
        return light > 8 && super.func_70601_bi();
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    class AIPixieRandomFly
    extends EntityAIBase {
        private EntityPixie pixie;
        private PixieMoveTargetPos targetPos;

        public AIPixieRandomFly() {
            this.pixie = EntityPixie.this;
            this.targetPos = new PixieMoveTargetPos();
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !this.pixie.func_70605_aq().func_75640_a();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random rand = this.pixie.func_70681_au();
            if (this.tryGoingRandomDirection(rand, 6.0)) {
                return;
            }
            if (this.tryGoingRandomDirection(rand, 2.0)) {
                return;
            }
            List<EnumFacing> directions = Arrays.asList(EnumFacing.values());
            Collections.shuffle(directions);
            for (EnumFacing facing : directions) {
                if (!this.tryGoingAlongAxis(rand, facing, 1.0)) continue;
                return;
            }
        }

        public boolean tryGoingRandomDirection(Random rand, double maxDistance) {
            double dirX = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            double dirY = (rand.nextDouble() * 2.0 - 1.1) * maxDistance;
            double dirZ = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoingAlongAxis(Random rand, EnumFacing facing, double maxDistance) {
            double dirX = 0.0;
            double dirY = 0.0;
            double dirZ = 0.0;
            switch (facing.func_176740_k()) {
                case X: {
                    dirX = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                case Y: {
                    dirY = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                default: {
                    dirZ = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                }
            }
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoing(double dirX, double dirY, double dirZ) {
            this.targetPos.setTarget(this.pixie.field_70165_t + dirX, this.pixie.field_70163_u + dirY, this.pixie.field_70161_v + dirZ);
            boolean result = this.targetPos.isPathClear(5.0);
            if (result) {
                this.pixie.func_70605_aq().func_75642_a(this.targetPos.posX, this.targetPos.posY, this.targetPos.posZ, 1.0);
            }
            return result;
        }
    }

    class PixieMoveHelper
    extends EntityMoveHelper {
        private EntityPixie pixie;
        private int courseChangeCooldown;
        private double closeEnough;
        private PixieMoveTargetPos targetPos;

        public PixieMoveHelper() {
            super((EntityLiving)EntityPixie.this);
            this.pixie = EntityPixie.this;
            this.courseChangeCooldown = 0;
            this.closeEnough = 0.3;
            this.targetPos = new PixieMoveTargetPos();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            super.func_75642_a(x, y, z, speedIn);
            this.targetPos.setTarget(x, y, z);
        }

        public void func_75641_c() {
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                return;
            }
            if (this.courseChangeCooldown-- > 0) {
                return;
            }
            this.courseChangeCooldown += this.pixie.func_70681_au().nextInt(2) + 2;
            this.targetPos.refresh();
            double acceleration = 0.1;
            this.pixie.field_70159_w += this.targetPos.aimX * acceleration;
            this.pixie.field_70181_x += this.targetPos.aimY * acceleration;
            this.pixie.field_70179_y += this.targetPos.aimZ * acceleration;
            this.pixie.field_70761_aq = this.pixie.field_70177_z = -((float)Math.atan2(this.targetPos.distX, this.targetPos.distZ)) * 180.0f / (float)Math.PI;
            if (!this.targetPos.isPathClear(5.0)) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.targetPos.dist < this.closeEnough) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            }
        }
    }

    class PixieMoveTargetPos {
        private EntityPixie pixie;
        public double posX;
        public double posY;
        public double posZ;
        public double distX;
        public double distY;
        public double distZ;
        public double dist;
        public double aimX;
        public double aimY;
        public double aimZ;

        public PixieMoveTargetPos() {
            this(0.0, 0.0, 0.0);
        }

        public PixieMoveTargetPos(double posX, double posY, double posZ) {
            this.pixie = EntityPixie.this;
            this.setTarget(posX, posY, posZ);
        }

        public void setTarget(double posX, double posY, double posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.refresh();
        }

        public void refresh() {
            this.distX = this.posX - this.pixie.field_70165_t;
            this.distY = this.posY - this.pixie.field_70163_u;
            this.distZ = this.posZ - this.pixie.field_70161_v;
            this.dist = MathHelper.func_76133_a((double)(this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ));
            if (this.dist == 0.0) {
                this.aimX = 0.0;
                this.aimY = 0.0;
                this.aimZ = 0.0;
            } else {
                this.aimX = this.distX / this.dist;
                this.aimY = this.distY / this.dist;
                this.aimZ = this.distZ / this.dist;
            }
        }

        public boolean isBoxBlocked(AxisAlignedBB box) {
            return !this.pixie.field_70170_p.func_184144_a((Entity)this.pixie, box).isEmpty();
        }

        public boolean isPathClear(double howFar) {
            howFar = Math.min(howFar, this.dist);
            AxisAlignedBB box = this.pixie.func_174813_aQ();
            for (double i = 0.5; i < howFar; i += 1.0) {
                if (!this.isBoxBlocked(box.func_72317_d(this.aimX * i, this.aimY * i, this.aimZ * i))) continue;
                return false;
            }
            return !this.isBoxBlocked(box.func_72317_d(this.aimX * howFar, this.aimY * howFar, this.aimZ * howFar));
        }
    }

    public static class PixieTypeData
    implements IEntityLivingData {
        public int typeData;

        public PixieTypeData(int type) {
            this.typeData = type;
        }
    }
}

