/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockFruit
extends Block
implements IGrowable {
    protected static final AxisAlignedBB[] FRUIT_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 1.0, 0.4375, 0.5625, 0.9375, 0.5625), new AxisAlignedBB(0.4375, 1.0, 0.4375, 0.5625, 0.875, 0.5625), new AxisAlignedBB(0.375, 1.0, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.9375, 0.375, 0.625, 0.6875, 0.625)};
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    public static final String name = "fruit";
    private static Map<Species, BlockFruit> speciesFruitMap = new HashMap<Species, BlockFruit>();
    protected ItemStack droppedFruit = ItemStack.field_190927_a;
    protected boolean bonemealable = false;
    protected Species species = Species.NULLSPECIES;

    public static BlockFruit getFruitBlockForSpecies(Species species) {
        return speciesFruitMap.getOrDefault((Object)species, null);
    }

    public BlockFruit() {
        this(name);
    }

    public BlockFruit(String name) {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149675_a(true);
        this.func_149711_c(0.3f);
    }

    public BlockFruit setBonemealable(boolean bonemealable) {
        this.bonemealable = bonemealable;
        return this;
    }

    public void setSpecies(Species species) {
        speciesFruitMap.put(species, this);
        this.species = species;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlock(world, pos, state);
            return;
        }
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        Float season = SeasonHelper.getSeasonValue(world, pos);
        if (season != null && this.getSpecies() != null) {
            if (this.getSpecies().seasonalFruitProductionFactor(world, pos) < 0.2f) {
                this.outOfSeasonAction(world, pos);
                return;
            }
            if (age == 0 && this.getSpecies().testFlowerSeasonHold(world, pos, season.floatValue())) {
                return;
            }
        }
        if (age < 3) {
            boolean doGrow = rand.nextFloat() < this.getGrowthChance(world, pos);
            boolean eventGrow = ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)doGrow);
            if (season != null ? doGrow || eventGrow : eventGrow) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        } else if (age == 3) {
            switch (this.matureAction(world, pos, state, rand)) {
                case Nothing: {
                    break;
                }
                case Drop: {
                    this.dropBlock(world, pos, state);
                    break;
                }
                case Rot: {
                    world.func_175698_g(pos);
                    break;
                }
            }
        }
    }

    protected float getGrowthChance(World world, BlockPos blockPos) {
        return 0.2f;
    }

    protected MatureFruitAction matureAction(World world, BlockPos pos, IBlockState state, Random rand) {
        return MatureFruitAction.Nothing;
    }

    protected void outOfSeasonAction(World world, BlockPos pos) {
        world.func_175698_g(pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.dropBlock(worldIn, pos, state);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 3) {
            this.dropBlock(worldIn, pos, state);
            return true;
        }
        return false;
    }

    private void dropBlock(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        this.func_176226_b(worldIn, pos, state, 0);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getFruitDrop();
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLeaves;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.bonemealable;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        int newAge = MathHelper.func_76125_a((int)(age + 1), (int)0, (int)3);
        if (newAge != age) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(newAge)), 2);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack toDrop;
        super.getDrops(drops, world, pos, state, fortune);
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 3 && !(toDrop = this.getFruitDrop()).func_190926_b()) {
            drops.add((Object)toDrop);
        }
    }

    public BlockFruit setDroppedItem(ItemStack stack) {
        this.droppedFruit = stack;
        return this;
    }

    public ItemStack getFruitDrop() {
        return this.droppedFruit.func_77946_l();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FRUIT_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 3));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) & 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState getStateForAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    public int getAgeForWorldGen(World world, BlockPos pos) {
        Float seasonValue = SeasonHelper.getSeasonValue(world, pos);
        return seasonValue != null ? this.getAgeForSeasonalWorldGen(world, pos, seasonValue.floatValue()) : 3;
    }

    public int getAgeForSeasonalWorldGen(World world, BlockPos pos, float seasonValue) {
        if (this.getSpecies().testFlowerSeasonHold(world, pos, seasonValue)) {
            return 0;
        }
        return Math.min(world.field_73012_v.nextInt(6), 3);
    }

    static enum MatureFruitAction {
        Nothing,
        Drop,
        Rot,
        Custom;

    }
}

