/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestconstruct.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.world.TinkerWorld;

public class DynamicSlimeTreeGenerator
implements IWorldGenerator {
    static final Species blue = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestconstruct", "slimeblue"));
    static final Species purple = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestconstruct", "slimepurple"));
    static final Species magma = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreestconstruct", "slimemagma"));
    public final Species slimeTree;
    public final slimeType typeOfSlime;
    static int maxRadiusToCheck = 6;
    static int tooClose = 3;
    static int maxHeightToCheck = 10;
    static int maxAttempts = 3;
    static int currentAttempt;
    static int radiusForNextAttempt;

    DynamicSlimeTreeGenerator(slimeType type, int attemptNumber) {
        currentAttempt = attemptNumber;
        this.typeOfSlime = type;
        switch (type) {
            case PURPLE: {
                this.slimeTree = purple;
                break;
            }
            case MAGMA: {
                this.slimeTree = magma;
                break;
            }
            default: {
                this.slimeTree = blue;
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    public void generateTree(Random random, World world, BlockPos pos) {
        int height = random.nextInt(4) + 5;
        int maxRad = 2 + random.nextInt(7);
        if ((pos = this.findGround(world, pos)).func_177956_o() < 0) {
            return;
        }
        for (int y = 0; y <= maxHeightToCheck; ++y) {
            for (int x = -maxRadiusToCheck; x <= maxRadiusToCheck; ++x) {
                for (int z = -maxRadiusToCheck; z <= maxRadiusToCheck; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    if (!(world.func_180495_p(checkPos) instanceof BlockBranch) || (maxRad = Math.min(maxRad, Math.min(Math.abs(x), Math.abs(z)))) > tooClose) continue;
                    this.AttemptAgain(random, world, pos);
                    return;
                }
            }
        }
        int yPos = pos.func_177956_o();
        if (yPos >= 1 && yPos + height + 1 <= 256) {
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            boolean isSoil = this.slimeTree.isAcceptableSoil(world, pos.func_177977_b(), state);
            if (isSoil) {
                this.slimeTree.generate(world, pos.func_177977_b(), world.func_180494_b(pos), random, maxRad, SafeChunkBounds.ANY);
            } else {
                this.AttemptAgain(random, world, pos);
            }
        } else {
            this.AttemptAgain(random, world, pos);
        }
    }

    public void AttemptAgain(Random random, World world, BlockPos pos) {
        if (currentAttempt > maxAttempts) {
            return;
        }
        BlockPos newPos = pos.func_177982_a(radiusForNextAttempt + random.nextInt(2 * radiusForNextAttempt), 0, radiusForNextAttempt + random.nextInt(2 * radiusForNextAttempt));
        DynamicSlimeTreeGenerator newTree = new DynamicSlimeTreeGenerator(this.typeOfSlime, currentAttempt + 1);
        newTree.generateTree(random, world, newPos);
    }

    BlockPos findGround(World world, BlockPos pos) {
        do {
            IBlockState state = world.func_180495_p(pos);
            Block heightID = state.func_177230_c();
            IBlockState up = world.func_180495_p(pos.func_177984_a());
            if (heightID != TinkerWorld.slimeDirt && heightID != TinkerWorld.slimeGrass || up.func_177230_c().func_149662_c(up)) continue;
            return pos.func_177984_a();
        } while ((pos = pos.func_177977_b()).func_177956_o() > 0);
        return pos;
    }

    static {
        radiusForNextAttempt = 4;
    }

    public static enum slimeType {
        BLUE,
        PURPLE,
        MAGMA;

    }
}

