/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreestconstruct.growth;

import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SlimeGrowthLogic
implements IGrowthLogicKit {
    private final float energyDivisor;
    private float horizontalLimiter = 16.0f;
    private int heightVariation = 5;

    public SlimeGrowthLogic() {
        this(1.5f);
    }

    public SlimeGrowthLogic(float energyDivisor) {
        this.energyDivisor = energyDivisor;
    }

    public SlimeGrowthLogic setHorizontalLimiter(float energyLimiter) {
        this.horizontalLimiter = energyLimiter;
        return this;
    }

    public SlimeGrowthLogic setHeightVariation(int heightVariation) {
        this.heightVariation = heightVariation;
        return this;
    }

    public int[] directionManipulation(World world, BlockPos pos, Species species, int radius, GrowSignal signal, int[] probMap) {
        EnumFacing originDir = signal.dir.func_176734_d();
        probMap[0] = 0;
        probMap[1] = signal.isInTrunk() ? species.getUpProbability() : 0;
        probMap[5] = !signal.isInTrunk() || signal.isInTrunk() && signal.numSteps % 2 == 1 && radius > 1 ? 2 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        probMap[originDir.ordinal()] = 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        return probMap;
    }

    public EnumFacing newDirectionSelected(Species species, EnumFacing newDir, GrowSignal signal) {
        if (signal.isInTrunk() && newDir != EnumFacing.UP) {
            signal.energy /= this.energyDivisor;
            if (signal.energy > this.horizontalLimiter) {
                signal.energy = this.horizontalLimiter;
            }
        }
        return newDir;
    }

    public float getEnergy(World world, BlockPos pos, Species species, float signalEnergy) {
        long day = world.func_82737_E() / 24000L;
        int month = (int)day / 30;
        return signalEnergy * species.biomeSuitability(world, pos) + (float)(CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)2) % this.heightVariation);
    }
}

