/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data;

import com.google.common.cache.Cache;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Deque;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.Tuple;

public class Tasks {

    public static class StoreHeightData
    implements ITask {
        int x;
        int y;
        int[] data;

        public StoreHeightData(int x, int y, int[] data) {
            this.x = x;
            this.y = y;
            this.data = data;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            ByteBuffer buffer = ByteBuffer.allocate((int)IFileProvider.FileType.HeightData.getOffset());
            buffer.put((byte)1);
            for (int i = 0; i < this.data.length; ++i) {
                buffer.put((byte)(this.data[i] - 128));
            }
            heightData.seek(provider.getOrCreateIndex(this.x, this.y, IFileProvider.FileType.HeightData));
            heightData.write(buffer.array());
        }
    }

    public static class FetchHeightData
    implements ITask {
        int x;
        int y;
        int[] data = new int[0];
        boolean done = false;

        public FetchHeightData(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            ByteBuffer buffer = this.readBytes(heightData, provider.getIndex(this.x, this.y, IFileProvider.FileType.HeightData), IFileProvider.FileType.HeightData.getOffset());
            if (buffer.get() <= 0) {
                this.done = true;
                return;
            }
            int[] fetch = new int[256];
            for (int i = 0; i < fetch.length; ++i) {
                fetch[i] = buffer.get() + 128;
            }
            this.data = fetch;
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public int[] getHeightData() {
            return this.data;
        }
    }

    public static class MassFetchTask
    implements ITask {
        Deque<Tuple<IChunkData, Integer>> result;
        int view;
        IFileProvider.FileType chunkType;

        public MassFetchTask(Deque<Tuple<IChunkData, Integer>> result, int view) {
            this.result = result;
            this.view = view;
            this.chunkType = WorldSeed.isUsingCompression() ? IFileProvider.FileType.Compressed_Chunk_Data : IFileProvider.FileType.Chunk_Data;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            long[] data = new long[1024];
            this.gatherRegions(0, 0, data, chunkData, heightData, provider);
            for (int i = 0; i <= 32; ++i) {
                int q;
                for (q = -i + 1; q <= i; ++q) {
                    this.gatherRegions(i, q, data, chunkData, heightData, provider);
                }
                for (q = i - 1; q >= -i; --q) {
                    this.gatherRegions(q, i, data, chunkData, heightData, provider);
                }
                for (q = i - 1; q >= -i; --q) {
                    this.gatherRegions(-i, q, data, chunkData, heightData, provider);
                }
                for (q = -i + 1; q <= i; ++q) {
                    this.gatherRegions(q, -i, data, chunkData, heightData, provider);
                }
            }
        }

        public void gatherRegions(int xOff, int zOff, long[] data, RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            int pointer = 0;
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    int aX = xOff * 32 + x;
                    int aZ = zOff * 32 + z;
                    if (!provider.hasIndex(aX, aZ)) continue;
                    data[pointer++] = FilePos.asLong(aX, aZ);
                }
            }
            if (pointer <= 0) {
                return;
            }
            long startValue = -1L;
            long size = 0L;
            for (int j = 0; j < pointer; ++j) {
                int x = (int)data[j];
                int z = (int)(data[j] >> 32);
                long index = provider.getIndex(x, z, this.chunkType) / this.chunkType.getOffset();
                if (startValue == -1L) {
                    startValue = index;
                    size = 1L;
                    continue;
                }
                if (index == startValue + size) {
                    ++size;
                    continue;
                }
                this.gatherChunks(startValue, size, chunkData, heightData);
                startValue = -1L;
                size = 0L;
                --j;
            }
            if (size > 0L) {
                this.gatherChunks(startValue, size, chunkData, heightData);
            }
        }

        public void gatherChunks(long startValue, long size, RandomAccessFile chunkData, RandomAccessFile heightData) throws Exception {
            ByteBuffer chunkBuffer = ByteBuffer.allocate((int)(size * this.chunkType.getOffset()));
            chunkData.getChannel().read(chunkBuffer, startValue * this.chunkType.getOffset());
            chunkBuffer.flip();
            ByteBuffer heigthBuffer = ByteBuffer.allocate((int)(size * IFileProvider.FileType.HeightData.getOffset()));
            heightData.getChannel().read(heigthBuffer, startValue * IFileProvider.FileType.HeightData.getOffset());
            heigthBuffer.flip();
            int k = 0;
            while ((long)k < size) {
                chunkBuffer.position((int)((long)k * this.chunkType.getOffset()));
                heigthBuffer.position((int)((long)k * IFileProvider.FileType.HeightData.getOffset()));
                if (chunkBuffer.get() > 0) {
                    this.result.add(new Tuple<IChunkData, Integer>(this.chunkType.createData(chunkBuffer, heigthBuffer), this.view));
                }
                ++k;
            }
        }

        public void gatherChunk(int x, int z, IFileProvider prov, MappedByteBuffer[] chunkData, MappedByteBuffer[] heightData) throws Exception {
            if (!prov.hasIndex(x, z)) {
                return;
            }
            long chunkIndex = prov.getIndex(x, z, this.chunkType);
            long heightIndex = prov.getIndex(x, z, IFileProvider.FileType.HeightData);
            int bufferIndex = (int)(chunkIndex / this.chunkType.getBufferLimit());
            MappedByteBuffer chunkBuffer = chunkData[bufferIndex];
            chunkBuffer.position((int)(chunkIndex - (long)bufferIndex * this.chunkType.getBufferLimit()));
            bufferIndex = (int)(heightIndex / IFileProvider.FileType.HeightData.getBufferLimit());
            MappedByteBuffer heightBuffer = heightData[bufferIndex];
            heightBuffer.position((int)(heightIndex - (long)bufferIndex * IFileProvider.FileType.HeightData.getBufferLimit()));
            if (chunkBuffer.get() <= 0) {
                return;
            }
            this.result.add(new Tuple<IChunkData, Integer>(this.chunkType.createData(chunkBuffer, heightBuffer), this.view));
        }

        public MappedByteBuffer[] fillBuffers(FileChannel channel, IFileProvider.FileType type, IFileProvider provider, int limit) throws Exception {
            MappedByteBuffer[] buffers = new MappedByteBuffer[limit];
            long total = provider.getTotalOffset(type);
            for (int i = 0; i < limit; ++i) {
                long value = total - (long)i * type.getBufferLimit();
                buffers[i] = channel.map(FileChannel.MapMode.READ_ONLY, (long)i * type.getBufferLimit(), Math.max(value, (long)i * type.getBufferLimit()));
            }
            return buffers;
        }
    }

    public static class FetchChunkTask
    implements ITask {
        int chunkX;
        int chunkY;
        IChunkData data;
        boolean done = false;
        IFileProvider.FileType type;
        Cache<FilePos, IChunkData> cache;

        public FetchChunkTask(int x, int z, Cache<FilePos, IChunkData> data) {
            this.cache = data;
            this.chunkX = x;
            this.chunkY = z;
            this.type = WorldSeed.isUsingCompression() ? IFileProvider.FileType.Compressed_Chunk_Data : IFileProvider.FileType.Chunk_Data;
        }

        @Override
        public void handleTask(RandomAccessFile chunkData, RandomAccessFile heightData, IFileProvider provider) throws Exception {
            if (!provider.hasIndex(this.chunkX, this.chunkY)) {
                this.data = null;
                this.done = true;
                return;
            }
            ByteBuffer chunkBuffer = this.readBytes(chunkData, provider.getIndex(this.chunkX, this.chunkY, this.type), this.type.getOffset());
            if (chunkBuffer.get() <= 0) {
                this.data = null;
                this.done = true;
                return;
            }
            ByteBuffer heightBuffer = this.readBytes(chunkData, provider.getIndex(this.chunkX, this.chunkY, IFileProvider.FileType.HeightData), IFileProvider.FileType.HeightData.getOffset());
            this.data = this.type.createData(chunkBuffer, heightBuffer);
            this.done = true;
            if (this.data != null) {
                this.cache.put((Object)new FilePos(this.chunkX, this.chunkY), (Object)this.data);
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public IChunkData getData() {
            return this.data;
        }
    }
}

