/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data;

import java.nio.ByteBuffer;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.client.preview.world.data.ChunkData;
import pregenerator.impl.client.preview.world.data.CompressedChunkData;
import pregenerator.impl.client.preview.world.data.IChunkData;

public interface IFileProvider {
    public boolean hasIndex(int var1, int var2);

    public long getIndex(int var1, int var2, FileType var3);

    public long getOrCreateIndex(int var1, int var2, FileType var3);

    public long getTotalOffset(FileType var1);

    public static enum FileType {
        Chunk_Data(1600L, 1000000L),
        Compressed_Chunk_Data(530L, 4000000L),
        HeightData(260L, 4000000L);

        long offset;
        long buffer;

        private FileType(long offset, long instances) {
            this.offset = offset;
            this.buffer = offset * instances;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getBufferLimit() {
            return this.buffer;
        }

        public IChunkData createData(Chunk chunk) {
            if (this == Compressed_Chunk_Data) {
                return new CompressedChunkData(chunk);
            }
            return new ChunkData(chunk);
        }

        public IChunkData createData(ByteBuffer chunkBuffer, ByteBuffer heightData) throws Exception {
            if (this == Compressed_Chunk_Data) {
                return CompressedChunkData.createDataFromBuffer(chunkBuffer, heightData);
            }
            return ChunkData.createDataFromBuffer(chunkBuffer, heightData);
        }
    }
}

