/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.util;

import blusunrize.immersiveengineering.api.IEEnums;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class MBSideConfig {
    private static final IEEnums.SideConfig[] CONFIG_VALUES = IEEnums.SideConfig.values();
    public final Map<BlockFace, IEEnums.SideConfig> sides = new HashMap<BlockFace, IEEnums.SideConfig>();

    public MBSideConfig(List<BlockFace> sides) {
        for (BlockFace side : sides) {
            this.updateConfig(side, IEEnums.SideConfig.INPUT);
        }
    }

    public MBSideConfig(List<BlockFace> sides, NBTTagList nbt) {
        for (int i = 0; i < sides.size(); ++i) {
            BlockFace side = sides.get(i);
            this.updateConfig(side, i < nbt.func_74745_c() ? CONFIG_VALUES[nbt.func_186858_c(i)] : IEEnums.SideConfig.INPUT);
        }
    }

    public void updateConfig(BlockFace s, IEEnums.SideConfig state) {
        this.sides.put(s, state);
    }

    public IEEnums.SideConfig getConfigForFace(BlockFace s) {
        if (s.face == null) {
            for (BlockFace f : this.sides.keySet()) {
                if (!f.offset.equals((Object)s.offset)) continue;
                return this.sides.get(f);
            }
        }
        return this.sides.getOrDefault(s, IEEnums.SideConfig.NONE);
    }

    public void cycleSide(BlockFace s) {
        this.updateConfig(s, IEEnums.SideConfig.next((IEEnums.SideConfig)this.getConfigForFace(s)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MBSideConfig that = (MBSideConfig)o;
        return this.sides.equals(that.sides);
    }

    public int hashCode() {
        return this.sides.hashCode();
    }

    public String toString() {
        return this.sides.toString();
    }

    public boolean isValid(BlockFace s) {
        return this.sides.containsKey(s);
    }

    public NBTTagList toNBT(List<BlockFace> order) {
        NBTTagList ret = new NBTTagList();
        for (BlockFace f : order) {
            ret.func_74742_a((NBTBase)new NBTTagInt(this.getConfigForFace(f).ordinal()));
        }
        return ret;
    }

    public MBSideConfig copy() {
        MBSideConfig ret = new MBSideConfig((List<BlockFace>)ImmutableList.of());
        ret.sides.putAll(this.sides);
        return ret;
    }

    public static class BlockFace {
        @Nonnull
        public final BlockPos offset;
        @Nullable
        public final EnumFacing face;

        public BlockFace(@Nonnull BlockPos offset, @Nullable EnumFacing face) {
            this.offset = offset;
            this.face = face;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockFace blockFace = (BlockFace)o;
            if (!this.offset.equals((Object)blockFace.offset)) {
                return false;
            }
            return this.face == blockFace.face;
        }

        public int hashCode() {
            int result = this.offset.hashCode();
            result = 31 * result + (this.face != null ? this.face.hashCode() : 0);
            return result;
        }
    }
}

