/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.world;

import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import com.creativemd.creativecore.common.utils.math.vec.VecOrigin;
import com.creativemd.creativecore.common.world.ChunkGeneratorFake;
import com.creativemd.creativecore.common.world.ChunkProviderFake;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.FakeWorldServer;
import com.creativemd.creativecore.common.world.SaveHandlerFake;
import javax.vecmath.Vector3d;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.fml.server.FMLServerHandler;

public class FakeWorld
extends CreativeWorld {
    public MinecraftServer server;
    public IVecOrigin origin;
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender;

    public static FakeWorld createFakeWorld(String name, boolean isRemote) {
        WorldInfo info = new WorldInfo(new WorldSettings(-1L, GameType.NOT_SET, false, false, WorldType.field_180271_f), name);
        SaveHandlerFake saveHandler = new SaveHandlerFake(info);
        WorldProvider provider = new WorldProvider(){

            public DimensionType func_186058_p() {
                return DimensionType.OVERWORLD;
            }

            public boolean func_186056_c(int x, int z) {
                return !this.field_76579_a.func_72916_c(x, z) || !this.field_76579_a.field_73011_w.func_186058_p().shouldLoadSpawn();
            }
        };
        if (!isRemote) {
            return new FakeWorldServer(FMLServerHandler.instance().getServer(), info, provider, isRemote);
        }
        return new FakeWorld(null, info, provider, isRemote);
    }

    protected FakeWorld(MinecraftServer server, WorldInfo info, WorldProvider provider, boolean isRemote) {
        super(new SaveHandlerFake(info), info, provider, new Profiler(), isRemote);
        provider.func_76558_a((World)this);
        this.field_73020_y = this.func_72970_h();
        this.server = server;
    }

    public MinecraftServer func_73046_m() {
        return this.server;
    }

    protected IChunkProvider func_72970_h() {
        return new ChunkProviderFake(this, this.field_73019_z.func_75763_a(this.field_73011_w), new ChunkGeneratorFake(this));
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return ((ChunkProviderFake)this.func_72863_F()).chunkExists(x, z);
    }

    public void func_175688_a(EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.spawnParticle(particleType.func_179348_c(), particleType.func_179344_e(), xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_190523_a(int p_190523_1_, double p_190523_2_, double p_190523_4_, double p_190523_6_, double p_190523_8_, double p_190523_10_, double p_190523_12_, int ... p_190523_14_) {
        Vector3d pos = new Vector3d(p_190523_2_, p_190523_4_, p_190523_6_);
        this.origin.transformPointToWorld(pos);
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldEventListener)this.field_73021_x.get(i)).func_190570_a(p_190523_1_, false, true, pos.x, pos.y, pos.z, p_190523_8_, p_190523_10_, p_190523_12_, p_190523_14_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_175682_a(EnumParticleTypes particleType, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        Vector3d pos = new Vector3d(xCoord, yCoord, zCoord);
        this.origin.transformPointToWorld(pos);
        this.spawnParticle(particleType.func_179348_c(), particleType.func_179344_e() || ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    private void spawnParticle(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        Vector3d pos = new Vector3d(xCoord, yCoord, zCoord);
        this.origin.transformPointToWorld(pos);
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            ((IWorldEventListener)this.field_73021_x.get(i)).func_180442_a(particleID, ignoreRange, pos.x, pos.y, pos.z, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    @Override
    public IVecOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Vector3d vec) {
        this.origin = new VecOrigin(vec);
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public World getParent() {
        return null;
    }

    @Override
    public World getRealWorld() {
        return null;
    }
}

