/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.geo;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.geo.Ray3d;
import com.creativemd.creativecore.common.utils.math.vec.VectorFan;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;

public class NormalPlane {
    public final Vector3f normal;
    public final Vector3f origin;

    public NormalPlane(Vector3f origin, Vector3f normal) {
        this.origin = origin;
        this.normal = new Vector3f(normal);
        this.normal.normalize();
    }

    public NormalPlane(EnumFacing.Axis axis, float value, EnumFacing facing) {
        this.origin = new Vector3f();
        RotationUtils.setValue((Tuple3f)this.origin, value, axis);
        this.normal = new Vector3f();
        RotationUtils.setValue((Tuple3f)this.normal, (float)facing.func_176743_c().func_179524_a(), facing.func_176740_k());
    }

    public Boolean isInFront(Vector3f vec) {
        Vector3f temp = new Vector3f(vec);
        temp.sub((Tuple3f)this.origin);
        float result = this.normal.dot(temp);
        if (result < 0.0f ? result > -1.0E-5f : result < 1.0E-5f) {
            return null;
        }
        return result > 0.0f;
    }

    public boolean cuts(VectorFan strip) {
        boolean front = false;
        boolean back = false;
        for (int i = 0; i < strip.count(); ++i) {
            Boolean result = this.isInFront(strip.get(i));
            if (result == null) {
                return true;
            }
            if (result.booleanValue()) {
                front = true;
            }
            if (!result.booleanValue()) {
                back = true;
            }
            if (!front || !back) continue;
            return true;
        }
        return false;
    }

    public Vector3f intersect(Vector3f start, Vector3f end) {
        Vector3f lineOrigin = start;
        Vector3f lineDirection = new Vector3f(end);
        lineDirection.sub((Tuple3f)lineOrigin);
        lineDirection.normalize();
        if (this.normal.dot(lineDirection) == 0.0f) {
            return null;
        }
        float t = (this.normal.dot(this.origin) - this.normal.dot(lineOrigin)) / this.normal.dot(lineDirection);
        Vector3f point = new Vector3f(lineDirection);
        point.scale(t);
        point.add((Tuple3f)lineOrigin);
        return point;
    }

    public Vector3f intersect(Ray3d ray) {
        if (this.normal.dot(ray.direction) == 0.0f) {
            return null;
        }
        float t = (this.normal.dot(this.origin) - this.normal.dot(ray.origin)) / this.normal.dot(ray.direction);
        Vector3f point = new Vector3f(ray.direction);
        point.scale(t);
        point.add((Tuple3f)ray.origin);
        return point;
    }

    public String toString() {
        return "[o:" + this.origin + ",n:" + this.normal + "]";
    }
}

