/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.client.rendering.face.FaceRenderType;
import com.creativemd.creativecore.client.rendering.face.IFaceRenderType;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.vec.VectorFan;
import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBox
extends AlignedBox {
    private static final VectorFan DOWN = new VectorFan(new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f)});
    private static final VectorFan UP = new VectorFan(new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final VectorFan NORTH = new VectorFan(new Vector3f[]{new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)});
    private static final VectorFan SOUTH = new VectorFan(new Vector3f[]{new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)});
    private static final VectorFan WEST = new VectorFan(new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)});
    private static final VectorFan EAST = new VectorFan(new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    public Block block;
    public int meta = 0;
    public int color = -1;
    public Object customData = null;
    public boolean keepVU = false;
    public boolean allowOverlap = false;
    private IFaceRenderType renderEast = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderWest = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderUp = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderDown = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderSouth = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderNorth = FaceRenderType.INSIDE_RENDERED;
    private Object quadEast = null;
    private Object quadWest = null;
    private Object quadUp = null;
    private Object quadDown = null;
    private Object quadSouth = null;
    private Object quadNorth = null;
    public boolean doesNeedQuadUpdate = true;
    public boolean isEmissive = false;

    public RenderBox(AlignedBox cube, RenderBox box) {
        super(cube);
        this.block = box.block;
        this.meta = box.meta;
        this.color = box.color;
        this.renderEast = box.renderEast;
        this.renderWest = box.renderWest;
        this.renderUp = box.renderUp;
        this.renderDown = box.renderDown;
        this.renderSouth = box.renderSouth;
        this.renderNorth = box.renderNorth;
    }

    public RenderBox(AlignedBox cube, Block block, int meta) {
        super(cube);
        this.block = block;
        this.meta = meta;
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Block block) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.block = block;
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Block block, int meta) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.block = block;
        this.meta = meta;
    }

    public RenderBox setColor(int color) {
        this.color = color;
        return this;
    }

    public RenderBox setKeepUV(boolean keep) {
        this.keepVU = keep;
        return this;
    }

    public void setQuad(EnumFacing facing, List<BakedQuad> quads) {
        BakedQuad quad = quads == null || quads.isEmpty() ? null : (quads.size() == 1 ? quads.get(0) : quads);
        switch (facing) {
            case DOWN: {
                this.quadDown = quad;
                break;
            }
            case EAST: {
                this.quadEast = quad;
                break;
            }
            case NORTH: {
                this.quadNorth = quad;
                break;
            }
            case SOUTH: {
                this.quadSouth = quad;
                break;
            }
            case UP: {
                this.quadUp = quad;
                break;
            }
            case WEST: {
                this.quadWest = quad;
            }
        }
    }

    public Object getQuad(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.quadDown;
            }
            case EAST: {
                return this.quadEast;
            }
            case NORTH: {
                return this.quadNorth;
            }
            case SOUTH: {
                return this.quadSouth;
            }
            case UP: {
                return this.quadUp;
            }
            case WEST: {
                return this.quadWest;
            }
        }
        return null;
    }

    public int countQuads() {
        int quads = 0;
        if (this.quadUp != null) {
            quads += this.quadUp instanceof List ? ((List)this.quadUp).size() : 1;
        }
        if (this.quadDown != null) {
            quads += this.quadDown instanceof List ? ((List)this.quadDown).size() : 1;
        }
        if (this.quadEast != null) {
            quads += this.quadEast instanceof List ? ((List)this.quadEast).size() : 1;
        }
        if (this.quadWest != null) {
            quads += this.quadWest instanceof List ? ((List)this.quadWest).size() : 1;
        }
        if (this.quadSouth != null) {
            quads += this.quadSouth instanceof List ? ((List)this.quadSouth).size() : 1;
        }
        if (this.quadNorth != null) {
            quads += this.quadNorth instanceof List ? ((List)this.quadNorth).size() : 1;
        }
        return quads;
    }

    public IBlockState getModelState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.block.getExtendedState(state, world, pos);
    }

    public IBlockState getBlockState() {
        if (this.meta != -1) {
            return BlockUtils.getState(this.block, this.meta);
        }
        return this.block.func_176223_P();
    }

    public IBlockState getBlockState(Block block) {
        if (this.meta != -1) {
            return BlockUtils.getState(block, this.meta);
        }
        return block.func_176223_P();
    }

    public void setType(EnumFacing facing, IFaceRenderType renderer) {
        switch (facing) {
            case DOWN: {
                this.renderDown = renderer;
                break;
            }
            case EAST: {
                this.renderEast = renderer;
                break;
            }
            case NORTH: {
                this.renderNorth = renderer;
                break;
            }
            case SOUTH: {
                this.renderSouth = renderer;
                break;
            }
            case UP: {
                this.renderUp = renderer;
                break;
            }
            case WEST: {
                this.renderWest = renderer;
            }
        }
    }

    public IFaceRenderType getType(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown;
            }
            case EAST: {
                return this.renderEast;
            }
            case NORTH: {
                return this.renderNorth;
            }
            case SOUTH: {
                return this.renderSouth;
            }
            case UP: {
                return this.renderUp;
            }
            case WEST: {
                return this.renderWest;
            }
        }
        return FaceRenderType.INSIDE_RENDERED;
    }

    public boolean renderSide(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown.shouldRender();
            }
            case EAST: {
                return this.renderEast.shouldRender();
            }
            case NORTH: {
                return this.renderNorth.shouldRender();
            }
            case SOUTH: {
                return this.renderSouth.shouldRender();
            }
            case UP: {
                return this.renderUp.shouldRender();
            }
            case WEST: {
                return this.renderWest.shouldRender();
            }
        }
        return true;
    }

    public boolean intersectsWithFace(EnumFacing facing, RenderInformationHolder holder, BlockPos offset) {
        switch (facing.func_176740_k()) {
            case X: {
                return holder.maxY > this.minY - (float)offset.func_177956_o() && holder.minY < this.maxY - (float)offset.func_177956_o() && holder.maxZ > this.minZ - (float)offset.func_177952_p() && holder.minZ < this.maxZ - (float)offset.func_177952_p();
            }
            case Y: {
                return holder.maxX > this.minX - (float)offset.func_177958_n() && holder.minX < this.maxX - (float)offset.func_177958_n() && holder.maxZ > this.minZ - (float)offset.func_177952_p() && holder.minZ < this.maxZ - (float)offset.func_177952_p();
            }
            case Z: {
                return holder.maxX > this.minX - (float)offset.func_177958_n() && holder.minX < this.maxX - (float)offset.func_177958_n() && holder.maxY > this.minY - (float)offset.func_177956_o() && holder.minY < this.maxY - (float)offset.func_177956_o();
            }
        }
        return false;
    }

    protected Object getRenderQuads(EnumFacing facing) {
        if (this.getType(facing).hasCachedFans()) {
            return this.getType(facing).getCachedFans();
        }
        switch (facing) {
            case DOWN: {
                return DOWN;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    protected List<BakedQuad> getBakedQuad(IBlockAccess world, IBakedModel blockModel, IBlockState state, EnumFacing facing, BlockPos pos, BlockRenderLayer layer, long rand) {
        return OptifineHelper.getRenderQuads(blockModel.func_188616_a(state, facing, rand), world, state, pos, facing, layer, rand);
    }

    protected float getOffsetX() {
        return this.minX;
    }

    protected float getOffsetY() {
        return this.minY;
    }

    protected float getOffsetZ() {
        return this.minZ;
    }

    protected float getOverallScale(EnumFacing facing) {
        return this.getType(facing).getScale();
    }

    protected float getScaleX() {
        return this.maxX - this.minX;
    }

    protected float getScaleY() {
        return this.maxY - this.minY;
    }

    protected float getScaleZ() {
        return this.maxZ - this.minZ;
    }

    protected boolean scaleAndOffsetQuads(EnumFacing facing) {
        return true;
    }

    protected boolean onlyScaleOnceNoOffset(EnumFacing facing) {
        return this.getType(facing).hasCachedFans();
    }

    public List<BakedQuad> getBakedQuad(IBlockAccess world, @Nullable BlockPos pos, BlockPos offset, IBlockState state, IBakedModel blockModel, EnumFacing facing, BlockRenderLayer layer, long rand, boolean overrideTint, int defaultColor) {
        List<BakedQuad> blockQuads = this.getBakedQuad(world, blockModel, state, facing, pos, layer, rand);
        if (blockQuads.isEmpty()) {
            return Collections.emptyList();
        }
        RenderInformationHolder holder = new RenderInformationHolder(facing, this.color != -1 ? this.color : defaultColor);
        holder.offset = offset;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < blockQuads.size(); ++i) {
            holder.setQuad(blockQuads.get(i), overrideTint, defaultColor);
            if (!this.isEmissive && OptifineHelper.isEmissive(holder.quad.func_187508_a())) {
                this.isEmissive = true;
            }
            VertexFormat format = holder.quad.getFormat();
            int[] data = holder.quad.func_178209_a();
            int index = 0;
            int uvIndex = index + format.func_177344_b(0) / 4;
            float tempMinX = Float.intBitsToFloat(data[index]);
            float tempMinY = Float.intBitsToFloat(data[index + 1]);
            float tempMinZ = Float.intBitsToFloat(data[index + 2]);
            float tempU = Float.intBitsToFloat(data[uvIndex]);
            float tempV = Float.intBitsToFloat(data[uvIndex + 1]);
            holder.uvInverted = false;
            index = 1 * format.func_181719_f();
            uvIndex = index + format.func_177344_b(0) / 4;
            holder.uvInverted = tempMinX != Float.intBitsToFloat(data[index]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? EnumFacing.Axis.X != RotationUtils.getUAxisFromFacing(facing) : EnumFacing.Axis.X != RotationUtils.getVAxisFromFacing(facing)) : (tempMinY != Float.intBitsToFloat(data[index + 1]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? EnumFacing.Axis.Y != RotationUtils.getUAxisFromFacing(facing) : EnumFacing.Axis.Y != RotationUtils.getVAxisFromFacing(facing)) : (tempU != Float.intBitsToFloat(data[uvIndex]) ? EnumFacing.Axis.Z != RotationUtils.getUAxisFromFacing(facing) : EnumFacing.Axis.Z != RotationUtils.getVAxisFromFacing(facing)));
            index = 2 * format.func_181719_f();
            float tempMaxX = Float.intBitsToFloat(data[index]);
            float tempMaxY = Float.intBitsToFloat(data[index + 1]);
            float tempMaxZ = Float.intBitsToFloat(data[index + 2]);
            holder.setBounds(tempMinX, tempMinY, tempMinZ, tempMaxX, tempMaxY, tempMaxZ);
            if (!this.intersectsWithFace(facing, holder, offset)) continue;
            uvIndex = format.func_177344_b(0) / 4;
            float u1 = Float.intBitsToFloat(data[uvIndex]);
            float v1 = Float.intBitsToFloat(data[uvIndex + 1]);
            uvIndex = 2 * format.func_181719_f() + format.func_177344_b(0) / 4;
            float u2 = Float.intBitsToFloat(data[uvIndex]);
            float v2 = Float.intBitsToFloat(data[uvIndex + 1]);
            if (holder.uvInverted) {
                holder.sizeU = RotationUtils.getVFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getVFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = RotationUtils.getUFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getUFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            } else {
                holder.sizeU = RotationUtils.getUFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getUFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = RotationUtils.getVFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getVFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            }
            Object renderQuads = this.getRenderQuads(holder.facing);
            if (renderQuads instanceof List) {
                for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                    ((VectorFan)((List)renderQuads).get(j)).generate(holder, quads);
                }
                continue;
            }
            if (!(renderQuads instanceof VectorFan)) continue;
            ((VectorFan)renderQuads).generate(holder, quads);
        }
        return quads;
    }

    public void deleteQuadCache() {
        this.doesNeedQuadUpdate = true;
        this.quadEast = null;
        this.quadWest = null;
        this.quadUp = null;
        this.quadDown = null;
        this.quadSouth = null;
        this.quadNorth = null;
    }

    protected void setupPreviewRendering(double x, double y, double z) {
        GlStateManager.func_179137_b((double)(x + (double)this.minX), (double)(y + (double)this.minY), (double)(z + (double)this.minZ));
        GlStateManager.func_179152_a((float)(this.maxX - this.minX), (float)(this.maxY - this.minY), (float)(this.maxZ - this.minZ));
    }

    public void renderPreview(double x, double y, double z, int alpha) {
        int red = ColorUtils.getRed(this.color);
        int green = ColorUtils.getGreen(this.color);
        int blue = ColorUtils.getBlue(this.color);
        GlStateManager.func_179094_E();
        this.setupPreviewRendering(x, y, z);
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            Object renderQuads = this.getRenderQuads(EnumFacing.field_82609_l[i]);
            if (renderQuads instanceof List) {
                for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                    ((VectorFan)((List)renderQuads).get(j)).renderPreview(red, green, blue, alpha);
                }
                continue;
            }
            if (!(renderQuads instanceof VectorFan)) continue;
            ((VectorFan)renderQuads).renderPreview(red, green, blue, alpha);
        }
        GlStateManager.func_179121_F();
    }

    public void renderLines(double x, double y, double z, int alpha) {
        int red = ColorUtils.getRed(this.color);
        int green = ColorUtils.getGreen(this.color);
        int blue = ColorUtils.getBlue(this.color);
        if (red == 1 && green == 1 && blue == 1) {
            blue = 0;
            green = 0;
            red = 0;
        }
        GlStateManager.func_179094_E();
        if (this.scaleAndOffsetQuads(null)) {
            GlStateManager.func_179137_b((double)(x + (double)this.minX), (double)(y + (double)this.minY), (double)(z + (double)this.minZ));
            GlStateManager.func_179152_a((float)(this.maxX - this.minX), (float)(this.maxY - this.minY), (float)(this.maxZ - this.minZ));
        } else {
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        }
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            Object renderQuads = this.getRenderQuads(EnumFacing.field_82609_l[i]);
            if (renderQuads instanceof List) {
                for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                    ((VectorFan)((List)renderQuads).get(j)).renderLines(red, green, blue, alpha);
                }
                continue;
            }
            if (!(renderQuads instanceof VectorFan)) continue;
            ((VectorFan)renderQuads).renderLines(red, green, blue, alpha);
        }
        GlStateManager.func_179121_F();
    }

    public boolean isTranslucent() {
        if (ColorUtils.isTransparent(this.color)) {
            return true;
        }
        return !this.getBlockState().func_185904_a().func_76228_b() || !this.getBlockState().func_185904_a().func_76220_a() || !this.getBlockState().func_185914_p();
    }

    public class RenderInformationHolder {
        public final EnumFacing facing;
        public final int color;
        public BlockPos offset;
        public boolean shouldOverrideColor;
        public BakedQuad quad;
        public final boolean scaleAndOffset;
        public final float offsetX;
        public final float offsetY;
        public final float offsetZ;
        public final float scaleX;
        public final float scaleY;
        public final float scaleZ;
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;
        public float sizeX;
        public float sizeY;
        public float sizeZ;
        public boolean uvInverted;
        public float sizeU;
        public float sizeV;

        public RenderInformationHolder(EnumFacing facing, int color) {
            this.color = color;
            this.facing = facing;
            RenderBox box = this.getBox();
            this.scaleAndOffset = box.scaleAndOffsetQuads(facing);
            if (this.scaleAndOffset) {
                if (box.onlyScaleOnceNoOffset(facing)) {
                    this.offsetZ = 0.0f;
                    this.offsetY = 0.0f;
                    this.offsetX = 0.0f;
                    this.scaleY = this.scaleZ = box.getOverallScale(facing);
                    this.scaleX = this.scaleZ;
                } else {
                    this.offsetX = box.getOffsetX();
                    this.offsetY = box.getOffsetY();
                    this.offsetZ = box.getOffsetZ();
                    this.scaleX = box.getScaleX();
                    this.scaleY = box.getScaleY();
                    this.scaleZ = box.getScaleZ();
                }
            } else {
                this.offsetZ = 0.0f;
                this.offsetY = 0.0f;
                this.offsetX = 0.0f;
                this.scaleZ = 0.0f;
                this.scaleY = 0.0f;
                this.scaleX = 0.0f;
            }
        }

        public void setQuad(BakedQuad quad, boolean overrideTint, int defaultColor) {
            this.quad = quad;
            this.shouldOverrideColor = overrideTint && (defaultColor == -1 || quad.func_178212_b()) && this.color != -1;
        }

        public void setBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this.minX = Math.min(minX, maxX);
            this.minY = Math.min(minY, maxY);
            this.minZ = Math.min(minZ, maxZ);
            this.maxX = Math.max(minX, maxX);
            this.maxY = Math.max(minY, maxY);
            this.maxZ = Math.max(minZ, maxZ);
            this.sizeX = this.maxX - this.minX;
            this.sizeY = this.maxY - this.minY;
            this.sizeZ = this.maxZ - this.minZ;
        }

        public RenderBox getBox() {
            return RenderBox.this;
        }
    }
}

