/*
 * Decompiled with CFR 0.152.
 */
package com.arcaneware.unifier.shared;

import com.arcaneware.unifier.OreUnifier;
import com.arcaneware.unifier.config.Config;
import com.arcaneware.unifier.shared.command.UnifierCommand;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SharedProxy {
    public void preInit(FMLPreInitializationEvent event) {
        Config.instance().reload();
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new UnifierCommand());
    }

    public void serverStop(FMLServerStoppingEvent event) {
    }

    public void onItemToss(ItemTossEvent event) {
        if (Config.instance().onItemTossEnable) {
            ItemStack stack = OreUnifier.unify(event.getEntityItem().func_92059_d());
            if (!event.getEntityItem().func_92059_d().func_77969_a(stack)) {
                event.getEntityItem().func_92058_a(stack);
            }
        }
    }

    public void onItemPickup(EntityItemPickupEvent event) {
        if (Config.instance().onItemPickupEnable) {
            ItemStack stack = OreUnifier.unify(event.getItem().func_92059_d());
            if (!event.getItem().func_92059_d().func_77969_a(stack)) {
                event.getItem().func_92058_a(stack);
            }
        }
    }

    public void inInventory(PlayerContainerEvent event) {
        Container container = event.getEntityPlayer().field_71069_bz;
        if (Config.instance().inPlayerInventoryEnable && container instanceof ContainerPlayer) {
            try {
                for (int i = 0; i < container.field_75153_a.size(); ++i) {
                    ItemStack origin = container.func_75139_a(i).func_75211_c();
                    ItemStack stack = OreUnifier.unify(origin);
                    if (stack == null || origin == null || origin.func_77969_a(stack)) continue;
                    container.func_75141_a(i, stack);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Config.instance().inOtherInventoryEnable && !(container instanceof ContainerPlayer)) {
            try {
                Container cont = event.getEntityPlayer().field_71070_bA;
                for (int i = 0; i < cont.field_75153_a.size(); ++i) {
                    ItemStack origin = cont.func_75139_a(i).func_75211_c();
                    ItemStack stack = OreUnifier.unify(origin);
                    if (stack == null || origin == null || origin.func_77969_a(stack) || container.func_75139_a((int)i).field_75224_c instanceof InventoryPlayer || Config.instance().inPlayerInventoryEnable || !container.func_75139_a(i).func_75214_a(stack)) continue;
                    container.func_75141_a(i, stack);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onLivingDrops(LivingDropsEvent event) {
        if (Config.instance().onLivingDropsEnable) {
            for (int i = 0; i < event.getDrops().size(); ++i) {
                ItemStack itemstack = OreUnifier.unify(((EntityItem)event.getDrops().get(i)).func_92059_d());
                if (((EntityItem)event.getDrops().get(i)).func_92059_d().func_77969_a(itemstack)) continue;
                ((EntityItem)event.getDrops().get(i)).func_92058_a(itemstack);
            }
        }
    }

    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (Config.instance().onBlockHarvestEnable) {
            for (int i = 0; i < event.getDrops().size(); ++i) {
                ItemStack stack = OreUnifier.unify((ItemStack)event.getDrops().get(i));
                if (((ItemStack)event.getDrops().get(i)).func_77969_a(stack)) continue;
                event.getDrops().set(i, stack);
            }
        }
    }

    public void onChunkLoad(ChunkEvent.Load event) {
        if (Config.instance().onChunkLoadEnable) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < event.getWorld().func_72800_K(); ++j) {
                    for (int k = 0; k < 16; ++k) {
                        IBlockState blockState = event.getChunk().func_177435_g(new BlockPos(i, j, k));
                        if (event.getWorld().func_175623_d(new BlockPos(i, j, k))) {
                            return;
                        }
                        int meta = blockState.func_177230_c().func_176201_c(blockState);
                        ItemStack stack = OreUnifier.unify(new ItemStack(blockState.func_177230_c(), 1, meta));
                        if (stack == null || stack.func_77973_b() == null) continue;
                        int copyMeta = stack.func_77960_j();
                        IBlockState copyBlockState = Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(copyMeta);
                        if (blockState.func_177230_c() == copyBlockState.func_177230_c() && meta == copyMeta) continue;
                        BlockPos newPos = new BlockPos(event.getChunk().field_76635_g * 16 + i, j, event.getChunk().field_76647_h * 16 + k);
                        event.getWorld().func_180501_a(newPos, copyBlockState, 3);
                    }
                }
            }
        }
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (Config.instance().inTileEntityEnable && event.side.isServer() && event.phase == TickEvent.Phase.END) {
            try {
                CopyOnWriteArrayList entityList = null;
                entityList = new CopyOnWriteArrayList(event.world.field_147482_g);
                if (entityList != null) {
                    for (TileEntity entity : entityList) {
                        IInventory inv;
                        if (entity == null || !(entity instanceof IInventory) || (inv = (IInventory)entity) == null) continue;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack stack = OreUnifier.unify(inv.func_70301_a(i));
                            if (stack == null || stack.func_190926_b() || inv.func_70301_a(i).func_77969_a(stack)) continue;
                            inv.func_70299_a(i, stack);
                            OreUnifier.condense(inv, 0, stack, i);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

