/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.tile.IEmberInjectable;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockSeedNew;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntitySeedNew
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberInjectable,
ISoundController,
IExtraCapabilityInformation {
    BlockSeedNew type;
    protected boolean[] willSpawn;
    protected int size = 0;
    protected int xp = 0;
    protected int bonusParts = 0;
    protected int ticksExisted = 0;
    protected Random random = new Random();
    public static final int SOUND_AMBIENT = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntitySeedNew() {
        this.resetSpawns();
    }

    public void resetSpawns() {
        int segments = Math.max(6 + this.bonusParts, 1);
        this.willSpawn = new boolean[segments += this.getLevelBonus(this.getLevel(this.xp))];
        for (int i = 0; i < this.willSpawn.length; ++i) {
            this.willSpawn[i] = this.random.nextInt(3) == 0;
        }
    }

    private int getLevelBonus(int level) {
        if (level > 50) {
            return this.getLevelBonus(50) + (level - 50) / 25;
        }
        if (level > 20) {
            return this.getLevelBonus(20) + (level - 20) / 10;
        }
        if (level > 10) {
            return this.getLevelBonus(10) + (level - 10) / 5;
        }
        if (level > 5) {
            return this.getLevelBonus(5) + (level - 5) / 3;
        }
        return (level + 1) / 2;
    }

    public String getSpawnString() {
        String result = "";
        for (int i = 0; i < this.willSpawn.length; ++i) {
            result = result + (this.willSpawn[i] ? "1" : "0");
        }
        return result;
    }

    public void loadSpawnsFromString(String s) {
        this.willSpawn = new boolean[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            this.willSpawn[i] = s.substring(i, i + 1).compareTo("1") == 0;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("spawns", this.getSpawnString());
        tag.func_74768_a("size", this.size);
        tag.func_74768_a("xp", this.xp);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.loadSpawnsFromString(tag.func_74779_i("spawns"));
        this.size = tag.func_74762_e("size");
        this.xp = tag.func_74762_e("xp");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        ++this.ticksExisted;
        if (this.size > 1000) {
            this.size = 0;
            ItemStack[] stacks = this.getNuggetDrops(this.willSpawn.length);
            double oneAng = 360.0 / (double)this.willSpawn.length;
            for (int i = 0; i < this.willSpawn.length; ++i) {
                if (!this.willSpawn[i] || this.func_145831_w().field_72995_K) continue;
                ItemStack nuggetStack = stacks[i];
                float offX = 0.4f * (float)Math.sin(Math.toRadians((double)i * oneAng));
                float offZ = 0.4f * (float)Math.cos(Math.toRadians((double)i * oneAng));
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)offX, (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)offZ, nuggetStack));
                this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)offX, (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)offZ, SoundManager.METAL_SEED_PING, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.func_70296_d();
            this.resetSpawns();
        }
    }

    private BlockSeedNew getBlockSeedType() {
        Block block;
        if (this.type == null && (block = this.func_145838_q()) instanceof BlockSeedNew) {
            this.type = (BlockSeedNew)block;
        }
        return this.type != null ? this.type : (BlockSeedNew)RegistryManager.seed_iron;
    }

    protected ItemStack[] getNuggetDrops(int n) {
        return this.getBlockSeedType().getNuggetDrops(this, n);
    }

    public void addExperience(int xp) {
        this.xp += xp;
    }

    public int getRequiredExperienceForLevel(int level) {
        return level * (level + 1) / 2 * 1000;
    }

    public int getLevel(int xp) {
        return (int)Math.floor((Math.sqrt(5.0) * Math.sqrt(xp + 125) - 25.0) / 50.0);
    }

    @Override
    public void inject(TileEntity injector, double ember) {
        ++this.size;
        this.addExperience(1);
        this.func_70296_d();
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.METAL_SEED_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public ResourceLocation getTexture() {
        return this.getBlockSeedType().getTexture(this);
    }

    @Override
    public void addOtherDescription(List<String> strings, EnumFacing facing) {
        int level = this.getLevel(this.xp);
        int requiredCurrentXP = this.getRequiredExperienceForLevel(level);
        int requiredNextXP = this.getRequiredExperienceForLevel(level + 1);
        strings.add(Embers.proxy.formatLocalize("embers.tooltip.crystal.level", level));
        strings.add(Embers.proxy.formatLocalize("embers.tooltip.crystal.xp", this.xp - requiredCurrentXP, requiredNextXP - requiredCurrentXP));
    }
}

