/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.block.BlockClockworkAttenuator;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeClockworkAttenuator;
import teamroots.embers.util.Misc;

public class TileEntityClockworkAttenuator
extends TileEntity
implements ITickable,
ITileEntityBase {
    public UpgradeClockworkAttenuator upgrade;
    public boolean powered;
    public boolean lastPowered = false;
    public double activeSpeed = 0.0;
    public double inactiveSpeed = 1.0;
    public double angle;
    public double lastAngle;
    private Random random = new Random();
    public double[] validSpeeds = new double[]{0.0, 0.0625, 0.125, 0.25, 0.5, 1.0};

    public TileEntityClockworkAttenuator() {
        this.upgrade = new UpgradeClockworkAttenuator(this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("active_speed", this.activeSpeed);
        tag.func_74780_a("inactive_speed", this.inactiveSpeed);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.activeSpeed = tag.func_74769_h("active_speed");
        this.inactiveSpeed = tag.func_74769_h("inactive_speed");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockClockworkAttenuator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockClockworkAttenuator.facing);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing().func_176734_d() == facing;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().func_176734_d() == facing) {
            return (T)this.upgrade;
        }
        return (T)super.getCapability(capability, facing);
    }

    public double getSpeed() {
        return this.powered ? this.activeSpeed : this.inactiveSpeed;
    }

    public double getNext(double current) {
        for (int i = 0; i < this.validSpeeds.length - 1; ++i) {
            double a = this.validSpeeds[i];
            double b = this.validSpeeds[i + 1];
            if (!(b > current) || !(a <= current)) continue;
            return b;
        }
        return current;
    }

    public double getPrevious(double current) {
        for (int i = 0; i < this.validSpeeds.length - 1; ++i) {
            double a = this.validSpeeds[i];
            double b = this.validSpeeds[i + 1];
            if (!(b >= current) || !(a < current)) continue;
            return a;
        }
        return current;
    }

    public void func_73660_a() {
        this.lastPowered = this.powered;
        this.powered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (this.field_145850_b.field_72995_K) {
            this.lastAngle = this.angle;
            this.angle += this.getSpeed();
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.powered) {
            this.activeSpeed = player.func_70093_af() ? this.getPrevious(this.activeSpeed) : this.getNext(this.activeSpeed);
        } else {
            this.inactiveSpeed = player.func_70093_af() ? this.getPrevious(this.inactiveSpeed) : this.getNext(this.inactiveSpeed);
        }
        this.func_70296_d();
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }
}

